(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["main"],{

/***/ "+kh+":
/*!*********************************************************!*\
  !*** ./src/app/shared/googlemap/googlemap.component.ts ***!
  \*********************************************************/
/*! exports provided: GooglemapComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GooglemapComponent", function() { return GooglemapComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _agm_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @agm/core */ "pxUr");
/* harmony import */ var src_app_services_storage_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/services/storage.service */ "n90K");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");




const _c0 = ["search"];
/**
 * Google map component
 */
class GooglemapComponent {
    /**
     * @constructor
     */
    constructor(mapsAPILoader, ngZone, storageService) {
        this.mapsAPILoader = mapsAPILoader;
        this.ngZone = ngZone;
        this.storageService = storageService;
        this.latitude = 23.4241;
        this.longitude = 53.8478;
        this.zoom = 6;
    }
    /**
     * on init
     */
    ngOnInit() {
    }
    /**
     * ng after content Init
     */
    ngAfterContentInit() {
        window.scroll(0, 0);
        // load Places Autocomplete
        this.mapsAPILoader.load().then(() => {
            this.geoCoder = new google.maps.Geocoder();
            this.setCurrentLocation();
            console.log('set current location from map component', this.setCurrentLocation);
            const autocomplete = new google.maps.places.Autocomplete(this.searchElementRef.nativeElement);
            autocomplete.addListener('place_changed', () => {
                this.ngZone.run(() => {
                    // get the place result
                    const place = autocomplete.getPlace();
                    console.log('place from map component', place);
                    // verify result
                    if (place.geometry === undefined || place.geometry === null) {
                        return;
                    }
                    // set latitude, longitude and zoom
                    this.latitude = place.geometry.location.lat();
                    this.longitude = place.geometry.location.lng();
                    this.setaddressinput = place.formatted_address;
                    // store in local storage
                    this.storageService.setItem('lat', JSON.stringify(this.latitude));
                    this.storageService.setItem('lng', JSON.stringify(this.longitude));
                    this.storageService.setItem('address', JSON.stringify(this.setaddressinput));
                });
            });
        });
    }
    /**
     * Get Current Location Coordinates
     */
    setCurrentLocation() {
        navigator.permissions && navigator.permissions.query({ name: 'geolocation' }).then((PermissionStatus) => {
            if (PermissionStatus.state == 'granted') {
                if ('geolocation' in navigator) {
                    navigator.geolocation.getCurrentPosition((position) => {
                        this.latitude = position.coords.latitude;
                        this.longitude = position.coords.longitude;
                        this.getAddress(this.latitude, this.longitude);
                        console.log('get address from map component', this.getAddress);
                    });
                }
            }
            else
                (PermissionStatus.state == 'prompt');
            {
                this.getAddress(this.latitude, this.longitude);
                console.log('get address1 from map component', this.getAddress);
            }
            // else {
            //   this.getAddress(25.340630377372914, 55.38592908121872);
            // }
        });
    }
    /**
     * Get address
     * @param {number} latitude
     * @param {number} longitude
     */
    getAddress(latitude, longitude) {
        this.geoCoder.geocode({ 'location': { lat: latitude, lng: longitude } }, (results, status) => {
            if (status === 'OK') {
                if (results[0]) {
                    this.address = results[0].formatted_address;
                    this.setaddressinput = this.address;
                    localStorage.setItem('lat', JSON.stringify(this.latitude));
                    localStorage.setItem('lng', JSON.stringify(this.longitude));
                    localStorage.setItem('address', JSON.stringify(this.setaddressinput));
                }
                else {
                    console.error('No results found');
                }
            }
            else {
                console.error('Geocoder failed due to: ' + status);
            }
        });
    }
    /**
     * Marker drag event
     * @param {object} $event
     */
    markerDragEnd($event) {
        this.latitude = $event.latLng.lat();
        this.longitude = $event.latLng.lng();
        this.getAddress(this.latitude, this.longitude);
    }
}
GooglemapComponent.ɵfac = function GooglemapComponent_Factory(t) { return new (t || GooglemapComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_agm_core__WEBPACK_IMPORTED_MODULE_1__["MapsAPILoader"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["NgZone"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](src_app_services_storage_service__WEBPACK_IMPORTED_MODULE_2__["StorageService"])); };
GooglemapComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: GooglemapComponent, selectors: [["app-googlemap"]], viewQuery: function GooglemapComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_c0, 1);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.searchElementRef = _t.first);
    } }, decls: 15, vars: 10, consts: [[1, "map-section"], [1, "searchlocation"], ["type", "text", "autocorrect", "off", "autocapitalize", "off", "spellcheck", "off", "type", "text", 1, "form-control", "rounded", "shadow", 3, "placeholder", "keydown.enter"], ["search", ""], [1, "map", 3, "latitude", "longitude", "zoom"], [3, "latitude", "longitude", "markerDraggable", "dragEnd"], [1, "locationdetails", "text-dark"], [1, "row", "mt-3"], [1, "col-md-1", "text-right", "col-2"], ["src", "assets/images/icons/location.png"], [1, "col-md-11", "p-0", "col-10"], [1, "clearfix"]], template: function GooglemapComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "input", 2, 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("keydown.enter", function GooglemapComponent_Template_input_keydown_enter_2_listener($event) { return $event.preventDefault(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "agm-map", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "agm-marker", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("dragEnd", function GooglemapComponent_Template_agm_marker_dragEnd_6_listener($event) { return ctx.markerDragEnd($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](10, "img", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "h6");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](14, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](4, 8, "Search Nearest Location"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("latitude", ctx.latitude)("longitude", ctx.longitude)("zoom", ctx.zoom);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("latitude", ctx.latitude)("longitude", ctx.longitude)("markerDraggable", true);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx.setaddressinput);
    } }, directives: [_agm_core__WEBPACK_IMPORTED_MODULE_1__["AgmMap"], _agm_core__WEBPACK_IMPORTED_MODULE_1__["AgmMarker"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_3__["TranslatePipe"]], styles: [".map-section[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 20em;\n}\n.map-section[_ngcontent-%COMP%]   .searchlocation[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 60%;\n  top: 25px;\n  z-index: 999999999;\n  left: 0px;\n  right: 0;\n  margin-left: auto;\n  margin-right: auto;\n}\n.map-section[_ngcontent-%COMP%]   .searchlocation[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  height: 40px;\n  font-size: 15px;\n  padding-left: 30px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uXFwuLlxcLi5cXC4uXFxnb29nbGVtYXAuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQ0k7RUFDSSxXQUFBO0VBQ0EsWUFBQTtBQUFSO0FBR0k7RUFDSSxrQkFBQTtFQUNBLFVBQUE7RUFDQSxTQUFBO0VBQ0Esa0JBQUE7RUFDQSxTQUFBO0VBQ0EsUUFBQTtFQUNBLGlCQUFBO0VBQ0Esa0JBQUE7QUFEUjtBQUlJO0VBQ0ksWUFBQTtFQUNBLGVBQUE7RUFDQSxrQkFBQTtBQUZSIiwiZmlsZSI6Imdvb2dsZW1hcC5jb21wb25lbnQuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIi5tYXAtc2VjdGlvbiB7XHJcbiAgICAubWFwIHtcclxuICAgICAgICB3aWR0aDogMTAwJTtcclxuICAgICAgICBoZWlnaHQ6IDIwZW07XHJcbiAgICB9XHJcblxyXG4gICAgLnNlYXJjaGxvY2F0aW9uIHtcclxuICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XHJcbiAgICAgICAgd2lkdGg6IDYwJTtcclxuICAgICAgICB0b3A6IDI1cHg7XHJcbiAgICAgICAgei1pbmRleDogOTk5OTk5OTk5O1xyXG4gICAgICAgIGxlZnQ6IDBweDtcclxuICAgICAgICByaWdodDogMDtcclxuICAgICAgICBtYXJnaW4tbGVmdDogYXV0bztcclxuICAgICAgICBtYXJnaW4tcmlnaHQ6IGF1dG87XHJcbiAgICB9XHJcblxyXG4gICAgLnNlYXJjaGxvY2F0aW9uIGlucHV0IHtcclxuICAgICAgICBoZWlnaHQ6IDQwcHg7XHJcbiAgICAgICAgZm9udC1zaXplOiAxNXB4O1xyXG4gICAgICAgIHBhZGRpbmctbGVmdDogMzBweDtcclxuICAgIH1cclxufSJdfQ== */"] });


/***/ }),

/***/ "+z6I":
/*!***************************************************!*\
  !*** ./src/app/shared/review/review.component.ts ***!
  \***************************************************/
/*! exports provided: ReviewComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ReviewComponent", function() { return ReviewComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! sweetalert2/dist/sweetalert2.js */ "PdH4");
/* harmony import */ var sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ng-bootstrap/ng-bootstrap */ "1kSV");
/* harmony import */ var src_app_services_modal_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/services/modal.service */ "VQPA");
/* harmony import */ var src_app_services_storage_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! src/app/services/storage.service */ "n90K");
/* harmony import */ var src_app_services_product_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! src/app/services/product.service */ "Gdn9");
/* harmony import */ var src_app_services_translation_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! src/app/services/translation.service */ "ty2H");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");













const _c0 = ["review"];
function ReviewComponent_ng_template_0_div_15_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "REVIEW.COMMENT_REQUIRED"));
} }
function ReviewComponent_ng_template_0_div_15_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, ReviewComponent_ng_template_0_div_15_div_1_Template, 3, 3, "div", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r3.form.comment.errors.required);
} }
function ReviewComponent_ng_template_0_div_42_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 1, "REVIEW.RATING_REQUIRED"));
} }
const _c1 = function (a0) { return { "is-invalid": a0 }; };
function ReviewComponent_ng_template_0_Template(rf, ctx) { if (rf & 1) {
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "h5", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "button", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ReviewComponent_ng_template_0_Template_button_click_4_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r6.dismissModal(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "span", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](6, "\u00D7");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "form", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngSubmit", function ReviewComponent_ng_template_0_Template_form_ngSubmit_8_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r8.submitReview(ctx_r8.reviewForm); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](9, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](12, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](13, "textarea", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](14, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](15, ReviewComponent_ng_template_0_div_15_Template, 2, 1, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](18);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](19, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](21, "fieldset", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](22, "input", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ReviewComponent_ng_template_0_Template_input_change_22_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r9.setRating(5); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](23, "label", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](24, "input", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ReviewComponent_ng_template_0_Template_input_change_24_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r10.setRating(4.5); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](25, "label", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](26, "input", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ReviewComponent_ng_template_0_Template_input_change_26_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r11.setRating(4); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](27, "label", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](28, "input", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ReviewComponent_ng_template_0_Template_input_change_28_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r12.setRating(3.5); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](29, "label", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](30, "input", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ReviewComponent_ng_template_0_Template_input_change_30_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r13.setRating(3); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](31, "label", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](32, "input", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ReviewComponent_ng_template_0_Template_input_change_32_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r14.setRating(2.5); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](33, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](34, "input", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ReviewComponent_ng_template_0_Template_input_change_34_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r15.setRating(2); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](35, "label", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](36, "input", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ReviewComponent_ng_template_0_Template_input_change_36_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r16.setRating(1.5); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](37, "label", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](38, "input", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ReviewComponent_ng_template_0_Template_input_change_38_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r17.setRating(1); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](39, "label", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](40, "input", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ReviewComponent_ng_template_0_Template_input_change_40_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r18.setRating(0.5); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](41, "label", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](42, ReviewComponent_ng_template_0_div_42_Template, 4, 3, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](43, "div", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](44, "div", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](45, "button", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ReviewComponent_ng_template_0_Template_button_click_45_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r19.dismissModal(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](46);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](47, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](48, "button", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](49);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](50, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777LightBT");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 14, "REVIEW.ADD_REVIEW"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("formGroup", ctx_r1.reviewForm)("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777LightBT");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](12, 16, "REVIEW.COMMENTS"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](14, 18, "REVIEW.PLACEHOLDER.COMMENT"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](26, _c1, ctx_r1.submitted && ctx_r1.form.comment.errors));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r1.submitted && ctx_r1.form.comment.errors);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](19, 20, "REVIEW.PRODUCT_RATING"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r1.submitted && ctx_r1.rating === 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777LightBT");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](47, 22, "COMMON.CANCEL"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777LightBT");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](50, 24, "REVIEW.SUBMIT_REVIEW"));
} }
/**
 * Review component
 */
class ReviewComponent {
    /**
     * @constructor
     */
    constructor(formBuilder, modalService, reviewModalService, storageService, productService, translationService) {
        this.formBuilder = formBuilder;
        this.modalService = modalService;
        this.reviewModalService = reviewModalService;
        this.storageService = storageService;
        this.productService = productService;
        this.translationService = translationService;
        this.updateReview = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
        this.profile = {};
        this.submitted = false;
        this.rating = 0;
    }
    /**
     * on init
     */
    ngOnInit() {
        setInterval(() => {
            this.lang = sessionStorage.getItem('language');
        }, 1000);
        // this.lang = sessionStorage.getItem('language');
        this.profile = JSON.parse(this.storageService.getItem('profile'));
        // Listening to review modal observable
        this.modalSubscription = this.reviewModalService.setReviewModalStatusObserve.subscribe((data) => {
            var _a;
            if (data.isReviewModalOpen) {
                this.submitted = false;
                this.reviewModal = this.modalService.open(this.review, { ariaLabelledBy: 'modal-basic-title' });
                this.rating = 0;
                this.reviewForm = this.formBuilder.group({
                    rating: [0, _angular_forms__WEBPACK_IMPORTED_MODULE_2__["Validators"].required],
                    comment: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_2__["Validators"].required],
                });
            }
            else {
                (_a = this.reviewModal) === null || _a === void 0 ? void 0 : _a.close();
            }
        });
    }
    /**
     * on destroy
     */
    ngOnDestroy() {
        this.modalSubscription.unsubscribe();
    }
    /**
     * login controls
     */
    get form() {
        return this.reviewForm.controls;
    }
    /**
     * set rating
     * @param {number} rate
     */
    setRating(rate) {
        this.rating = rate;
    }
    /**
     * Submit review
     * @param {object} reviewForm
     */
    submitReview(reviewForm) {
        reviewForm.value.rating = this.rating;
        this.submitted = true;
        if (reviewForm.valid) {
            const data = reviewForm.value;
            data.authId = this.profile.authId;
            data.food_id = this.foodId;
            this.productService.addReview(data).subscribe((response) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
                var _a;
                if (response['status']) {
                    (_a = this.reviewModal) === null || _a === void 0 ? void 0 : _a.close();
                    sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_3___default.a.fire({
                        icon: 'success',
                        title: yield this.translationService.translateText('TOAST.REVIEW_ADDED'),
                        confirmButtonColor: '#432919',
                        confirmButtonText: yield this.translationService.translateText('TOAST.OK'),
                        customClass: {
                            container: this.lang === 'AR' ? 'font-Tajawal-Light' : 'font-Humanist777LightBT',
                        },
                    }).then((result) => {
                        this.updateReview.emit();
                    });
                }
                else {
                    sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_3___default.a.fire({
                        icon: 'error',
                        title: yield this.translationService.translateText('TOAST.ADD_REVIEW_FAILED'),
                        confirmButtonColor: '#432919',
                        confirmButtonText: yield this.translationService.translateText('TOAST.OK'),
                        text: response.message,
                        customClass: {
                            container: this.lang === 'AR' ? 'font-Tajawal-Light' : 'font-Humanist777LightBT',
                        },
                    });
                }
            }));
        }
    }
    /**
     * Close Modal
     */
    dismissModal() {
        this.reviewModalService.setReviewModalStatus({
            isReviewModalOpen: false,
        });
    }
}
ReviewComponent.ɵfac = function ReviewComponent_Factory(t) { return new (t || ReviewComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormBuilder"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_4__["NgbModal"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](src_app_services_modal_service__WEBPACK_IMPORTED_MODULE_5__["ModalService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](src_app_services_storage_service__WEBPACK_IMPORTED_MODULE_6__["StorageService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](src_app_services_product_service__WEBPACK_IMPORTED_MODULE_7__["ProductService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](src_app_services_translation_service__WEBPACK_IMPORTED_MODULE_8__["TranslationService"])); };
ReviewComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: ReviewComponent, selectors: [["app-review"]], viewQuery: function ReviewComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵviewQuery"](_c0, 1);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.review = _t.first);
    } }, inputs: { foodId: "foodId" }, outputs: { updateReview: "updateReview" }, decls: 2, vars: 0, consts: [["class", "modal-dialog-centered review"], ["review", ""], [1, "modal-header", 3, "ngClass"], ["id", "exampleModalLabel", 1, "modal-title", "text-uppercase"], ["type", "button", "data-dismiss", "modal", "aria-label", "Close", 1, "close", 3, "click"], ["aria-hidden", "true"], [1, "modal-body", "review"], [3, "formGroup", "ngClass", "ngSubmit"], [1, "form-group", "w-100"], ["formControlName", "comment", 1, "form-control", 3, "placeholder", "ngClass"], ["class", "text-danger", 4, "ngIf"], [1, "form-group", "w-100", "mb-4"], [1, "d-flex"], [1, "rating"], ["type", "radio", "id", "star25", "name", "rating", "value", "5", 3, "change"], ["for", "star25", "title", "Awesome - 5 stars", 1, "full", "m-0"], ["type", "radio", "id", "star4half", "name", "rating", "value", "4 and a half", 3, "change"], ["for", "star4half", "title", "Pretty good - 4.5 stars", 1, "half", "m-0"], ["type", "radio", "id", "star24", "name", "rating", "value", "4", 3, "change"], ["for", "star24", "title", "Pretty good - 4 stars", 1, "full", "m-0"], ["type", "radio", "id", "star3half", "name", "rating", "value", "3 and a half", 3, "change"], ["for", "star3half", "title", "Meh - 3.5 stars", 1, "half", "m-0"], ["type", "radio", "id", "star23", "name", "rating", "value", "3", 3, "change"], ["for", "star23", "title", "Meh - 3 stars", 1, "full", "m-0"], ["type", "radio", "id", "star2half", "name", "rating", "value", "2 and a half", 3, "change"], ["for", "star2half", "title", "Kinda bad - 2.5 stars", 1, "half", "m-0"], ["type", "radio", "id", "star22", "name", "rating", "value", "2", 3, "change"], ["for", "star22", "title", "Kinda bad - 2 stars", 1, "full", "m-0"], ["type", "radio", "id", "star1half", "name", "rating", "value", "1 and a half", 3, "change"], ["for", "star1half", "title", "Meh - 1.5 stars", 1, "half", "m-0"], ["type", "radio", "id", "star21", "name", "rating", "value", "1", 3, "change"], ["for", "star21", "title", "Sucks big time - 1 star", 1, "full", "m-0"], ["type", "radio", "id", "starhalf", "name", "rating", "value", "half", 3, "change"], ["for", "starhalf", "title", "Sucks big time - 0.5 stars", 1, "half", "m-0"], [1, "row", "modal-footer", "review"], [1, "form-group", "w-100", "d-flex", "align-items-center", "justify-content-around", "mt-3"], ["type", "submit", 1, "btn", "btn-continue", 3, "ngClass", "click"], ["type", "submit", 1, "btn", "btn-continue", 3, "ngClass"], [1, "text-danger"], [4, "ngIf"]], template: function ReviewComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, ReviewComponent_ng_template_0_Template, 51, 28, "ng-template", 0, 1, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_9__["NgClass"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["ɵangular_packages_forms_forms_y"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormGroupDirective"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["DefaultValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControlName"], _angular_common__WEBPACK_IMPORTED_MODULE_9__["NgIf"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__["TranslatePipe"]], styles: ["@charset \"UTF-8\";\n@import url(//netdna.bootstrapcdn.com/font-awesome/3.2.1/css/font-awesome.css);\n@font-face {\n  font-family: \"HomepageBaukasten-Book\";\n  src: local(\"HomepageBaukasten-Book\"), url('HomepageBaukasten-Book.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist521BT-Roman\";\n  src: local(\"Humanist521BT-Roman\"), url('Humanist521BT-Roman.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanB\";\n  src: local(\"Humanist777BT-RomanB\"), url('Humanist777BT-RomanB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n  src: local(\"Humanist777BT-BoldCondensedB\"), url('Humanist777BT-BoldCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n  src: local(\"Humanist777BT-RomanCondensedB\"), url('Humanist777BT-RomanCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n  src: local(\"Humanist777BT-BlackCondensedB\"), url('Humanist777BT-BlackCondensed.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist777LightBT\";\n  src: local(\"Humanist777LightBT\"), url('Humanist777LightBT.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"HelveticaNeue-Regular\";\n  src: local(\"HelveticaNeue-Regular\"), url('HelveticaNeue-Regular.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Black\";\n  src: local(\"Tajawal-Black\"), url('Tajawal-Black.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Bold\";\n  src: local(\"Tajawal-Bold\"), url('Tajawal-Bold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraBold\";\n  src: local(\"Tajawal-ExtraBold\"), url('Tajawal-ExtraBold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraLight\";\n  src: local(\"Tajawal-ExtraLight\"), url('Tajawal-ExtraLight.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Light\";\n  src: local(\"Tajawal-Light\"), url('Tajawal-Light.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Medium\";\n  src: local(\"Tajawal-Medium\"), url('Tajawal-Medium.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Regular\";\n  src: local(\"Tajawal-Regular\"), url('Tajawal-Regular.ttf') format(\"truetype\");\n}\n.font-HomepageBaukasten-Book[_ngcontent-%COMP%] {\n  font-family: \"HomepageBaukasten-Book\";\n}\n.font-Humanist521BT-Roman[_ngcontent-%COMP%] {\n  font-family: \"Humanist521BT-Roman\";\n}\n.font-Humanist777BT-RomanB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanB\";\n}\n.font-Humanist777BT-BoldCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n}\n.font-Humanist777BT-RomanCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n}\n.font-Humanist777BT-BlackCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n}\n.font-Humanist777LightBT[_ngcontent-%COMP%] {\n  font-family: \"Humanist777LightBT\" !important;\n}\n.font-HelveticaNeue-Regular[_ngcontent-%COMP%] {\n  font-family: \"HelveticaNeue-Regular\";\n}\n.font-Tajawal-Black[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Black\";\n}\n.font-Tajawal-Bold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Bold\";\n}\n.font-Tajawal-ExtraBold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraBold\";\n}\n.font-Tajawal-ExtraLight[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraLight\";\n}\n.font-Tajawal-Light[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Light\";\n}\n.font-Tajawal-Medium[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Medium\";\n}\n.font-Tajawal-Regular[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Regular\";\n}\na[_ngcontent-%COMP%]:hover {\n  color: initial;\n  text-decoration: none;\n}\n.border-color[_ngcontent-%COMP%] {\n  border-color: #dedede !important;\n}\n.container-fluid[_ngcontent-%COMP%] {\n  width: 100%;\n  padding-right: 25px;\n  padding-left: 25px;\n  margin-right: auto;\n  margin-left: auto;\n}\n.full-width[_ngcontent-%COMP%], .aboutUsPage[_ngcontent-%COMP%], .humanKnowCoffee[_ngcontent-%COMP%], .benefitsAndHarms[_ngcontent-%COMP%], .preparationPage[_ngcontent-%COMP%], .galleryPage[_ngcontent-%COMP%], .productPage[_ngcontent-%COMP%] {\n  max-width: 100%;\n  margin: 0 auto;\n}\na[_ngcontent-%COMP%] {\n  color: initial;\n  text-decoration: none;\n  background-color: transparent;\n}\n.br-1px[_ngcontent-%COMP%] {\n  border-right: 1px solid;\n}\n.ngx-gallery-icon[_ngcontent-%COMP%] {\n  color: red;\n  background: blue;\n}\ngallery-item[_ngcontent-%COMP%] {\n  padding: 2em;\n  border: 2px solid #ebc850 !important;\n}\n.ml-1em[_ngcontent-%COMP%] {\n  margin-left: 1em;\n}\n.border[_ngcontent-%COMP%] {\n  border: 1px solid;\n}\n.roundedCorner[_ngcontent-%COMP%] {\n  border-radius: 30px;\n}\n.mt-1em[_ngcontent-%COMP%] {\n  margin-top: 1em;\n}\n.mt-2em[_ngcontent-%COMP%] {\n  margin-top: 2em;\n}\n.pr-0[_ngcontent-%COMP%] {\n  padding-right: 0;\n}\n.pl-0[_ngcontent-%COMP%] {\n  padding-left: 0;\n}\n.section[_ngcontent-%COMP%] {\n  padding: 2em 0;\n}\n.d-flex[_ngcontent-%COMP%] {\n  display: flex;\n}\n.justify-center[_ngcontent-%COMP%] {\n  justify-content: center;\n}\n.align-center[_ngcontent-%COMP%] {\n  align-items: center;\n}\ngallery-thumbs[_ngcontent-%COMP%] {\n  display: none !important;\n}\n.select-gender[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\n.select-gender[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  text-indent: 15px;\n  text-overflow: \"\";\n  width: 90%;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  padding: 2px 2px 2px 2px;\n  border: none;\n  background: transparent url(\"http://cdn1.iconfinder.com/data/icons/cc_mono_icon_set/blacks/16x16/br_down.png\") no-repeat 230px !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%] {\n  display: flex !important;\n  align-items: center !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%]   .modal-dialog[_ngcontent-%COMP%] {\n  flex-grow: 1;\n}\n.our-branch-address[_ngcontent-%COMP%]   .accordion[_ngcontent-%COMP%]    > .card[_ngcontent-%COMP%]    > .card-header[_ngcontent-%COMP%] {\n  padding: 0;\n  background-color: #ebc850 !important;\n}\n.our-branch-address[_ngcontent-%COMP%]   .panelTitle[_ngcontent-%COMP%] {\n  font-size: 1.25rem;\n  line-height: 1.25rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%] {\n  font-weight: 500;\n  color: #1d1d1b;\n  font-size: 1.5rem;\n  line-height: 2.5rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%]:focus {\n  box-shadow: none !important;\n  text-decoration: none;\n}\n.g-btn-close[_ngcontent-%COMP%] {\n  display: none;\n}\npath[_ngcontent-%COMP%] {\n  fill: #bc8033;\n}\n@media (min-width: 767px) {\n  .navbar-expand-md[_ngcontent-%COMP%]   .navbar-nav[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n    padding-right: 0.3rem !important;\n    padding-left: 0.3rem !important;\n    font-size: 16px !important;\n  }\n}\n@media (max-width: 2560px) {\n  .webView[_ngcontent-%COMP%] {\n    background-size: cover !important;\n  }\n}\n.direction_ltr[_ngcontent-%COMP%] {\n  direction: ltr !important;\n}\n.iti[_ngcontent-%COMP%] {\n  width: 100%;\n}\nbutton.close[_ngcontent-%COMP%] {\n  padding: 0.5em !important;\n  border: none !important;\n}\n.btn_primary[_ngcontent-%COMP%] {\n  background: #432919;\n  color: #ebc850;\n}\ninput[_ngcontent-%COMP%]::-webkit-outer-spin-button, input[_ngcontent-%COMP%]::-webkit-inner-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n\ninput[type=number][_ngcontent-%COMP%] {\n  -moz-appearance: textfield;\n}\n.text-primary[_ngcontent-%COMP%] {\n  color: #ebc850 !important;\n}\n.min-height-10[_ngcontent-%COMP%] {\n  min-height: 10em;\n}\n.pac-container[_ngcontent-%COMP%] {\n  background-color: #fff;\n  position: absolute !important;\n  z-index: 9999999999;\n  border-radius: 2px;\n  border-top: 0;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);\n  box-sizing: border-box;\n  overflow: hidden;\n  font-size: 16px;\n  color: #ebc850;\n}\n.pac-logo[_ngcontent-%COMP%]:after {\n  content: \"\";\n  padding: 1px 1px 1px 0;\n  height: 16px;\n  text-align: right;\n  display: block;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3.png);\n  background-position: right;\n  background-repeat: no-repeat;\n  background-size: 120px 14px;\n}\n.hdpi.pac-logo[_ngcontent-%COMP%]:after {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3_hdpi.png);\n}\n.pac-item[_ngcontent-%COMP%] {\n  cursor: default;\n  padding: 4px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n  line-height: 30px;\n  text-align: left;\n  border-top: 0;\n  font-size: 13px;\n  color: #999;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n}\n.pac-item[_ngcontent-%COMP%]:hover {\n  background-color: #fafafa;\n}\n.pac-item-selected[_ngcontent-%COMP%], .pac-item-selected[_ngcontent-%COMP%]:hover {\n  background-color: #ebf2fe;\n}\n.pac-matched[_ngcontent-%COMP%] {\n  font-weight: 700;\n}\n.pac-item-query[_ngcontent-%COMP%] {\n  font-size: 16px;\n  padding-right: 3px;\n  color: #ebc850;\n}\n.pac-icon[_ngcontent-%COMP%] {\n  width: 15px;\n  height: 20px;\n  margin-right: 7px;\n  margin-top: 6px;\n  display: inline-block;\n  vertical-align: top;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons.png);\n  background-size: 34px;\n}\n.hdpi[_ngcontent-%COMP%]   .pac-icon[_ngcontent-%COMP%] {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons_hdpi.png);\n}\n.pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -1px -1px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -18px -1px;\n}\n.pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -1px -161px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -18px -161px;\n}\n.pac-placeholder[_ngcontent-%COMP%] {\n  color: gray;\n}\n.form-control[_ngcontent-%COMP%]:focus {\n  box-shadow: 0 0 0 0.05rem #9f9f9f;\n}\n.page-link[_ngcontent-%COMP%] {\n  border-color: #432919 !important;\n  color: #432919 !important;\n}\n.page-item.active[_ngcontent-%COMP%]   .page-link[_ngcontent-%COMP%] {\n  background-color: #432919 !important;\n  border-color: #432919 !important;\n  color: #ebc850 !important;\n}\n.b-0[_ngcontent-%COMP%] {\n  bottom: 0px;\n}\n.loader_section[_ngcontent-%COMP%] {\n  display: flex;\n  height: 100vh;\n  align-items: center;\n}\n.loader[_ngcontent-%COMP%], .loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  background: #ebc850;\n  -webkit-animation: load1 1s infinite ease-in-out;\n  animation: load1 1s infinite ease-in-out;\n  width: 1em;\n  height: 4em;\n}\n.loader[_ngcontent-%COMP%] {\n  color: #ebc850;\n  text-indent: -9999em;\n  margin: 88px auto;\n  position: relative;\n  font-size: 11px;\n  transform: translateZ(0);\n  -webkit-animation-delay: -0.16s;\n  animation-delay: -0.16s;\n}\n.loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  position: absolute;\n  top: 0;\n  content: \"\";\n}\n.loader[_ngcontent-%COMP%]:before {\n  left: -1.5em;\n  -webkit-animation-delay: -0.32s;\n  animation-delay: -0.32s;\n}\n.loader[_ngcontent-%COMP%]:after {\n  left: 1.5em;\n}\n@-webkit-keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n@keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n\n.review[_ngcontent-%COMP%] {\n  \n  \n}\n.review[_ngcontent-%COMP%]   .rating[_ngcontent-%COMP%] {\n  border: 1px solid #ced4da;\n  border-radius: 5px;\n  padding: 0em 1em;\n  cursor: pointer;\n  float: left;\n  direction: ltr;\n}\n.review[_ngcontent-%COMP%]   .rating[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%] {\n  display: none;\n}\n.review[_ngcontent-%COMP%]   .rating[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:before {\n  margin: 5px;\n  font-size: 1.25em;\n  font-family: FontAwesome;\n  display: inline-block;\n  content: \"\uF005\";\n}\n.review[_ngcontent-%COMP%]   .rating[_ngcontent-%COMP%]    > .half[_ngcontent-%COMP%]:before {\n  content: \"\uF089\";\n  position: absolute;\n}\n.review[_ngcontent-%COMP%]   .rating[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: #ddd;\n  float: right;\n  font-size: 29px;\n}\n.review[_ngcontent-%COMP%]   .rating[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%]:checked    ~ label[_ngcontent-%COMP%], .review[_ngcontent-%COMP%]   .rating[_ngcontent-%COMP%]:not(:checked)    > label[_ngcontent-%COMP%]:hover, .review[_ngcontent-%COMP%]   .rating[_ngcontent-%COMP%]:not(:checked)    > label[_ngcontent-%COMP%]:hover    ~ label[_ngcontent-%COMP%] {\n  color: #ebc850;\n}\n.review[_ngcontent-%COMP%]   .rating[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%]:checked    + label[_ngcontent-%COMP%]:hover, .review[_ngcontent-%COMP%]   .rating[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%]:checked    ~ label[_ngcontent-%COMP%]:hover, .review[_ngcontent-%COMP%]   .rating[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:hover    ~ input[_ngcontent-%COMP%]:checked    ~ label[_ngcontent-%COMP%], .review[_ngcontent-%COMP%]   .rating[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%]:checked    ~ label[_ngcontent-%COMP%]:hover    ~ label[_ngcontent-%COMP%] {\n  color: #ebc850;\n}\n.review[_ngcontent-%COMP%]   .btn-continue[_ngcontent-%COMP%] {\n  padding: 5px 30px;\n  font-size: 20px;\n  line-height: 30px;\n  color: #bc8033;\n  border: 1px solid transparent;\n  background: #432919;\n  border-radius: 30px;\n}\n.review[_ngcontent-%COMP%]   .btn-continue[_ngcontent-%COMP%]:hover {\n  color: #bc8033;\n  transition: cubic-bezier(0.175, 0.885, 0.32, 1.275);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ "/Ffc":
/*!*****************************************!*\
  !*** ./src/app/services/cms.service.ts ***!
  \*****************************************/
/*! exports provided: CmsService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CmsService", function() { return CmsService; });
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/environments/environment */ "AytR");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ "tk/3");



/**
 * Cms service
 */
class CmsService {
    /**
     * @constructor
     */
    constructor(http) {
        this.http = http;
        this.BASE_URL = src_environments_environment__WEBPACK_IMPORTED_MODULE_0__["environment"].BASE_URL;
    }
    /**
     * Get page content
     * @param {string} route
     * @return {object}
     */
    getPageContent(route) {
        return this.http.get(`${this.BASE_URL}/${route}`);
    }
}
CmsService.ɵfac = function CmsService_Factory(t) { return new (t || CmsService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClient"])); };
CmsService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({ token: CmsService, factory: CmsService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 0:
/*!***************************!*\
  !*** multi ./src/main.ts ***!
  \***************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! C:\Users\SparkOut\Downloads\azzam-eatzilla-web\src\main.ts */"zUnb");


/***/ }),

/***/ "10O5":
/*!****************************************************!*\
  !*** ./src/app/pages/product/product.component.ts ***!
  \****************************************************/
/*! exports provided: ProductComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ProductComponent", function() { return ProductComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var src_app_services_product_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/services/product.service */ "Gdn9");
/* harmony import */ var _shared_header_header_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../shared/header/header.component */ "320Y");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _shared_footer_footer_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../shared/footer/footer.component */ "jQpT");
/* harmony import */ var _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ng-bootstrap/ng-bootstrap */ "1kSV");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");








function ProductComponent_div_19_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const shop_item_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx_r5.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r5.lang === "AR" ? shop_item_r4.ar_category_name : shop_item_r4.category_name);
} }
function ProductComponent_div_19_div_2_div_2_span_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "HOME.VAT_INC"));
} }
function ProductComponent_div_19_div_2_div_2_p_13_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "p", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "HOME.VAT_INC"));
} }
const _c0 = function (a0) { return [a0]; };
function ProductComponent_div_19_div_2_div_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "a");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](3, "img", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "ngb-rating", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("rateChange", function ProductComponent_div_19_div_2_div_2_Template_ngb_rating_rateChange_7_listener($event) { const product_r9 = ctx.$implicit; return product_r9.rating = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](11, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](12, ProductComponent_div_19_div_2_div_2_span_12_Template, 3, 3, "span", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](13, ProductComponent_div_19_div_2_div_2_p_13_Template, 3, 3, "p", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "button", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](17, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const product_r9 = ctx.$implicit;
    const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3);
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("src", product_r9.image, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("routerLink", ctx_r8.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](21, _c0, "/ar/single-product/" + product_r9.food_id) : _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](23, _c0, "/single-product/" + product_r9.food_id));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx_r8.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx_r8.lang === "AR" ? product_r9.ar_name : product_r9.name, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("rate", product_r9.rating)("starTemplate", _r2)("readonly", true)("max", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx_r8.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx_r8.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate2"]("", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](11, 17, "HOME.AED"), " ", product_r9.price, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r8.lang === "EN");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r8.lang === "AR");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx_r8.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777LightBT");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("routerLink", ctx_r8.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](25, _c0, "/ar/single-product/" + product_r9.food_id) : _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](27, _c0, "/single-product/" + product_r9.food_id));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](17, 19, "PRODUCT.SELECT"));
} }
function ProductComponent_div_19_div_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, ProductComponent_div_19_div_2_div_2_Template, 18, 29, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const shop_item_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", shop_item_r4.items);
} }
function ProductComponent_div_19_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, ProductComponent_div_19_div_1_Template, 5, 2, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, ProductComponent_div_19_div_2_Template, 3, 1, "div", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const shop_item_r4 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", shop_item_r4.category_id === 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", shop_item_r4.category_id === 2);
} }
function ProductComponent_div_21_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const shop_item_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx_r15.lang === "AR" ? "font-Tajawal-Regular" : "font-HomepageBaukasten-Book");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r15.lang === "AR" ? shop_item_r14.ar_category_name : shop_item_r14.category_name);
} }
function ProductComponent_div_21_div_2_div_2_span_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "HOME.VAT_INC"));
} }
function ProductComponent_div_21_div_2_div_2_p_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "p", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "HOME.VAT_INC"));
} }
function ProductComponent_div_21_div_2_div_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](2, "img", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "div", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "ngb-rating", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("rateChange", function ProductComponent_div_21_div_2_div_2_Template_ngb_rating_rateChange_6_listener($event) { const product_r19 = ctx.$implicit; return product_r19.rating = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](11, ProductComponent_div_21_div_2_div_2_span_11_Template, 3, 3, "span", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](12, ProductComponent_div_21_div_2_div_2_p_12_Template, 3, 3, "p", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "button", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](16, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const product_r19 = ctx.$implicit;
    const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3);
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("src", product_r19.image, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("routerLink", ctx_r18.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](20, _c0, "/ar/single-product/" + product_r19.food_id) : _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](22, _c0, "/single-product/" + product_r19.food_id));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx_r18.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx_r18.lang === "AR" ? product_r19.ar_name : product_r19.name, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("rate", product_r19.rating)("starTemplate", _r2)("readonly", true)("max", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx_r18.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate2"]("", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](10, 16, "HOME.AED"), " ", product_r19.price, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r18.lang === "EN");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r18.lang === "AR");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx_r18.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777LightBT");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("routerLink", ctx_r18.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](24, _c0, "/ar/single-product/" + product_r19.food_id) : _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](26, _c0, "/single-product/" + product_r19.food_id));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](16, 18, "PRODUCT.SELECT"));
} }
function ProductComponent_div_21_div_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, ProductComponent_div_21_div_2_div_2_Template, 17, 28, "div", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const shop_item_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", shop_item_r14.items);
} }
function ProductComponent_div_21_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, ProductComponent_div_21_div_1_Template, 5, 2, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, ProductComponent_div_21_div_2_Template, 3, 1, "div", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const shop_item_r14 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", shop_item_r14.category_id === 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", shop_item_r14.category_id === 3);
} }
function ProductComponent_ng_template_22_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2605");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3, "\u2605 ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const fill_r24 = ctx.fill;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("full", fill_r24 === 100);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵstyleProp"]("width", fill_r24, "%");
} }
const _c1 = function () { return ["/ar"]; };
const _c2 = function () { return ["/"]; };
/**
 * Product Component
 */
class ProductComponent {
    constructor(productser) {
        this.productser = productser;
        /**
         * @constructor
         */
        this.products = [];
        this.product = [];
        window.scroll(0, 0);
    }
    /**
    * ngOnInit called initially
    */
    ngOnInit() {
        setInterval(() => {
            this.lang = sessionStorage.getItem('language');
        }, 1000);
        // this.lang = sessionStorage.getItem('language');
        this.getProduct();
    }
    /**
    * Get product
    */
    getProduct() {
        this.productser.getproduct().subscribe((datas) => {
            this.product.push(datas);
            this.products = this.product[0].food_list;
        });
    }
}
ProductComponent.ɵfac = function ProductComponent_Factory(t) { return new (t || ProductComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](src_app_services_product_service__WEBPACK_IMPORTED_MODULE_1__["ProductService"])); };
ProductComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: ProductComponent, selectors: [["app-product"]], decls: 25, vars: 16, consts: [["setActive", "shop"], [1, "header-border"], [1, "productPage", "full-width-custom"], [1, "container-fluid"], [1, "row"], [1, "col-lg-12"], [1, "banner"], [1, "banner-title", 3, "ngClass"], [1, "breadcrumbs", 3, "ngClass"], [3, "routerLink"], ["class", "mb-3", 4, "ngFor", "ngForOf"], ["class", "mb-2", 4, "ngFor", "ngForOf"], ["rate", ""], [1, "mb-3"], ["class", "row", 4, "ngIf"], ["class", "featuredProducts", 4, "ngIf"], [1, "col-lg-12", "product-section"], [1, "section-title", 3, "ngClass"], [1, "featuredProducts"], ["class", "col-xl-3 col-md-6 col-6 mb-3", 4, "ngFor", "ngForOf"], [1, "col-xl-3", "col-md-6", "col-6", "mb-3"], [1, "featuredProduct-details", "text-center"], ["alt", "featuredProduct", 1, "img-fluid", "product-img-pointer", 3, "src", "routerLink"], [1, "featuredProduct-title", 3, "ngClass"], [1, "featuredProduct-rating"], [3, "rate", "starTemplate", "readonly", "max", "rateChange"], [1, "featuredProduct-tax", 3, "ngClass"], [3, "ngClass"], ["class", "featuredProduct-tax-vat font-Humanist777BT-RomanCondensedB", 4, "ngIf"], ["class", "featuredProduct-tax-vat font-Tajawal-Light", 4, "ngIf"], [1, "featuredProduct-select", 3, "ngClass"], [1, "btn", "roundedCorner", "btn-middle-align", 3, "routerLink"], [1, "featuredProduct-tax-vat", "font-Humanist777BT-RomanCondensedB"], [1, "featuredProduct-tax-vat", "font-Tajawal-Light"], [1, "mb-2"], ["class", "col-xl-4 col-md-6 col-12 mb-3", 4, "ngFor", "ngForOf"], [1, "col-xl-4", "col-md-6", "col-12", "mb-3"], ["alt", "featuredProduct", 1, "img-fluid", "featuredProduct__img", "others-img-pointer", 3, "routerLink", "src"], [1, "btn", "roundedCorner", 3, "routerLink"], [1, "star"], [1, "half"]], template: function ProductComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "app-header", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](10, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "a", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](14);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](15, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](19, ProductComponent_div_19_Template, 3, 2, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](20, "hr");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](21, ProductComponent_div_21_Template, 3, 2, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](22, ProductComponent_ng_template_22_Template, 4, 4, "ng-template", null, 12, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](24, "app-footer");
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanCondensedB");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](10, 8, "MENU.SHOP"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Regular breadcrumbs__ar" : "font-HomepageBaukasten-Book");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction0"](14, _c1) : _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction0"](15, _c2));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](15, 10, "MENU.HOME"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" / ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](17, 12, "MENU.SHOP"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.products);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.products);
    } }, directives: [_shared_header_header_component__WEBPACK_IMPORTED_MODULE_2__["HeaderComponent"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgClass"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterLinkWithHref"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgForOf"], _shared_footer_footer_component__WEBPACK_IMPORTED_MODULE_5__["FooterComponent"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterLink"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_6__["NgbRating"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__["TranslatePipe"]], styles: ["@font-face {\n  font-family: \"HomepageBaukasten-Book\";\n  src: local(\"HomepageBaukasten-Book\"), url('HomepageBaukasten-Book.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist521BT-Roman\";\n  src: local(\"Humanist521BT-Roman\"), url('Humanist521BT-Roman.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanB\";\n  src: local(\"Humanist777BT-RomanB\"), url('Humanist777BT-RomanB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n  src: local(\"Humanist777BT-BoldCondensedB\"), url('Humanist777BT-BoldCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n  src: local(\"Humanist777BT-RomanCondensedB\"), url('Humanist777BT-RomanCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n  src: local(\"Humanist777BT-BlackCondensedB\"), url('Humanist777BT-BlackCondensed.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist777LightBT\";\n  src: local(\"Humanist777LightBT\"), url('Humanist777LightBT.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"HelveticaNeue-Regular\";\n  src: local(\"HelveticaNeue-Regular\"), url('HelveticaNeue-Regular.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Black\";\n  src: local(\"Tajawal-Black\"), url('Tajawal-Black.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Bold\";\n  src: local(\"Tajawal-Bold\"), url('Tajawal-Bold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraBold\";\n  src: local(\"Tajawal-ExtraBold\"), url('Tajawal-ExtraBold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraLight\";\n  src: local(\"Tajawal-ExtraLight\"), url('Tajawal-ExtraLight.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Light\";\n  src: local(\"Tajawal-Light\"), url('Tajawal-Light.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Medium\";\n  src: local(\"Tajawal-Medium\"), url('Tajawal-Medium.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Regular\";\n  src: local(\"Tajawal-Regular\"), url('Tajawal-Regular.ttf') format(\"truetype\");\n}\n.font-HomepageBaukasten-Book[_ngcontent-%COMP%] {\n  font-family: \"HomepageBaukasten-Book\";\n}\n.font-Humanist521BT-Roman[_ngcontent-%COMP%] {\n  font-family: \"Humanist521BT-Roman\";\n}\n.font-Humanist777BT-RomanB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanB\";\n}\n.font-Humanist777BT-BoldCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n}\n.font-Humanist777BT-RomanCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n}\n.font-Humanist777BT-BlackCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n}\n.font-Humanist777LightBT[_ngcontent-%COMP%] {\n  font-family: \"Humanist777LightBT\" !important;\n}\n.font-HelveticaNeue-Regular[_ngcontent-%COMP%] {\n  font-family: \"HelveticaNeue-Regular\";\n}\n.font-Tajawal-Black[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Black\";\n}\n.font-Tajawal-Bold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Bold\";\n}\n.font-Tajawal-ExtraBold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraBold\";\n}\n.font-Tajawal-ExtraLight[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraLight\";\n}\n.font-Tajawal-Light[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Light\";\n}\n.font-Tajawal-Medium[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Medium\";\n}\n.font-Tajawal-Regular[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Regular\";\n}\na[_ngcontent-%COMP%]:hover {\n  color: initial;\n  text-decoration: none;\n}\n.border-color[_ngcontent-%COMP%] {\n  border-color: #dedede !important;\n}\n.container-fluid[_ngcontent-%COMP%] {\n  width: 100%;\n  padding-right: 25px;\n  padding-left: 25px;\n  margin-right: auto;\n  margin-left: auto;\n}\n.full-width[_ngcontent-%COMP%], .aboutUsPage[_ngcontent-%COMP%], .humanKnowCoffee[_ngcontent-%COMP%], .benefitsAndHarms[_ngcontent-%COMP%], .preparationPage[_ngcontent-%COMP%], .galleryPage[_ngcontent-%COMP%], .productPage[_ngcontent-%COMP%] {\n  max-width: 100%;\n  margin: 0 auto;\n}\na[_ngcontent-%COMP%] {\n  color: initial;\n  text-decoration: none;\n  background-color: transparent;\n}\n.br-1px[_ngcontent-%COMP%] {\n  border-right: 1px solid;\n}\n.ngx-gallery-icon[_ngcontent-%COMP%] {\n  color: red;\n  background: blue;\n}\ngallery-item[_ngcontent-%COMP%] {\n  padding: 2em;\n  border: 2px solid #ebc850 !important;\n}\n.ml-1em[_ngcontent-%COMP%] {\n  margin-left: 1em;\n}\n.border[_ngcontent-%COMP%] {\n  border: 1px solid;\n}\n.roundedCorner[_ngcontent-%COMP%] {\n  border-radius: 30px;\n}\n.mt-1em[_ngcontent-%COMP%] {\n  margin-top: 1em;\n}\n.mt-2em[_ngcontent-%COMP%] {\n  margin-top: 2em;\n}\n.pr-0[_ngcontent-%COMP%] {\n  padding-right: 0;\n}\n.pl-0[_ngcontent-%COMP%] {\n  padding-left: 0;\n}\n.section[_ngcontent-%COMP%] {\n  padding: 2em 0;\n}\n.d-flex[_ngcontent-%COMP%] {\n  display: flex;\n}\n.justify-center[_ngcontent-%COMP%] {\n  justify-content: center;\n}\n.align-center[_ngcontent-%COMP%] {\n  align-items: center;\n}\ngallery-thumbs[_ngcontent-%COMP%] {\n  display: none !important;\n}\n.select-gender[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\n.select-gender[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  text-indent: 15px;\n  text-overflow: \"\";\n  width: 90%;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  padding: 2px 2px 2px 2px;\n  border: none;\n  background: transparent url(\"http://cdn1.iconfinder.com/data/icons/cc_mono_icon_set/blacks/16x16/br_down.png\") no-repeat 230px !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%] {\n  display: flex !important;\n  align-items: center !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%]   .modal-dialog[_ngcontent-%COMP%] {\n  flex-grow: 1;\n}\n.our-branch-address[_ngcontent-%COMP%]   .accordion[_ngcontent-%COMP%]    > .card[_ngcontent-%COMP%]    > .card-header[_ngcontent-%COMP%] {\n  padding: 0;\n  background-color: #ebc850 !important;\n}\n.our-branch-address[_ngcontent-%COMP%]   .panelTitle[_ngcontent-%COMP%] {\n  font-size: 1.25rem;\n  line-height: 1.25rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%] {\n  font-weight: 500;\n  color: #1d1d1b;\n  font-size: 1.5rem;\n  line-height: 2.5rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%]:focus {\n  box-shadow: none !important;\n  text-decoration: none;\n}\n.g-btn-close[_ngcontent-%COMP%] {\n  display: none;\n}\npath[_ngcontent-%COMP%] {\n  fill: #bc8033;\n}\n@media (min-width: 767px) {\n  .navbar-expand-md[_ngcontent-%COMP%]   .navbar-nav[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n    padding-right: 0.3rem !important;\n    padding-left: 0.3rem !important;\n    font-size: 16px !important;\n  }\n}\n@media (max-width: 2560px) {\n  .webView[_ngcontent-%COMP%] {\n    background-size: cover !important;\n  }\n}\n.direction_ltr[_ngcontent-%COMP%] {\n  direction: ltr !important;\n}\n.iti[_ngcontent-%COMP%] {\n  width: 100%;\n}\nbutton.close[_ngcontent-%COMP%] {\n  padding: 0.5em !important;\n  border: none !important;\n}\n.btn_primary[_ngcontent-%COMP%] {\n  background: #432919;\n  color: #ebc850;\n}\ninput[_ngcontent-%COMP%]::-webkit-outer-spin-button, input[_ngcontent-%COMP%]::-webkit-inner-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n\ninput[type=number][_ngcontent-%COMP%] {\n  -moz-appearance: textfield;\n}\n.text-primary[_ngcontent-%COMP%] {\n  color: #ebc850 !important;\n}\n.min-height-10[_ngcontent-%COMP%] {\n  min-height: 10em;\n}\n.pac-container[_ngcontent-%COMP%] {\n  background-color: #fff;\n  position: absolute !important;\n  z-index: 9999999999;\n  border-radius: 2px;\n  border-top: 0;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);\n  box-sizing: border-box;\n  overflow: hidden;\n  font-size: 16px;\n  color: #ebc850;\n}\n.pac-logo[_ngcontent-%COMP%]:after {\n  content: \"\";\n  padding: 1px 1px 1px 0;\n  height: 16px;\n  text-align: right;\n  display: block;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3.png);\n  background-position: right;\n  background-repeat: no-repeat;\n  background-size: 120px 14px;\n}\n.hdpi.pac-logo[_ngcontent-%COMP%]:after {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3_hdpi.png);\n}\n.pac-item[_ngcontent-%COMP%] {\n  cursor: default;\n  padding: 4px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n  line-height: 30px;\n  text-align: left;\n  border-top: 0;\n  font-size: 13px;\n  color: #999;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n}\n.pac-item[_ngcontent-%COMP%]:hover {\n  background-color: #fafafa;\n}\n.pac-item-selected[_ngcontent-%COMP%], .pac-item-selected[_ngcontent-%COMP%]:hover {\n  background-color: #ebf2fe;\n}\n.pac-matched[_ngcontent-%COMP%] {\n  font-weight: 700;\n}\n.pac-item-query[_ngcontent-%COMP%] {\n  font-size: 16px;\n  padding-right: 3px;\n  color: #ebc850;\n}\n.pac-icon[_ngcontent-%COMP%] {\n  width: 15px;\n  height: 20px;\n  margin-right: 7px;\n  margin-top: 6px;\n  display: inline-block;\n  vertical-align: top;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons.png);\n  background-size: 34px;\n}\n.hdpi[_ngcontent-%COMP%]   .pac-icon[_ngcontent-%COMP%] {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons_hdpi.png);\n}\n.pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -1px -1px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -18px -1px;\n}\n.pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -1px -161px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -18px -161px;\n}\n.pac-placeholder[_ngcontent-%COMP%] {\n  color: gray;\n}\n.form-control[_ngcontent-%COMP%]:focus {\n  box-shadow: 0 0 0 0.05rem #9f9f9f;\n}\n.page-link[_ngcontent-%COMP%] {\n  border-color: #432919 !important;\n  color: #432919 !important;\n}\n.page-item.active[_ngcontent-%COMP%]   .page-link[_ngcontent-%COMP%] {\n  background-color: #432919 !important;\n  border-color: #432919 !important;\n  color: #ebc850 !important;\n}\n.b-0[_ngcontent-%COMP%] {\n  bottom: 0px;\n}\n.loader_section[_ngcontent-%COMP%] {\n  display: flex;\n  height: 100vh;\n  align-items: center;\n}\n.loader[_ngcontent-%COMP%], .loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  background: #ebc850;\n  -webkit-animation: load1 1s infinite ease-in-out;\n  animation: load1 1s infinite ease-in-out;\n  width: 1em;\n  height: 4em;\n}\n.loader[_ngcontent-%COMP%] {\n  color: #ebc850;\n  text-indent: -9999em;\n  margin: 88px auto;\n  position: relative;\n  font-size: 11px;\n  transform: translateZ(0);\n  -webkit-animation-delay: -0.16s;\n  animation-delay: -0.16s;\n}\n.loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  position: absolute;\n  top: 0;\n  content: \"\";\n}\n.loader[_ngcontent-%COMP%]:before {\n  left: -1.5em;\n  -webkit-animation-delay: -0.32s;\n  animation-delay: -0.32s;\n}\n.loader[_ngcontent-%COMP%]:after {\n  left: 1.5em;\n}\n@-webkit-keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n@keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n.productPage[_ngcontent-%COMP%]   .banner-title[_ngcontent-%COMP%] {\n  font-size: 3.125rem;\n  line-height: 5rem;\n}\n.productPage[_ngcontent-%COMP%]   .separator[_ngcontent-%COMP%] {\n  margin: 1em 0;\n  border-bottom: 1px solid #dedede;\n}\n.productPage[_ngcontent-%COMP%]   .banner[_ngcontent-%COMP%] {\n  margin: 20px 0px 10px;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n.productPage[_ngcontent-%COMP%]   .banner[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin-bottom: 0px;\n}\n.productPage[_ngcontent-%COMP%]   .breadcrumbs[_ngcontent-%COMP%] {\n  margin-top: 0px;\n  color: #9f9f9f;\n  text-align: left;\n  font-size: 1.25rem;\n  line-height: 2.5rem;\n}\n.productPage[_ngcontent-%COMP%]   .breadcrumbs[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #9f9f9f !important;\n}\n.productPage[_ngcontent-%COMP%]   .breadcrumbs__ar[_ngcontent-%COMP%] {\n  font-size: 1.625rem !important;\n  text-align: right;\n}\n.productPage[_ngcontent-%COMP%]   .product-section[_ngcontent-%COMP%] {\n  padding-bottom: 0px;\n}\n.productPage[_ngcontent-%COMP%]   .product-section[_ngcontent-%COMP%]   .section-title[_ngcontent-%COMP%] {\n  color: #bc8033;\n  font-size: 1.875rem;\n  text-transform: uppercase;\n}\n.productPage[_ngcontent-%COMP%]   .product-section[_ngcontent-%COMP%]   .section-title[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  border-bottom: 3px solid #9f9f9f;\n}\n.productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%] {\n  padding: 0 3em;\n  margin-top: 1em;\n}\n.productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-details[_ngcontent-%COMP%] {\n  padding: 1em 1em 1em 1em;\n  border: 1px solid #dedede;\n}\n.productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-details[_ngcontent-%COMP%]   .featuredProduct__img[_ngcontent-%COMP%] {\n  min-height: 21em;\n}\n.productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-select[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  color: #ebc850;\n  outline: none;\n  background: #432919;\n  padding: 0.2em 2em;\n  font-size: 1.5rem;\n  line-height: 1.4em;\n  font-weight: 300;\n  margin-bottom: 15px;\n  letter-spacing: 0.5px;\n}\n.productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-title[_ngcontent-%COMP%] {\n  font-size: 1.5rem;\n  line-height: 2.25rem;\n  margin-bottom: 0px !important;\n}\n.productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-rating[_ngcontent-%COMP%] {\n  margin-bottom: 5px;\n}\n.productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-tax[_ngcontent-%COMP%] {\n  font-size: 1.375rem;\n  line-height: 2.25rem;\n  margin-bottom: 10px;\n  font-family: Tajawal-Bold;\n}\n.productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-tax-vat[_ngcontent-%COMP%] {\n  font-size: 1.125rem;\n  line-height: 2.25rem;\n}\n.productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .star[_ngcontent-%COMP%] {\n  position: relative;\n  display: inline-block;\n  font-size: 1.5rem;\n  color: #d3d3d3;\n}\n.productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .full[_ngcontent-%COMP%] {\n  color: #ebc850;\n}\n.productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .half[_ngcontent-%COMP%] {\n  position: absolute;\n  display: inline-block;\n  overflow: hidden;\n  color: #ebc850;\n}\n.productPage[_ngcontent-%COMP%]   .others[_ngcontent-%COMP%] {\n  margin: 1em 0;\n}\n.featuredProduct-rating[_ngcontent-%COMP%] {\n  display: inline-flex;\n  vertical-align: sub;\n}\n.featuredProduct-rating[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin-bottom: 0;\n}\n@media (max-width: 1600px) {\n  .featuredProduct-details[_ngcontent-%COMP%] {\n    margin-bottom: 20px;\n  }\n}\n@media only screen and (max-width: 767px) {\n  .productPage[_ngcontent-%COMP%]   .breadcrumbs[_ngcontent-%COMP%] {\n    color: #9f9f9f;\n    text-align: left;\n  }\n\n  .productPage[_ngcontent-%COMP%]   .banner[_ngcontent-%COMP%] {\n    margin: 20px 0px 10px;\n    display: flex;\n  }\n\n  .productPage[_ngcontent-%COMP%]   .banner-title[_ngcontent-%COMP%] {\n    font-size: 1.125rem;\n    line-height: 1.5rem;\n  }\n\n  .productPage[_ngcontent-%COMP%]   .breadcrumbs[_ngcontent-%COMP%] {\n    margin: 0;\n    font-size: 1.125rem;\n    line-height: 1.5rem;\n  }\n\n  .productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%] {\n    padding: 0em;\n    margin-top: 0em;\n  }\n\n  .productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-tax[_ngcontent-%COMP%] {\n    font-size: 20px !important;\n    line-height: 20px !important;\n    margin-bottom: 5px !important;\n  }\n\n  .featuredProduct-details[_ngcontent-%COMP%] {\n    margin-bottom: 20px;\n  }\n\n  .productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-select[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n    padding: 5px 20px;\n    font-size: 1rem;\n    line-height: 1.2em;\n  }\n}\n@media only screen and (max-width: 575px) {\n  .container-fluid[_ngcontent-%COMP%] {\n    padding-right: 15px;\n    padding-left: 15px;\n  }\n\n  .productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-title[_ngcontent-%COMP%] {\n    font-size: 18px;\n    line-height: 15px;\n    margin-bottom: 10px;\n  }\n\n  .featuredProduct-details[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n    margin-bottom: 10px;\n  }\n\n  .productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-select[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n    padding: 5px 30px;\n    line-height: 20px;\n    font-size: 20px;\n  }\n\n  .productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-tax[_ngcontent-%COMP%] {\n    margin-bottom: 10px !important;\n    font-size: 18px !important;\n  }\n\n  .productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-rating[_ngcontent-%COMP%] {\n    margin-bottom: 0px !important;\n  }\n\n  .productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-details[_ngcontent-%COMP%] {\n    padding: 1em 1em 0.5em 1em;\n  }\n\n  .featuredProduct-details[_ngcontent-%COMP%] {\n    margin-bottom: 30px;\n  }\n\n  .productPage[_ngcontent-%COMP%]   .featuredProducts[_ngcontent-%COMP%]   .featuredProduct-tax-vat[_ngcontent-%COMP%] {\n    font-size: 16px;\n    line-height: 20px;\n    margin-bottom: 10px;\n  }\n\n  .featuredProduct__img[_ngcontent-%COMP%] {\n    min-height: 9em !important;\n  }\n}\n\n.full-width-custom[_ngcontent-%COMP%] {\n  width: 1366px;\n}\n.header-border[_ngcontent-%COMP%] {\n  border-top: 1px solid #1d1d1b;\n}\n.product-img-pointer[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n.btn-middle-align[_ngcontent-%COMP%] {\n  vertical-align: middle;\n}\n.others-img-pointer[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ "13eq":
/*!************************************************************!*\
  !*** ./src/app/pages/preparation/preparation.component.ts ***!
  \************************************************************/
/*! exports provided: PreparationComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PreparationComponent", function() { return PreparationComponent; });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "LvDl");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var src_app_services_cms_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/services/cms.service */ "/Ffc");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _shared_header_header_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../shared/header/header.component */ "320Y");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ng-bootstrap/ng-bootstrap */ "1kSV");
/* harmony import */ var _shared_footer_footer_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../shared/footer/footer.component */ "jQpT");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");









function PreparationComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "div", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} }
function PreparationComponent_div_1_ng_template_29_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "img", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "div", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "ol", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](21, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](22, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](23);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("src", ctx_r3.lang === "AR" ? ctx_r3.getImage(ctx_r3.arabicContent, "content_image_ar") : ctx_r3.getImage(ctx_r3.arabicContent, "content_image"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r3.lang === "AR" ? "font-Tajawal-Regular preparation-listes-ar" : "font-Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r3.lang === "AR" ? ctx_r3.getContent(ctx_r3.arabicContent, "point1_ar") : ctx_r3.getContent(ctx_r3.arabicContent, "point1"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r3.lang === "AR" ? ctx_r3.getContent(ctx_r3.arabicContent, "point2_ar") : ctx_r3.getContent(ctx_r3.arabicContent, "point2"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r3.lang === "AR" ? ctx_r3.getContent(ctx_r3.arabicContent, "point3_ar") : ctx_r3.getContent(ctx_r3.arabicContent, "point3"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r3.lang === "AR" ? ctx_r3.getContent(ctx_r3.arabicContent, "point4_ar") : ctx_r3.getContent(ctx_r3.arabicContent, "point4"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r3.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](21, 10, "PREPARATION.NOTE"), ": ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r3.lang === "AR" ? "font-Tajawal-Regular" : "Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r3.lang === "AR" ? ctx_r3.getContent(ctx_r3.content, "note_ar") : ctx_r3.getContent(ctx_r3.content, "note"));
} }
function PreparationComponent_div_1_ng_template_33_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "img", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "div", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "ol", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](22, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](23, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("src", ctx_r4.lang === "AR" ? ctx_r4.getImage(ctx_r4.turkishContent, "content_image_ar") : ctx_r4.getImage(ctx_r4.turkishContent, "content_image"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r4.lang === "AR" ? "font-Tajawal-Regular preparation-listes-ar" : "font-Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r4.lang === "AR" ? ctx_r4.getContent(ctx_r4.turkishContent, "point1_ar") : ctx_r4.getContent(ctx_r4.turkishContent, "point1"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r4.lang === "AR" ? ctx_r4.getContent(ctx_r4.turkishContent, "point2_ar") : ctx_r4.getContent(ctx_r4.turkishContent, "point2"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r4.lang === "AR" ? ctx_r4.getContent(ctx_r4.turkishContent, "point3_ar") : ctx_r4.getContent(ctx_r4.turkishContent, "point3"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r4.lang === "AR" ? ctx_r4.getContent(ctx_r4.turkishContent, "point4_ar") : ctx_r4.getContent(ctx_r4.turkishContent, "point4"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r4.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](22, 10, "PREPARATION.NOTE"), ": ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r4.lang === "AR" ? "font-Tajawal-Regular" : "Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r4.lang === "AR" ? ctx_r4.getContent(ctx_r4.content, "note_ar") : ctx_r4.getContent(ctx_r4.content, "note"));
} }
function PreparationComponent_div_1_ng_template_37_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "img", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "div", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "ol", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](21, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](22, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](23);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("src", ctx_r5.lang === "AR" ? ctx_r5.getImage(ctx_r5.frenchContent, "content_image_ar") : ctx_r5.getImage(ctx_r5.frenchContent, "content_image"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r5.lang === "AR" ? "font-Tajawal-Regular preparation-listes-ar" : "font-Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r5.lang === "AR" ? ctx_r5.getContent(ctx_r5.frenchContent, "point1_ar") : ctx_r5.getContent(ctx_r5.frenchContent, "point1"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r5.lang === "AR" ? ctx_r5.getContent(ctx_r5.frenchContent, "point2_ar") : ctx_r5.getContent(ctx_r5.frenchContent, "point2"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r5.lang === "AR" ? ctx_r5.getContent(ctx_r5.frenchContent, "point3_ar") : ctx_r5.getContent(ctx_r5.frenchContent, "point3"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r5.lang === "AR" ? ctx_r5.getContent(ctx_r5.frenchContent, "point4_ar") : ctx_r5.getContent(ctx_r5.frenchContent, "point4"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r5.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](21, 10, "PREPARATION.NOTE"), ": ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r5.lang === "AR" ? "font-Tajawal-Regular" : "Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r5.lang === "AR" ? ctx_r5.getContent(ctx_r5.content, "note_ar") : ctx_r5.getContent(ctx_r5.content, "note"));
} }
function PreparationComponent_div_1_ng_template_41_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "img", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "div", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "ol", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](21, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](22, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](23);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("src", ctx_r6.lang === "AR" ? ctx_r6.getImage(ctx_r6.hazlenutContent, "content_image_ar") : ctx_r6.getImage(ctx_r6.hazlenutContent, "content_image"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r6.lang === "AR" ? "font-Tajawal-Regular preparation-listes-ar" : "font-Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r6.lang === "AR" ? ctx_r6.getContent(ctx_r6.hazlenutContent, "point1_ar") : ctx_r6.getContent(ctx_r6.hazlenutContent, "point1"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r6.lang === "AR" ? ctx_r6.getContent(ctx_r6.hazlenutContent, "point2_ar") : ctx_r6.getContent(ctx_r6.hazlenutContent, "point2"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r6.lang === "AR" ? ctx_r6.getContent(ctx_r6.hazlenutContent, "point3_ar") : ctx_r6.getContent(ctx_r6.hazlenutContent, "point3"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r6.lang === "AR" ? ctx_r6.getContent(ctx_r6.hazlenutContent, "point4_ar") : ctx_r6.getContent(ctx_r6.hazlenutContent, "point4"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r6.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](21, 10, "PREPARATION.NOTE"), ": ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r6.lang === "AR" ? "font-Tajawal-Regular" : "Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r6.lang === "AR" ? ctx_r6.getContent(ctx_r6.content, "note_ar") : ctx_r6.getContent(ctx_r6.content, "note"));
} }
function PreparationComponent_div_1_ng_template_45_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "img", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "div", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "ol", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](22, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](23, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](24, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](25, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](27, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](28, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](29);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("src", ctx_r7.lang === "AR" ? ctx_r7.getImage(ctx_r7.americanContent, "content_image_ar") : ctx_r7.getImage(ctx_r7.americanContent, "content_image"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r7.lang === "AR" ? "font-Tajawal-Regular preparation-listes-ar" : "font-Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r7.lang === "AR" ? ctx_r7.getContent(ctx_r7.americanContent, "point1_ar") : ctx_r7.getContent(ctx_r7.americanContent, "point1"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r7.lang === "AR" ? ctx_r7.getContent(ctx_r7.americanContent, "point2_ar") : ctx_r7.getContent(ctx_r7.americanContent, "point2"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r7.lang === "AR" ? ctx_r7.getContent(ctx_r7.americanContent, "point3_ar") : ctx_r7.getContent(ctx_r7.americanContent, "point3"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r7.lang === "AR" ? ctx_r7.getContent(ctx_r7.americanContent, "point4_ar") : ctx_r7.getContent(ctx_r7.americanContent, "point4"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r7.lang === "AR" ? ctx_r7.getContent(ctx_r7.americanContent, "point5_ar") : ctx_r7.getContent(ctx_r7.americanContent, "point5"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r7.lang === "AR" ? ctx_r7.getContent(ctx_r7.americanContent, "point6_ar") : ctx_r7.getContent(ctx_r7.americanContent, "point6"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r7.lang === "AR" ? ctx_r7.getContent(ctx_r7.americanContent, "point7_ar") : ctx_r7.getContent(ctx_r7.americanContent, "point7"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r7.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](27, 13, "PREPARATION.NOTE"), ": ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r7.lang === "AR" ? "font-Tajawal-Regular" : "Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r7.lang === "AR" ? ctx_r7.getContent(ctx_r7.content, "note_ar") : ctx_r7.getContent(ctx_r7.content, "note"));
} }
function PreparationComponent_div_1_ng_template_49_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "div", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](7, "img", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "div", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](9, "div", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "ol", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](12);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](15, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](18);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](21, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](23, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](25, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](27, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](28, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](29, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](30, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](32, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](33, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](34);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r8.lang === "AR" ? "font-Tajawal-Regular preparation-section-ar" : "font-Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx_r8.lang === "AR" ? ctx_r8.getContent(ctx_r8.expressoContent, "sub_content_ar") : ctx_r8.getContent(ctx_r8.expressoContent, "sub_content"), ": ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("src", ctx_r8.lang === "AR" ? ctx_r8.getImage(ctx_r8.expressoContent, "content_image_ar") : ctx_r8.getImage(ctx_r8.expressoContent, "content_image"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r8.lang === "AR" ? "font-Tajawal-Regular preparation-listes-ar" : "font-Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r8.lang === "AR" ? ctx_r8.getContent(ctx_r8.expressoContent, "point1_ar") : ctx_r8.getContent(ctx_r8.expressoContent, "point1"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r8.lang === "AR" ? ctx_r8.getContent(ctx_r8.expressoContent, "point2_ar") : ctx_r8.getContent(ctx_r8.expressoContent, "point2"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r8.lang === "AR" ? ctx_r8.getContent(ctx_r8.expressoContent, "point3_ar") : ctx_r8.getContent(ctx_r8.expressoContent, "point3"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r8.lang === "AR" ? ctx_r8.getContent(ctx_r8.expressoContent, "point4_ar") : ctx_r8.getContent(ctx_r8.expressoContent, "point4"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r8.lang === "AR" ? ctx_r8.getContent(ctx_r8.expressoContent, "point5_ar") : ctx_r8.getContent(ctx_r8.expressoContent, "point5"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r8.lang === "AR" ? ctx_r8.getContent(ctx_r8.expressoContent, "point6_ar") : ctx_r8.getContent(ctx_r8.expressoContent, "point6"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r8.lang === "AR" ? ctx_r8.getContent(ctx_r8.expressoContent, "point7_ar") : ctx_r8.getContent(ctx_r8.expressoContent, "point7"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r8.lang === "AR" ? ctx_r8.getContent(ctx_r8.expressoContent, "point8_ar") : ctx_r8.getContent(ctx_r8.expressoContent, "point8"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r8.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](32, 16, "PREPARATION.NOTE"), ": ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r8.lang === "AR" ? "font-Tajawal-Regular" : "Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r8.lang === "AR" ? ctx_r8.getContent(ctx_r8.content, "note_ar") : ctx_r8.getContent(ctx_r8.content, "note"));
} }
const _c0 = function () { return ["/ar"]; };
const _c1 = function () { return ["/"]; };
function PreparationComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "app-header", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "img", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](9, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "div", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](15, "a", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](17, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](18);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](19, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](21, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](23, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](24, "ul", 18, 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("activeIdChange", function PreparationComponent_div_1_Template_ul_activeIdChange_24_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10); const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r9.active = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](26, "li", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](27, "a", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](29, PreparationComponent_div_1_ng_template_29_Template, 24, 12, "ng-template", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](30, "li", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](31, "a", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](33, PreparationComponent_div_1_ng_template_33_Template, 25, 12, "ng-template", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](34, "li", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](35, "a", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](37, PreparationComponent_div_1_ng_template_37_Template, 24, 12, "ng-template", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](38, "li", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](39, "a", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](40);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](41, PreparationComponent_div_1_ng_template_41_Template, 24, 12, "ng-template", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](42, "li", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](43, "a", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](44);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](45, PreparationComponent_div_1_ng_template_45_Template, 30, 15, "ng-template", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](46, "li", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](47, "a", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](48);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](49, PreparationComponent_div_1_ng_template_49_Template, 35, 18, "ng-template", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](50, "div", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](51, "app-footer");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](25);
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("src", ctx_r1.lang === "AR" ? ctx_r1.getImage(ctx_r1.content, "title_image_ar") : ctx_r1.getImage(ctx_r1.content, "title_image"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent(ctx_r1.content, "title_ar") : ctx_r1.getContent(ctx_r1.content, "title"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Regular breadcrumbs__ar" : "font-HomepageBaukasten-Book");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", ctx_r1.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](34, _c0) : _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](35, _c1));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](17, 30, "MENU.HOME"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate2"](" / ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](19, 32, "MENU.PREPARATION"), " / ", ctx_r1.lang === "AR" ? ctx_r1.getContent(ctx_r1.content, "sub_title_ar") : ctx_r1.getContent(ctx_r1.content, "sub_title"), "");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold section-title-ar" : "font-Humanist777BT-BoldCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent(ctx_r1.content, "sub_title_ar") : ctx_r1.getContent(ctx_r1.content, "sub_title"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("activeId", ctx_r1.active);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngbNavItem", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold nav_tabs_ar" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent(ctx_r1.content, "arabic_ar") : ctx_r1.getContent(ctx_r1.content, "arabic"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngbNavItem", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold nav_tabs_ar" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent(ctx_r1.content, "turkish_ar") : ctx_r1.getContent(ctx_r1.content, "turkish"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngbNavItem", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold nav_tabs_ar" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent(ctx_r1.content, "french_ar") : ctx_r1.getContent(ctx_r1.content, "french"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngbNavItem", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold nav_tabs_ar" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent(ctx_r1.content, "hazelnut_ar") : ctx_r1.getContent(ctx_r1.content, "hazelnut"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngbNavItem", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold nav_tabs_ar" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent(ctx_r1.content, "american_ar") : ctx_r1.getContent(ctx_r1.content, "american"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngbNavItem", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold nav_tabs_ar" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent(ctx_r1.content, "espresso_ar") : ctx_r1.getContent(ctx_r1.content, "espresso"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngbNavOutlet", _r2);
} }
/**
 * Preparation Component
 */
class PreparationComponent {
    /**
     * Constructor
     */
    constructor(cmsService) {
        this.cmsService = cmsService;
        this.content = [];
        this.imageBaseUrl = '';
        this.arabicContent = [];
        this.americanContent = [];
        this.turkishContent = [];
        this.frenchContent = [];
        this.hazlenutContent = [];
        this.expressoContent = [];
        this.active = 1;
        window.scroll(0, 0);
    }
    /**
     * page Starts
     */
    ngOnInit() {
        setInterval(() => {
            this.lang = sessionStorage.getItem('language');
        }, 1000);
        // this.lang = sessionStorage.getItem('language');
        this.getPreparationPageContent();
    }
    /**
     * get about page content
     */
    getPreparationPageContent() {
        this.cmsService.getPageContent('get_cms_preparation').subscribe((response) => {
            if (response['status']) {
                this.content = response['common_data'];
                this.arabicContent = response['arabic_data'];
                this.americanContent = response['american_data'];
                this.turkishContent = response['turkish_data'];
                this.frenchContent = response['french_data'];
                this.hazlenutContent = response['hazelnut_data'];
                this.expressoContent = response['espresso_data'];
                this.imageBaseUrl = response['base_image_url'];
            }
        });
    }
    /**
     * Get content
     * @param {any} content
     * @param {string} key
     * @return {object}
     */
    getContent(content, key) {
        var _a;
        const filterData = lodash__WEBPACK_IMPORTED_MODULE_0___default.a.filter(content, ['section', key]);
        return (_a = filterData[0]) === null || _a === void 0 ? void 0 : _a.content;
    }
    /**
     * Get content
     * @param {any} content
     * @param {string} key
     * @return {object}
     */
    getImage(content, key) {
        var _a;
        const filterData = lodash__WEBPACK_IMPORTED_MODULE_0___default.a.filter(content, ['section', key]);
        return `${this.imageBaseUrl}${(_a = filterData[0]) === null || _a === void 0 ? void 0 : _a.content}`;
    }
}
PreparationComponent.ɵfac = function PreparationComponent_Factory(t) { return new (t || PreparationComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](src_app_services_cms_service__WEBPACK_IMPORTED_MODULE_2__["CmsService"])); };
PreparationComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: PreparationComponent, selectors: [["app-preparation"]], decls: 2, vars: 2, consts: [["class", "loader_section", 4, "ngIf"], [4, "ngIf"], [1, "loader_section"], [1, "loader"], ["setActive", "preparation"], [1, "banner"], [1, "banner-img"], [1, "img-fluid", 3, "src"], [1, "banner-wrap", "banner-title", "container-fluid", "text-align-custom", 3, "ngClass"], [1, "preparationPage", "full-width-custom"], [1, "preparation-section"], [1, "container-fluid"], [1, "row"], [1, "col-lg-12"], [1, "breadcrumbs", 3, "ngClass"], [3, "routerLink"], [1, "section-title", 3, "ngClass"], [1, "tabsSection"], ["ngbNav", "", 1, "nav-tabs", 3, "activeId", "activeIdChange"], ["nav", "ngbNav"], [3, "ngbNavItem"], ["ngbNavLink", "", 3, "ngClass"], ["ngbNavContent", ""], [1, "mt-2", 3, "ngbNavOutlet"], [1, "row", "preparation-section"], [1, "col-md-4"], [1, "arabicSection", "text-center"], [1, "col-md-8"], [1, "mt-2em"], [1, "preparation-listes", 3, "ngClass"], [1, "col-md-12", "notess"], [1, "notesSection"], [3, "ngClass"], ["id", "exp-order2", 1, "col-md-12", "notess"], [1, "row", "preparation-section", 3, "ngClass"], [1, "col-md-4", "preparation-section"], ["id", "exp-order1", 1, "arabicSection", "text-center"], [1, "col-md-8", "preparation-section"]], template: function PreparationComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, PreparationComponent_div_0_Template, 2, 0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, PreparationComponent_div_1_Template, 52, 36, "div", 1);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.content || ctx.content.length === 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.content.length > 0);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"], _shared_header_header_component__WEBPACK_IMPORTED_MODULE_4__["HeaderComponent"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgClass"], _angular_router__WEBPACK_IMPORTED_MODULE_5__["RouterLinkWithHref"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_6__["NgbNav"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_6__["NgbNavItem"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_6__["NgbNavLink"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_6__["NgbNavContent"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_6__["NgbNavOutlet"], _shared_footer_footer_component__WEBPACK_IMPORTED_MODULE_7__["FooterComponent"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__["TranslatePipe"]], styles: ["@charset \"UTF-8\";\n@font-face {\n  font-family: \"HomepageBaukasten-Book\";\n  src: local(\"HomepageBaukasten-Book\"), url('HomepageBaukasten-Book.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist521BT-Roman\";\n  src: local(\"Humanist521BT-Roman\"), url('Humanist521BT-Roman.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanB\";\n  src: local(\"Humanist777BT-RomanB\"), url('Humanist777BT-RomanB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n  src: local(\"Humanist777BT-BoldCondensedB\"), url('Humanist777BT-BoldCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n  src: local(\"Humanist777BT-RomanCondensedB\"), url('Humanist777BT-RomanCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n  src: local(\"Humanist777BT-BlackCondensedB\"), url('Humanist777BT-BlackCondensed.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist777LightBT\";\n  src: local(\"Humanist777LightBT\"), url('Humanist777LightBT.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"HelveticaNeue-Regular\";\n  src: local(\"HelveticaNeue-Regular\"), url('HelveticaNeue-Regular.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Black\";\n  src: local(\"Tajawal-Black\"), url('Tajawal-Black.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Bold\";\n  src: local(\"Tajawal-Bold\"), url('Tajawal-Bold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraBold\";\n  src: local(\"Tajawal-ExtraBold\"), url('Tajawal-ExtraBold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraLight\";\n  src: local(\"Tajawal-ExtraLight\"), url('Tajawal-ExtraLight.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Light\";\n  src: local(\"Tajawal-Light\"), url('Tajawal-Light.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Medium\";\n  src: local(\"Tajawal-Medium\"), url('Tajawal-Medium.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Regular\";\n  src: local(\"Tajawal-Regular\"), url('Tajawal-Regular.ttf') format(\"truetype\");\n}\n.font-HomepageBaukasten-Book[_ngcontent-%COMP%] {\n  font-family: \"HomepageBaukasten-Book\";\n}\n.font-Humanist521BT-Roman[_ngcontent-%COMP%] {\n  font-family: \"Humanist521BT-Roman\";\n}\n.font-Humanist777BT-RomanB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanB\";\n}\n.font-Humanist777BT-BoldCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n}\n.font-Humanist777BT-RomanCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n}\n.font-Humanist777BT-BlackCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n}\n.font-Humanist777LightBT[_ngcontent-%COMP%] {\n  font-family: \"Humanist777LightBT\" !important;\n}\n.font-HelveticaNeue-Regular[_ngcontent-%COMP%] {\n  font-family: \"HelveticaNeue-Regular\";\n}\n.font-Tajawal-Black[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Black\";\n}\n.font-Tajawal-Bold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Bold\";\n}\n.font-Tajawal-ExtraBold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraBold\";\n}\n.font-Tajawal-ExtraLight[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraLight\";\n}\n.font-Tajawal-Light[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Light\";\n}\n.font-Tajawal-Medium[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Medium\";\n}\n.font-Tajawal-Regular[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Regular\";\n}\na[_ngcontent-%COMP%]:hover {\n  color: initial;\n  text-decoration: none;\n}\n.border-color[_ngcontent-%COMP%] {\n  border-color: #dedede !important;\n}\n.container-fluid[_ngcontent-%COMP%] {\n  width: 100%;\n  padding-right: 25px;\n  padding-left: 25px;\n  margin-right: auto;\n  margin-left: auto;\n}\n.full-width[_ngcontent-%COMP%], .aboutUsPage[_ngcontent-%COMP%], .humanKnowCoffee[_ngcontent-%COMP%], .benefitsAndHarms[_ngcontent-%COMP%], .preparationPage[_ngcontent-%COMP%], .galleryPage[_ngcontent-%COMP%], .productPage[_ngcontent-%COMP%] {\n  max-width: 100%;\n  margin: 0 auto;\n}\na[_ngcontent-%COMP%] {\n  color: initial;\n  text-decoration: none;\n  background-color: transparent;\n}\n.br-1px[_ngcontent-%COMP%] {\n  border-right: 1px solid;\n}\n.ngx-gallery-icon[_ngcontent-%COMP%] {\n  color: red;\n  background: blue;\n}\ngallery-item[_ngcontent-%COMP%] {\n  padding: 2em;\n  border: 2px solid #ebc850 !important;\n}\n.ml-1em[_ngcontent-%COMP%] {\n  margin-left: 1em;\n}\n.border[_ngcontent-%COMP%] {\n  border: 1px solid;\n}\n.roundedCorner[_ngcontent-%COMP%] {\n  border-radius: 30px;\n}\n.mt-1em[_ngcontent-%COMP%] {\n  margin-top: 1em;\n}\n.mt-2em[_ngcontent-%COMP%] {\n  margin-top: 2em;\n}\n.pr-0[_ngcontent-%COMP%] {\n  padding-right: 0;\n}\n.pl-0[_ngcontent-%COMP%] {\n  padding-left: 0;\n}\n.section[_ngcontent-%COMP%] {\n  padding: 2em 0;\n}\n.d-flex[_ngcontent-%COMP%] {\n  display: flex;\n}\n.justify-center[_ngcontent-%COMP%] {\n  justify-content: center;\n}\n.align-center[_ngcontent-%COMP%] {\n  align-items: center;\n}\ngallery-thumbs[_ngcontent-%COMP%] {\n  display: none !important;\n}\n.select-gender[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\n.select-gender[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  text-indent: 15px;\n  text-overflow: \"\";\n  width: 90%;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  padding: 2px 2px 2px 2px;\n  border: none;\n  background: transparent url(\"http://cdn1.iconfinder.com/data/icons/cc_mono_icon_set/blacks/16x16/br_down.png\") no-repeat 230px !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%] {\n  display: flex !important;\n  align-items: center !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%]   .modal-dialog[_ngcontent-%COMP%] {\n  flex-grow: 1;\n}\n.our-branch-address[_ngcontent-%COMP%]   .accordion[_ngcontent-%COMP%]    > .card[_ngcontent-%COMP%]    > .card-header[_ngcontent-%COMP%] {\n  padding: 0;\n  background-color: #ebc850 !important;\n}\n.our-branch-address[_ngcontent-%COMP%]   .panelTitle[_ngcontent-%COMP%] {\n  font-size: 1.25rem;\n  line-height: 1.25rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%] {\n  font-weight: 500;\n  color: #1d1d1b;\n  font-size: 1.5rem;\n  line-height: 2.5rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%]:focus {\n  box-shadow: none !important;\n  text-decoration: none;\n}\n.g-btn-close[_ngcontent-%COMP%] {\n  display: none;\n}\npath[_ngcontent-%COMP%] {\n  fill: #bc8033;\n}\n@media (min-width: 767px) {\n  .navbar-expand-md[_ngcontent-%COMP%]   .navbar-nav[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n    padding-right: 0.3rem !important;\n    padding-left: 0.3rem !important;\n    font-size: 16px !important;\n  }\n}\n@media (max-width: 2560px) {\n  .webView[_ngcontent-%COMP%] {\n    background-size: cover !important;\n  }\n}\n.direction_ltr[_ngcontent-%COMP%] {\n  direction: ltr !important;\n}\n.iti[_ngcontent-%COMP%] {\n  width: 100%;\n}\nbutton.close[_ngcontent-%COMP%] {\n  padding: 0.5em !important;\n  border: none !important;\n}\n.btn_primary[_ngcontent-%COMP%] {\n  background: #432919;\n  color: #ebc850;\n}\ninput[_ngcontent-%COMP%]::-webkit-outer-spin-button, input[_ngcontent-%COMP%]::-webkit-inner-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n\ninput[type=number][_ngcontent-%COMP%] {\n  -moz-appearance: textfield;\n}\n.text-primary[_ngcontent-%COMP%] {\n  color: #ebc850 !important;\n}\n.min-height-10[_ngcontent-%COMP%] {\n  min-height: 10em;\n}\n.pac-container[_ngcontent-%COMP%] {\n  background-color: #fff;\n  position: absolute !important;\n  z-index: 9999999999;\n  border-radius: 2px;\n  border-top: 0;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);\n  box-sizing: border-box;\n  overflow: hidden;\n  font-size: 16px;\n  color: #ebc850;\n}\n.pac-logo[_ngcontent-%COMP%]:after {\n  content: \"\";\n  padding: 1px 1px 1px 0;\n  height: 16px;\n  text-align: right;\n  display: block;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3.png);\n  background-position: right;\n  background-repeat: no-repeat;\n  background-size: 120px 14px;\n}\n.hdpi.pac-logo[_ngcontent-%COMP%]:after {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3_hdpi.png);\n}\n.pac-item[_ngcontent-%COMP%] {\n  cursor: default;\n  padding: 4px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n  line-height: 30px;\n  text-align: left;\n  border-top: 0;\n  font-size: 13px;\n  color: #999;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n}\n.pac-item[_ngcontent-%COMP%]:hover {\n  background-color: #fafafa;\n}\n.pac-item-selected[_ngcontent-%COMP%], .pac-item-selected[_ngcontent-%COMP%]:hover {\n  background-color: #ebf2fe;\n}\n.pac-matched[_ngcontent-%COMP%] {\n  font-weight: 700;\n}\n.pac-item-query[_ngcontent-%COMP%] {\n  font-size: 16px;\n  padding-right: 3px;\n  color: #ebc850;\n}\n.pac-icon[_ngcontent-%COMP%] {\n  width: 15px;\n  height: 20px;\n  margin-right: 7px;\n  margin-top: 6px;\n  display: inline-block;\n  vertical-align: top;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons.png);\n  background-size: 34px;\n}\n.hdpi[_ngcontent-%COMP%]   .pac-icon[_ngcontent-%COMP%] {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons_hdpi.png);\n}\n.pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -1px -1px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -18px -1px;\n}\n.pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -1px -161px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -18px -161px;\n}\n.pac-placeholder[_ngcontent-%COMP%] {\n  color: gray;\n}\n.form-control[_ngcontent-%COMP%]:focus {\n  box-shadow: 0 0 0 0.05rem #9f9f9f;\n}\n.page-link[_ngcontent-%COMP%] {\n  border-color: #432919 !important;\n  color: #432919 !important;\n}\n.page-item.active[_ngcontent-%COMP%]   .page-link[_ngcontent-%COMP%] {\n  background-color: #432919 !important;\n  border-color: #432919 !important;\n  color: #ebc850 !important;\n}\n.b-0[_ngcontent-%COMP%] {\n  bottom: 0px;\n}\n.loader_section[_ngcontent-%COMP%] {\n  display: flex;\n  height: 100vh;\n  align-items: center;\n}\n.loader[_ngcontent-%COMP%], .loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  background: #ebc850;\n  -webkit-animation: load1 1s infinite ease-in-out;\n  animation: load1 1s infinite ease-in-out;\n  width: 1em;\n  height: 4em;\n}\n.loader[_ngcontent-%COMP%] {\n  color: #ebc850;\n  text-indent: -9999em;\n  margin: 88px auto;\n  position: relative;\n  font-size: 11px;\n  transform: translateZ(0);\n  -webkit-animation-delay: -0.16s;\n  animation-delay: -0.16s;\n}\n.loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  position: absolute;\n  top: 0;\n  content: \"\";\n}\n.loader[_ngcontent-%COMP%]:before {\n  left: -1.5em;\n  -webkit-animation-delay: -0.32s;\n  animation-delay: -0.32s;\n}\n.loader[_ngcontent-%COMP%]:after {\n  left: 1.5em;\n}\n@-webkit-keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n@keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n.banner[_ngcontent-%COMP%]   .banner-img[_ngcontent-%COMP%] {\n  position: relative;\n}\n.banner[_ngcontent-%COMP%]   .banner-img[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n  image-rendering: -moz-crisp-edges;\n  image-rendering: pixelated;\n  -o-object-fit: cover;\n     object-fit: cover;\n  margin-left: -1px;\n  margin-top: -1px;\n}\n.banner[_ngcontent-%COMP%]   .banner-wrap[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 10px;\n  left: 2%;\n}\n.banner[_ngcontent-%COMP%]   .banner-title[_ngcontent-%COMP%] {\n  color: #ebc850;\n  font-size: 3.75rem;\n  line-height: 5rem;\n}\n.section-title[_ngcontent-%COMP%] {\n  font-size: 2rem;\n  line-height: 2.5rem;\n  font-weight: bold;\n  text-transform: uppercase;\n}\n.section-title-ar[_ngcontent-%COMP%] {\n  font-size: 2.25rem !important;\n}\n.banner-title[_ngcontent-%COMP%] {\n  color: #ebc850;\n  font-size: 3.75rem;\n  line-height: 5rem;\n}\n.banner-title[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin-bottom: 0;\n}\n.breadcrumbs[_ngcontent-%COMP%] {\n  color: #9f9f9f;\n  font-size: 1.25rem;\n  line-height: 2.5rem;\n}\n.breadcrumbs[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #9f9f9f !important;\n}\n.breadcrumbs__ar[_ngcontent-%COMP%] {\n  font-size: 1.625rem !important;\n}\n.nav-tabs[_ngcontent-%COMP%] {\n  display: flex;\n  border-bottom: 1px solid #dee2e6;\n  justify-content: space-between;\n}\n.nav-tabs[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  width: 16.6667%;\n}\n.nav-tabs[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  text-align: center;\n  color: #1d1d1b;\n  font-size: 1.75rem;\n  font-weight: 900;\n  line-height: 3.125rem;\n}\n.nav-tabs[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   .nav_tabs_ar[_ngcontent-%COMP%] {\n  font-size: 1.875rem !important;\n}\n.nav-tabs[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n  margin-bottom: -1px;\n  border: 1px solid #000;\n  border-top-left-radius: 0;\n  border-top-right-radius: 0;\n}\n.nav-item[_ngcontent-%COMP%] {\n  position: relative;\n}\n.active[_ngcontent-%COMP%] {\n  background: #ebc850 !important;\n}\n.active[_ngcontent-%COMP%]:after {\n  content: \"\u25B4\";\n  position: absolute;\n  font-family: font-awesome;\n  top: 1.35em;\n  left: 50%;\n  transform: translateX(-50%);\n}\n.preparation-section[_ngcontent-%COMP%] {\n  padding-top: 33px;\n}\n.preparation-section[_ngcontent-%COMP%]   .preparation-listes[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  font-size: 1.75rem;\n  line-height: 2.5rem;\n  color: #1d1d1b;\n}\n.preparation-section[_ngcontent-%COMP%]   .preparation-listes[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   [_ngcontent-%COMP%]::marker {\n  font-weight: 900 !important;\n}\n.preparation-section[_ngcontent-%COMP%]   .preparation-listes-ar[_ngcontent-%COMP%] {\n  font-size: 2rem !important;\n}\n.nav-tabs[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n  margin-bottom: -1px;\n  border: 1px solid #000;\n  border-top-left-radius: 0;\n  border-top-right-radius: 0;\n  margin-left: -1px;\n}\n.nav-tabs[_ngcontent-%COMP%]   .nav-link.active[_ngcontent-%COMP%], .nav-tabs[_ngcontent-%COMP%]   .nav-item.show[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n  font-weight: 900;\n  color: #1d1d1b;\n}\n.arabicSection[_ngcontent-%COMP%] {\n  padding: 0 0 2em 0;\n}\n.notess[_ngcontent-%COMP%] {\n  margin-bottom: 1.25rem;\n  font-size: 1.75rem;\n  line-height: 2.5rem;\n}\n.notesSection[_ngcontent-%COMP%] {\n  border-top: 7px solid #ebc850;\n}\n.notesSection[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin: 1em 1em 0 0.5em;\n  font-size: 1.75rem;\n  line-height: 2.5rem;\n  font-family: \"Humanist777BT-RomanB\";\n  padding-bottom: 50px;\n}\nol[_ngcontent-%COMP%] {\n  margin: 0 0 1.5em;\n  padding: 0;\n  counter-reset: item;\n}\nol[_ngcontent-%COMP%]    > li[_ngcontent-%COMP%] {\n  margin: 0 0px 12px;\n  padding: 0 0 0 2em;\n  text-indent: -1.3em;\n  list-style-type: none;\n  counter-increment: item;\n}\nol[_ngcontent-%COMP%]    > li[_ngcontent-%COMP%]:before {\n  display: inline-block;\n  width: 1.5em;\n  padding-right: 0.5em;\n  font-weight: bold;\n  text-align: right;\n  content: counter(item) \"-\";\n}\n.mobileView[_ngcontent-%COMP%] {\n  display: none;\n}\n@media (max-width: 1440px) {\n  .banner[_ngcontent-%COMP%]   .banner-wrap[_ngcontent-%COMP%] {\n    position: absolute;\n    bottom: 10px;\n    left: 2%;\n  }\n}\n@media (max-width: 1366px) {\n  .banner[_ngcontent-%COMP%]   .banner-wrap[_ngcontent-%COMP%] {\n    left: 0%;\n  }\n}\n@media (max-width: 1280px) {\n  .active[_ngcontent-%COMP%]:after {\n    top: 1.35em;\n  }\n\n  .banner[_ngcontent-%COMP%] {\n    min-height: 0;\n  }\n\n  .banner[_ngcontent-%COMP%]   .banner-wrap[_ngcontent-%COMP%] {\n    bottom: 0px;\n  }\n}\n@media (max-width: 991px) {\n  .banner[_ngcontent-%COMP%]   .banner-wrap[_ngcontent-%COMP%] {\n    bottom: 0px;\n  }\n\n  .banner[_ngcontent-%COMP%]   .banner-title[_ngcontent-%COMP%] {\n    font-size: 2.75rem;\n    line-height: 4rem;\n  }\n}\n@media only screen and (max-width: 991px) {\n  .web-banner[_ngcontent-%COMP%] {\n    text-align: inherit;\n    min-height: unset !important;\n    height: 100%;\n    background-position: center;\n    background-size: 100% 100%;\n    position: relative;\n  }\n\n  .nav-tabs[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n    width: 33.3% !important;\n  }\n}\n@media only screen and (max-width: 767px) {\n  .nav-tabs[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n    width: 50% !important;\n  }\n\n  .benefits-title[_ngcontent-%COMP%] {\n    margin: 1em 0;\n  }\n\n  .mobileView[_ngcontent-%COMP%] {\n    position: relative;\n    display: block;\n  }\n\n  .banner-title[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n    font-size: 22px;\n    color: #ebc850;\n    top: 1em;\n    position: absolute;\n  }\n\n  .web-banner[_ngcontent-%COMP%] {\n    display: none !important;\n  }\n\n  .web-banner[_ngcontent-%COMP%]   .banner-title[_ngcontent-%COMP%] {\n    font-size: 16px;\n  }\n\n  .banner-title[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n    font-size: 40px !important;\n    color: #ebc850;\n    margin: 0px 0px;\n  }\n\n  .section[_ngcontent-%COMP%] {\n    padding: 0px 0px !important;\n  }\n\n  .breadcrumbs[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n    margin-bottom: 10px !important;\n    font-size: 15px;\n    line-height: 40px !important;\n  }\n\n  .breadcrumbs[_ngcontent-%COMP%] {\n    margin-bottom: 0px;\n  }\n\n  .preparation-section[_ngcontent-%COMP%] {\n    padding: 0;\n    text-align: left;\n  }\n\n  .section-title[_ngcontent-%COMP%] {\n    font-size: 22px;\n    line-height: 40px;\n    text-align: center;\n  }\n\n  .container-fluid[_ngcontent-%COMP%] {\n    padding: 0px 20px;\n  }\n\n  .nav-tabs[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n    padding: 0px 0px 0px;\n  }\n\n  .active[_ngcontent-%COMP%]:after {\n    top: 0.8em;\n  }\n\n  .arabicSection[_ngcontent-%COMP%] {\n    padding: 0;\n  }\n\n  .preparation-section[_ngcontent-%COMP%]   .preparation-listes[_ngcontent-%COMP%]   li[_ngcontent-%COMP%], .notesSection[_ngcontent-%COMP%]   p[_ngcontent-%COMP%], .notess[_ngcontent-%COMP%] {\n    font-size: 20px;\n    line-height: 24px;\n    margin-right: 10px;\n  }\n\n  #exp-order1[_ngcontent-%COMP%] {\n    order: 1;\n  }\n\n  #exp-order2[_ngcontent-%COMP%] {\n    order: 2;\n    display: none;\n  }\n\n  .arabicSection[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n    margin: 0 auto !important;\n  }\n\n  .banner[_ngcontent-%COMP%]   .banner-wrap[_ngcontent-%COMP%] {\n    bottom: 5px;\n  }\n\n  .banner[_ngcontent-%COMP%]   .banner-title[_ngcontent-%COMP%] {\n    font-size: 2rem;\n    line-height: 2.5rem;\n  }\n\n  .banner[_ngcontent-%COMP%]   .banner-img[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n    -o-object-fit: fill;\n       object-fit: fill;\n    height: 160px;\n  }\n}\n@media (max-width: 575px) {\n  .webView[_ngcontent-%COMP%] {\n    background-size: cover;\n    background-position: 0% 17%;\n  }\n\n  .webView[_ngcontent-%COMP%]   .banner-title[_ngcontent-%COMP%] {\n    color: #ebc850;\n    font-size: 22px !important;\n    line-height: 40px !important;\n    top: 0;\n    position: relative;\n  }\n\n  .banner[_ngcontent-%COMP%]   .banner-img[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n    -o-object-fit: fill;\n       object-fit: fill;\n    height: 130px;\n  }\n\n  .banner[_ngcontent-%COMP%]   .banner-wrap[_ngcontent-%COMP%] {\n    bottom: 5px;\n  }\n}\n.full-width-custom[_ngcontent-%COMP%] {\n  width: 1366px;\n}\n.text-align-custom[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin-top: 0px;\n  margin-bottom: 1rem;\n}\n.text-align-custom[_ngcontent-%COMP%] {\n  position: absolute !important;\n  bottom: 0% !important;\n  left: 2% !important;\n  transform: translate(-3%, 0%) !important;\n}\n.notesSection[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin-right: 0;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ "1LmZ":
/*!**********************************************!*\
  !*** ./src/app/pages/home/home.component.ts ***!
  \**********************************************/
/*! exports provided: HomeComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HomeComponent", function() { return HomeComponent; });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "LvDl");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var src_app_services_home_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/home.service */ "nr5L");
/* harmony import */ var src_app_services_cms_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/services/cms.service */ "/Ffc");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _shared_header_header_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../shared/header/header.component */ "320Y");
/* harmony import */ var _shared_footer_footer_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../shared/footer/footer.component */ "jQpT");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");









function HomeComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "div", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} }
function HomeComponent_div_1_div_18_div_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "span", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](3, "i", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} }
function HomeComponent_div_1_div_18_span_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "span", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "HOME.VAT_INC"));
} }
function HomeComponent_div_1_div_18_p_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "p", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "HOME.VAT_INC"));
} }
function HomeComponent_div_1_div_18_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](2, "img", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, HomeComponent_div_1_div_18_div_6_Template, 4, 0, "div", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "div", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](11, HomeComponent_div_1_div_18_span_11_Template, 3, 3, "span", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](12, HomeComponent_div_1_div_18_p_12_Template, 3, 3, "p", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const item_r4 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"]("src", item_r4.image, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r2.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r2.lang === "AR" ? item_r4.ar_name : item_r4.name);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r2.numSequence(item_r4.rating));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r2.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate2"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](10, 9, "HOME.AED"), " ", item_r4.price, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r2.lang === "EN");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r2.lang === "AR");
} }
function HomeComponent_div_1_div_40_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "img", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const bannerimage_r9 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate1"]("src", "https://click2eat.nyc3.cdn.digitaloceanspaces.com/", bannerimage_r9.image, "", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
} }
function HomeComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "app-header", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](5, "img", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](8, "p", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](9, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](10, "p", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "div", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "div", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "p", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](16, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](18, HomeComponent_div_1_div_18_Template, 13, 11, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function HomeComponent_div_1_Template_button_click_20_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r11); const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r10.redirectToShop(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](22, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](23, "div", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](24, "div", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](25, "div", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](26, "p", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](28, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](29, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](30, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](32, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](33, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](34, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](35, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](36, "h3", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](37);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](38, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](39, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](40, HomeComponent_div_1_div_40_Template, 2, 1, "div", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](41, "app-footer");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("src", ctx_r1.lang === "AR" ? ctx_r1.getImage("background_image_ar") : ctx_r1.getImage("background_image"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "EN" ? "homePageBanner" : "homePageBannerArabic");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "EN")("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold bannerSection__title__ar" : "font-Humanist777BT-BoldCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"]("innerHtml", ctx_r1.lang === "AR" ? ctx_r1.getContent("title_ar") : ctx_r1.getContent("title"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeHtml"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Regular description" : "font-Humanist777BT-RomanB description");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"]("innerHtml", ctx_r1.lang === "AR" ? ctx_r1.getContent("title_description_ar") : ctx_r1.getContent("title_description"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeHtml"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777BT-BoldCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](16, 19, "HOME.FEATURED_PRODUCTS"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r1.products);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-RomanCondense");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](22, 21, "HOME.CLICK_HERE_TO_ORDER"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777BT-BoldCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent("section3_title_ar") : ctx_r1.getContent("section3_title"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent("section3_description_ar") : ctx_r1.getContent("section3_description"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold socialMedia__title__ar" : "font-Humanist777BT-BoldCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](38, 23, "HOME.WE_ON_SOCIAL_MEDIA"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r1.banners);
} }
/**
 * Home page
 */
class HomeComponent {
    /**
     * @constructor
     */
    constructor(router, homeservice, cmsService) {
        this.router = router;
        this.homeservice = homeservice;
        this.cmsService = cmsService;
        this.product = [];
        this.products = [];
        this.banner = [];
        this.banners = [];
        this.content = [];
        this.imageBaseUrl = '';
        window.scroll(0, 0);
    }
    /**
     * page initialization
     */
    ngOnInit() {
        // this.lang = sessionStorage.getItem('language');
        console.log(this.lang);
        this.getHomePageContent();
        this.getBannerList();
        this.getProductList();
        setInterval(() => {
            this.lang = sessionStorage.getItem('language');
        }, 1000);
    }
    /**
     * Get Product list
     */
    getProductList() {
        this.homeservice.getProductList().subscribe((datas) => {
            this.product.push(datas);
            this.products = this.product[0].data;
        });
    }
    /**
     * Get Banner list
     */
    getBannerList() {
        this.homeservice.getbannerlist().subscribe((data) => {
            this.banner.push(data);
            this.banners = this.banner[0].data;
        });
    }
    /**
     *  This is a description of the foo function.
     * @param {number} n
     * @return {array}
     */
    numSequence(n) {
        return Array(n);
    }
    /**
     * Redirect to shop page
     */
    redirectToShop() {
        this.lang === 'AR' ? this.router.navigate(['/ar/product']) : this.router.navigate(['/product']);
    }
    /**
     * get home page content
     */
    getHomePageContent() {
        this.cmsService.getPageContent('get_cms_home_content').subscribe((response) => {
            if (response['status']) {
                this.content = response['data'];
                this.imageBaseUrl = response['base_image_url'];
            }
        });
    }
    /**
     * Get content
     * @param {string} key
     * @return {object}
     */
    getContent(key) {
        var _a;
        const filterData = lodash__WEBPACK_IMPORTED_MODULE_0___default.a.filter(this.content, ['section', key]);
        return (_a = filterData[0]) === null || _a === void 0 ? void 0 : _a.content;
    }
    /**
     * Get content
     * @param {string} key
     * @return {object}
     */
    getImage(key) {
        var _a;
        const filterData = lodash__WEBPACK_IMPORTED_MODULE_0___default.a.filter(this.content, ['section', key]);
        return `${this.imageBaseUrl}${(_a = filterData[0]) === null || _a === void 0 ? void 0 : _a.content}`;
    }
}
HomeComponent.ɵfac = function HomeComponent_Factory(t) { return new (t || HomeComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_2__["Router"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](src_app_services_home_service__WEBPACK_IMPORTED_MODULE_3__["HomeService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](src_app_services_cms_service__WEBPACK_IMPORTED_MODULE_4__["CmsService"])); };
HomeComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: HomeComponent, selectors: [["app-home"]], decls: 2, vars: 2, consts: [["class", "loader_section", 4, "ngIf"], [4, "ngIf"], [1, "loader_section"], [1, "loader"], ["setActive", "home"], [1, "homePage"], [1, "bannerSection"], [1, "banner-img"], [1, "img-fluid", 3, "src"], [3, "ngClass"], [1, "text-white", "bannerSection__title", 3, "ngClass"], [3, "innerHtml"], [1, "text-white", 3, "innerHtml"], [1, "featuredProducts", "full-width", "full-width-custom"], [1, "container-fluid"], [1, "featuredProduct"], [1, "text-center", "featuredProduct-title", 3, "ngClass"], [1, "row"], ["class", "col-xxl-3 col-xl-3 col-md-3 col-sm-6", 4, "ngFor", "ngForOf"], [1, "featuredProduct-order", "text-center", 3, "ngClass"], [1, "roundedCorner", 3, "click"], [1, "tasteSection"], [1, "container-fluid", "text-center"], [1, "tasteSection-content"], [1, "tasteSection-title", 3, "ngClass"], [1, "tasteSection-description", "text-white", 3, "ngClass"], [1, "socialMedia", "section", "full-width", "full-width-custom"], [1, "col-md-12"], [1, "text-center", "socialMedia__title", 3, "ngClass"], ["class", "col-lg-4 col-md-6 col-sm-6 col-12 mt-1em mb-3 pa-r-0 pa-l-0", 4, "ngFor", "ngForOf"], [1, "col-xxl-3", "col-xl-3", "col-md-3", "col-sm-6"], [1, "featuredProduct-details", "text-center"], ["alt", "featuredProduct", 1, "img-fluid", 3, "src"], [1, "featuredProduct__type", 3, "ngClass"], ["class", "featuredProduct-rating", 4, "ngFor", "ngForOf"], [1, "featuredProduct__type", "price-tax", 3, "ngClass"], ["class", "inc", 4, "ngIf"], [1, "featuredProduct-rating"], [1, "stars"], [1, "fa", "fa-star"], [1, "inc"], [1, "col-lg-4", "col-md-6", "col-sm-6", "col-12", "mt-1em", "mb-3", "pa-r-0", "pa-l-0"]], template: function HomeComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, HomeComponent_div_0_Template, 2, 0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, HomeComponent_div_1_Template, 42, 25, "div", 1);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.content || ctx.content.length === 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.content.length > 0);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_5__["NgIf"], _shared_header_header_component__WEBPACK_IMPORTED_MODULE_6__["HeaderComponent"], _angular_common__WEBPACK_IMPORTED_MODULE_5__["NgClass"], _angular_common__WEBPACK_IMPORTED_MODULE_5__["NgForOf"], _shared_footer_footer_component__WEBPACK_IMPORTED_MODULE_7__["FooterComponent"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__["TranslatePipe"]], styles: ["@font-face {\n  font-family: \"HomepageBaukasten-Book\";\n  src: local(\"HomepageBaukasten-Book\"), url('HomepageBaukasten-Book.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist521BT-Roman\";\n  src: local(\"Humanist521BT-Roman\"), url('Humanist521BT-Roman.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanB\";\n  src: local(\"Humanist777BT-RomanB\"), url('Humanist777BT-RomanB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n  src: local(\"Humanist777BT-BoldCondensedB\"), url('Humanist777BT-BoldCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n  src: local(\"Humanist777BT-RomanCondensedB\"), url('Humanist777BT-RomanCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n  src: local(\"Humanist777BT-BlackCondensedB\"), url('Humanist777BT-BlackCondensed.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist777LightBT\";\n  src: local(\"Humanist777LightBT\"), url('Humanist777LightBT.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"HelveticaNeue-Regular\";\n  src: local(\"HelveticaNeue-Regular\"), url('HelveticaNeue-Regular.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Black\";\n  src: local(\"Tajawal-Black\"), url('Tajawal-Black.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Bold\";\n  src: local(\"Tajawal-Bold\"), url('Tajawal-Bold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraBold\";\n  src: local(\"Tajawal-ExtraBold\"), url('Tajawal-ExtraBold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraLight\";\n  src: local(\"Tajawal-ExtraLight\"), url('Tajawal-ExtraLight.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Light\";\n  src: local(\"Tajawal-Light\"), url('Tajawal-Light.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Medium\";\n  src: local(\"Tajawal-Medium\"), url('Tajawal-Medium.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Regular\";\n  src: local(\"Tajawal-Regular\"), url('Tajawal-Regular.ttf') format(\"truetype\");\n}\n.font-HomepageBaukasten-Book {\n  font-family: \"HomepageBaukasten-Book\";\n}\n.font-Humanist521BT-Roman {\n  font-family: \"Humanist521BT-Roman\";\n}\n.font-Humanist777BT-RomanB {\n  font-family: \"Humanist777BT-RomanB\";\n}\n.font-Humanist777BT-BoldCondensedB {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n}\n.font-Humanist777BT-RomanCondensedB {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n}\n.font-Humanist777BT-BlackCondensedB {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n}\n.font-Humanist777LightBT {\n  font-family: \"Humanist777LightBT\" !important;\n}\n.font-HelveticaNeue-Regular {\n  font-family: \"HelveticaNeue-Regular\";\n}\n.font-Tajawal-Black {\n  font-family: \"Tajawal-Black\";\n}\n.font-Tajawal-Bold {\n  font-family: \"Tajawal-Bold\";\n}\n.font-Tajawal-ExtraBold {\n  font-family: \"Tajawal-ExtraBold\";\n}\n.font-Tajawal-ExtraLight {\n  font-family: \"Tajawal-ExtraLight\";\n}\n.font-Tajawal-Light {\n  font-family: \"Tajawal-Light\";\n}\n.font-Tajawal-Medium {\n  font-family: \"Tajawal-Medium\";\n}\n.font-Tajawal-Regular {\n  font-family: \"Tajawal-Regular\";\n}\na:hover {\n  color: initial;\n  text-decoration: none;\n}\n.border-color {\n  border-color: #dedede !important;\n}\n.container-fluid {\n  width: 100%;\n  padding-right: 25px;\n  padding-left: 25px;\n  margin-right: auto;\n  margin-left: auto;\n}\n.full-width,\n.aboutUsPage,\n.humanKnowCoffee,\n.benefitsAndHarms,\n.preparationPage,\n.galleryPage,\n.productPage {\n  max-width: 100%;\n  margin: 0 auto;\n}\na {\n  color: initial;\n  text-decoration: none;\n  background-color: transparent;\n}\n.br-1px {\n  border-right: 1px solid;\n}\n.ngx-gallery-icon {\n  color: red;\n  background: blue;\n}\ngallery-item {\n  padding: 2em;\n  border: 2px solid #ebc850 !important;\n}\n.ml-1em {\n  margin-left: 1em;\n}\n.border {\n  border: 1px solid;\n}\n.roundedCorner {\n  border-radius: 30px;\n}\n.mt-1em {\n  margin-top: 1em;\n}\n.mt-2em {\n  margin-top: 2em;\n}\n.pr-0 {\n  padding-right: 0;\n}\n.pl-0 {\n  padding-left: 0;\n}\n.section {\n  padding: 2em 0;\n}\n.d-flex {\n  display: flex;\n}\n.justify-center {\n  justify-content: center;\n}\n.align-center {\n  align-items: center;\n}\ngallery-thumbs {\n  display: none !important;\n}\n.select-gender {\n  overflow: hidden;\n}\n.select-gender select {\n  text-indent: 15px;\n  text-overflow: \"\";\n  width: 90%;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  padding: 2px 2px 2px 2px;\n  border: none;\n  background: transparent url(\"http://cdn1.iconfinder.com/data/icons/cc_mono_icon_set/blacks/16x16/br_down.png\") no-repeat 230px !important;\n}\n.modal-open .modal {\n  display: flex !important;\n  align-items: center !important;\n}\n.modal-open .modal .modal-dialog {\n  flex-grow: 1;\n}\n.our-branch-address .accordion > .card > .card-header {\n  padding: 0;\n  background-color: #ebc850 !important;\n}\n.our-branch-address .panelTitle {\n  font-size: 1.25rem;\n  line-height: 1.25rem;\n}\n.our-branch-address .btn.btn-link {\n  font-weight: 500;\n  color: #1d1d1b;\n  font-size: 1.5rem;\n  line-height: 2.5rem;\n}\n.our-branch-address .btn.btn-link:focus {\n  box-shadow: none !important;\n  text-decoration: none;\n}\n.g-btn-close {\n  display: none;\n}\npath {\n  fill: #bc8033;\n}\n@media (min-width: 767px) {\n  .navbar-expand-md .navbar-nav .nav-link {\n    padding-right: 0.3rem !important;\n    padding-left: 0.3rem !important;\n    font-size: 16px !important;\n  }\n}\n@media (max-width: 2560px) {\n  .webView {\n    background-size: cover !important;\n  }\n}\n.direction_ltr {\n  direction: ltr !important;\n}\n.iti {\n  width: 100%;\n}\nbutton.close {\n  padding: 0.5em !important;\n  border: none !important;\n}\n.btn_primary {\n  background: #432919;\n  color: #ebc850;\n}\ninput::-webkit-outer-spin-button,\ninput::-webkit-inner-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n/* Firefox */\ninput[type=number] {\n  -moz-appearance: textfield;\n}\n.text-primary {\n  color: #ebc850 !important;\n}\n.min-height-10 {\n  min-height: 10em;\n}\n.pac-container {\n  background-color: #fff;\n  position: absolute !important;\n  z-index: 9999999999;\n  border-radius: 2px;\n  border-top: 0;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);\n  box-sizing: border-box;\n  overflow: hidden;\n  font-size: 16px;\n  color: #ebc850;\n}\n.pac-logo:after {\n  content: \"\";\n  padding: 1px 1px 1px 0;\n  height: 16px;\n  text-align: right;\n  display: block;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3.png);\n  background-position: right;\n  background-repeat: no-repeat;\n  background-size: 120px 14px;\n}\n.hdpi.pac-logo:after {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3_hdpi.png);\n}\n.pac-item {\n  cursor: default;\n  padding: 4px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n  line-height: 30px;\n  text-align: left;\n  border-top: 0;\n  font-size: 13px;\n  color: #999;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n}\n.pac-item:hover {\n  background-color: #fafafa;\n}\n.pac-item-selected,\n.pac-item-selected:hover {\n  background-color: #ebf2fe;\n}\n.pac-matched {\n  font-weight: 700;\n}\n.pac-item-query {\n  font-size: 16px;\n  padding-right: 3px;\n  color: #ebc850;\n}\n.pac-icon {\n  width: 15px;\n  height: 20px;\n  margin-right: 7px;\n  margin-top: 6px;\n  display: inline-block;\n  vertical-align: top;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons.png);\n  background-size: 34px;\n}\n.hdpi .pac-icon {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons_hdpi.png);\n}\n.pac-icon-search {\n  background-position: -1px -1px;\n}\n.pac-item-selected .pac-icon-search {\n  background-position: -18px -1px;\n}\n.pac-icon-marker {\n  background-position: -1px -161px;\n}\n.pac-item-selected .pac-icon-marker {\n  background-position: -18px -161px;\n}\n.pac-placeholder {\n  color: gray;\n}\n.form-control:focus {\n  box-shadow: 0 0 0 0.05rem #9f9f9f;\n}\n.page-link {\n  border-color: #432919 !important;\n  color: #432919 !important;\n}\n.page-item.active .page-link {\n  background-color: #432919 !important;\n  border-color: #432919 !important;\n  color: #ebc850 !important;\n}\n.b-0 {\n  bottom: 0px;\n}\n.loader_section {\n  display: flex;\n  height: 100vh;\n  align-items: center;\n}\n.loader,\n.loader:before,\n.loader:after {\n  background: #ebc850;\n  -webkit-animation: load1 1s infinite ease-in-out;\n  animation: load1 1s infinite ease-in-out;\n  width: 1em;\n  height: 4em;\n}\n.loader {\n  color: #ebc850;\n  text-indent: -9999em;\n  margin: 88px auto;\n  position: relative;\n  font-size: 11px;\n  transform: translateZ(0);\n  -webkit-animation-delay: -0.16s;\n  animation-delay: -0.16s;\n}\n.loader:before,\n.loader:after {\n  position: absolute;\n  top: 0;\n  content: \"\";\n}\n.loader:before {\n  left: -1.5em;\n  -webkit-animation-delay: -0.32s;\n  animation-delay: -0.32s;\n}\n.loader:after {\n  left: 1.5em;\n}\n@-webkit-keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n@keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n.bannerSection .bannerSection__title {\n  font-size: 6.25rem;\n  display: block;\n  line-height: 5.625rem;\n}\n.bannerSection p {\n  display: block;\n  width: 70%;\n}\n.bannerSection .bannerSection__title__ar {\n  font-size: 5.625rem;\n}\n.bannerSection .homePageBanner {\n  position: absolute;\n  top: 33%;\n}\n.bannerSection .banner-img {\n  position: relative;\n}\n.bannerSection .banner-img img {\n  width: 100%;\n}\n.bannerSection .description {\n  font-size: 2.25rem;\n  line-height: 2.25rem;\n  margin: 0;\n  padding: 0px 8px;\n  width: 78%;\n}\n.featuredProducts {\n  padding: 54px 0px 75px;\n}\n.featuredProducts .featuredProduct-title {\n  margin-bottom: 1em;\n  color: #432919;\n  font-size: 3.125rem;\n  line-height: 5rem;\n}\n.featuredProducts .inc {\n  line-height: 36px;\n  font-size: 18px;\n  color: #1d1d1b;\n}\n.featuredProducts .featuredProduct__type {\n  font-size: 1.5rem;\n  line-height: 2.25rem;\n}\n.featuredProducts .featuredProduct__type p {\n  margin-bottom: 0;\n  color: #1d1d1b;\n}\n.featuredProducts .featuredProduct-tax p {\n  font-size: 22px;\n  line-height: 36px;\n}\n.featuredProduct-order button {\n  padding: 1px;\n  color: #ebc850;\n  outline: none;\n  background: #432919;\n  font-size: 1.75rem;\n  margin-top: 1em;\n  padding: 0px 50px;\n}\n.socialMedia .socialMedia__title {\n  margin-bottom: 0;\n  color: #432919;\n  font-size: 3.125rem;\n  line-height: 5rem;\n}\n.socialMedia .socialMedia__title__ar {\n  font-size: 2.75rem !important;\n}\n.tasteSection {\n  padding-top: 40px;\n  padding-bottom: 40px;\n}\n.tasteSection .tasteSection-description.text-white {\n  margin: 0 auto;\n  padding: 0px 6px 0px 2px;\n  margin: 0;\n  letter-spacing: 1px;\n}\n.tasteSection .tasteSection-title {\n  color: #ebc850;\n  font-size: 2.75rem;\n  line-height: 2.5rem;\n  padding-top: 45px;\n  margin: 0px 0px 30px;\n}\n.tasteSection .tasteSection-content {\n  max-width: 990px;\n  margin: 0 auto;\n}\n.featuredProduct-rating {\n  display: inline-block;\n  vertical-align: sub;\n}\n.featuredProduct-details img {\n  margin-bottom: 10px;\n}\n.price-tax {\n  padding-bottom: 25px;\n}\n.tasteSection {\n  background-image: url('home-page-taste-image.jpg');\n}\n.tasteSection .tasteSection-description p span {\n  font-size: 22px;\n  line-height: 2.5rem;\n}\n/*-- Responsive Style Start--*/\n@media (min-width: 2561px) {\n  .bannerSection .homePageBanner {\n    position: absolute;\n    top: 33%;\n  }\n\n  .tasteSection {\n    height: 400px;\n    padding: 87px 0 80px 0;\n    background-repeat: no-repeat;\n    background-position: center;\n    background-size: cover;\n  }\n\n  .tasteSection-content {\n    padding-bottom: 50px;\n  }\n}\n@media (min-width: 1601px) and (max-width: 2560px) {\n  .bannerSection .homePageBanner {\n    position: absolute;\n    left: 7%;\n    top: 26%;\n  }\n\n  p {\n    display: block;\n    width: 100%;\n  }\n\n  .bannerSection .bannerSection__title {\n    font-size: 9rem;\n    width: 80%;\n    line-height: 7.625rem;\n  }\n\n  .bannerSection .description {\n    font-size: 3rem;\n    line-height: 3.25rem;\n    margin: 0;\n    padding: 0px 8px;\n    width: 78%;\n  }\n\n  .socialMedia .row {\n    padding-left: 219px;\n    padding-right: 81px;\n  }\n}\n@media only screen and (min-width: 1367px) and (max-width: 1600px) {\n  .bannerSection .homePageBanner {\n    position: absolute;\n    left: 8%;\n    top: 21%;\n  }\n\n  .tasteSection {\n    background-repeat: no-repeat;\n    background-position: bottom;\n    background-size: cover;\n  }\n\n  .tasteSection-content {\n    padding-top: 50px;\n  }\n\n  .tasteSection {\n    padding: 87px 0 80px 0;\n  }\n}\n@media only screen and (max-width: 1366px) {\n  .bannerSection .homePageBanner {\n    position: absolute;\n    top: 21%;\n  }\n\n  .tasteSection {\n    background-repeat: no-repeat;\n    background-position: bottom;\n    background-size: cover;\n  }\n\n  .tasteSection-content {\n    padding-top: 50px;\n  }\n\n  .tasteSection {\n    padding: 87px 0 80px 0;\n  }\n}\n@media (max-width: 1280px) {\n  .bannerSection .homePageBanner {\n    position: absolute;\n    left: 7%;\n    top: 30%;\n  }\n\n  .bannerSection .bannerSection__title {\n    font-size: 5.25rem;\n    display: block;\n    line-height: 4.625rem;\n    width: 100%;\n  }\n\n  .bannerSection .description {\n    font-size: 1.75rem;\n    line-height: 1.75rem;\n    width: 70%;\n  }\n}\n@media (max-width: 991px) {\n  .bannerSection .homePageBanner {\n    position: absolute;\n    left: 5%;\n    top: 24%;\n  }\n\n  .bannerSection .bannerSection__title {\n    font-size: 2.25rem;\n    display: block;\n    line-height: 2.625rem;\n    width: 45% !important;\n  }\n\n  .bannerSection .description {\n    font-size: 1.6rem;\n    line-height: 2rem;\n    margin: 0;\n    padding: 0px 0px;\n    width: 80% !important;\n  }\n}\n@media only screen and (max-width: 767px) {\n  .bannerSection .homePageBanner {\n    position: absolute;\n    left: 7%;\n    top: 20%;\n  }\n\n  .bannerSection .bannerSection__title {\n    font-size: 3.25rem;\n    display: block;\n    line-height: 2.625rem;\n    width: 80% !important;\n    padding-top: 30px;\n  }\n\n  .bannerSection .description {\n    font-size: 1.25rem;\n    line-height: 1.75rem;\n    margin: 0;\n    padding: 0px 0px;\n  }\n\n  .bannerSection h1 span {\n    font-size: 1em;\n  }\n\n  .featuredProduct.section .col-md-3 {\n    width: 50%;\n  }\n}\n@media (max-width: 575px) {\n  .bannerSection .homePageBanner {\n    position: absolute;\n    left: 4%;\n    top: 10%;\n  }\n\n  .description {\n    font-size: 10px !important;\n    line-height: 13px !important;\n    margin: 0;\n    padding: 0px 0px;\n    width: 100% !important;\n  }\n\n  .featuredProduct-title {\n    font-size: 30px !important;\n    line-height: 30px !important;\n    text-align: center;\n  }\n\n  .featuredProducts {\n    padding: 30px 0px 40px !important;\n  }\n\n  .featuredProduct__type {\n    font-size: 15px !important;\n    line-height: 18px !important;\n    margin: 0px 0px 10px !important;\n  }\n\n  .featuredProducts .featuredProduct-tax p {\n    font-size: 18px !important;\n    line-height: 18px !important;\n  }\n\n  .featuredProducts .inc {\n    line-height: 18px !important;\n    font-size: 18px;\n    color: #1d1d1b;\n  }\n\n  .featuredProduct-rating {\n    padding-bottom: 15px;\n  }\n\n  .bannerSection p span {\n    display: inline;\n  }\n\n  .bannerSection__title {\n    font-size: 20px !important;\n    line-height: 20px !important;\n    margin-bottom: -5px;\n  }\n\n  .featuredProduct-order button {\n    font-size: 0.9em;\n    padding: 10px 50px;\n  }\n\n  .tasteSection .tasteSection-title {\n    color: #ebc850;\n    font-size: 30px;\n    line-height: 34px;\n    padding-top: 0px;\n  }\n\n  .tasteSection .tasteSection-description p span {\n    font-size: 18px;\n    line-height: 24px;\n  }\n\n  .tasteSection {\n    padding: 25px 0 15px 0;\n  }\n\n  .section {\n    padding: 0em 0;\n  }\n\n  .socialMedia .socialMedia__title {\n    margin-bottom: 0;\n    font-size: 30px;\n    line-height: 5rem;\n  }\n\n  .bannerSection__title span:last-child {\n    display: block !important;\n  }\n\n  .mb-2em {\n    margin-bottom: 20px;\n  }\n\n  .fs-1em {\n    font-size: 17px !important;\n    line-height: 26px !important;\n    font-weight: lighter !important;\n    letter-spacing: 1px;\n  }\n}\n/*-- Responsive Style End--*/\n/*customization*/\n.full-width-custom {\n  width: 1366px !important;\n}\n.homePageBannerArabic {\n  position: absolute;\n  left: 50%;\n  top: 33%;\n  padding-right: 0px;\n  right: 5%;\n}\n.homePageBannerArabic .description {\n  width: 92% !important;\n  direction: rtl;\n}\n.homePageBannerArabic .bannerSection__title__ar {\n  width: 92% !important;\n  font-size: 5.8rem;\n  direction: rtl;\n}\n@media (max-width: 575px) {\n  .bannerSection .homePageBannerArabic {\n    left: 45%;\n    top: 0%;\n  }\n\n  .homePageBannerArabic .bannerSection__title__ar {\n    font-size: 1.5rem !important;\n    line-height: 1 !important;\n  }\n\n  .homePageBannerArabic .description {\n    width: 101% !important;\n    font-size: 1.4rem !important;\n    line-height: 1.8rem !important;\n  }\n}\n@media (min-width: 576px) and (max-width: 767px) {\n  .bannerSection .homePageBannerArabic {\n    left: 45%;\n    top: 0%;\n  }\n\n  .homePageBannerArabic .bannerSection__title__ar {\n    font-size: 2.7rem !important;\n    line-height: 2.625 !important;\n  }\n\n  .homePageBannerArabic .description {\n    width: 92%;\n    font-size: 1.5rem !important;\n    line-height: 2rem !important;\n  }\n}\n@media (min-width: 768px) and (max-width: 991px) {\n  .bannerSection .homePageBannerArabic {\n    left: 45%;\n    top: 20%;\n  }\n\n  .homePageBannerArabic .bannerSection__title__ar {\n    font-size: 3.5rem !important;\n    line-height: 3rem !important;\n  }\n\n  .homePageBannerArabic .description {\n    width: 92%;\n    font-size: 1.7rem !important;\n    line-height: 2.5rem !important;\n  }\n}\n@media (min-width: 992px) and (max-width: 1200px) {\n  .bannerSection .homePageBannerArabic {\n    left: 45%;\n    top: 35% !important;\n  }\n\n  .homePageBannerArabic .bannerSection__title__ar {\n    font-size: 4rem !important;\n    line-height: 4.625rem !important;\n  }\n\n  .homePageBannerArabic .description {\n    width: 92%;\n    font-size: 2rem !important;\n    line-height: 3rem !important;\n  }\n}\n@media (min-width: 1200px) and (max-width: 1400px) {\n  .bannerSection .homePageBannerArabic {\n    left: 45%;\n    top: 35% !important;\n  }\n\n  .homePageBannerArabic .bannerSection__title__ar {\n    font-size: 5rem !important;\n    line-height: 4.625rem !important;\n  }\n\n  .homePageBannerArabic .description {\n    width: 92%;\n    font-size: 2.5rem !important;\n    line-height: 3.5rem !important;\n  }\n}\n@media (min-width: 2561px) {\n  .bannerSection .homePageBannerArabic {\n    top: 33%;\n  }\n}\n@media (min-width: 1601px) and (max-width: 2150px) {\n  .bannerSection .homePageBannerArabic {\n    top: 26%;\n  }\n\n  .homePageBannerArabic .bannerSection__title__ar {\n    font-size: 6.625rem !important;\n    width: 92% !important;\n  }\n\n  .homePageBannerArabic .description {\n    width: 92%;\n    font-size: 3rem !important;\n    line-height: 4.265rem !important;\n  }\n}\n@media (min-width: 2151px) {\n  .bannerSection .homePageBannerArabic {\n    top: 26%;\n  }\n\n  .homePageBannerArabic .bannerSection__title__ar {\n    font-size: 8.625rem !important;\n    width: 92% !important;\n  }\n\n  .homePageBannerArabic .description {\n    width: 92%;\n    font-size: 3.625rem !important;\n    line-height: 5rem !important;\n  }\n}\n@media only screen and (min-width: 1367px) and (max-width: 1600px) {\n  .bannerSection .homePageBannerArabic {\n    top: 21%;\n  }\n\n  .homePageBannerArabic .description {\n    line-height: 3.5rem !important;\n  }\n}\n@media (max-width: 1280px) {\n  .bannerSection .homePageBannerArabic .bannerSection__title__ar {\n    left: 45%;\n    top: 0%;\n    font-size: 3.5rem;\n  }\n}\n.homePageBannerArabic .bannerSection__title__ar {\n  display: block;\n  text-align: right;\n}\n.homePageBannerArabic p {\n  display: block;\n  width: 92% !important;\n}\n.homePageBannerArabic .description {\n  line-height: 2.25rem;\n  margin: 0;\n  padding: 0px 8px;\n  width: 92%;\n  text-align: right;\n}\n@media (max-width: 767px) {\n  .pa-r-0 {\n    padding-right: 5px !important;\n  }\n\n  .pa-l-0 {\n    padding-left: 5px !important;\n  }\n\n  .footer_section--address p {\n    line-height: 30px;\n    color: #fff !important;\n    text-align: center;\n  }\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"], encapsulation: 2 });


/***/ }),

/***/ "320Y":
/*!***************************************************!*\
  !*** ./src/app/shared/header/header.component.ts ***!
  \***************************************************/
/*! exports provided: HeaderComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HeaderComponent", function() { return HeaderComponent; });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _constants_common_const__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/common.const */ "Ddp4");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");
/* harmony import */ var src_app_services_translation_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/services/translation.service */ "ty2H");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var src_app_services_modal_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! src/app/services/modal.service */ "VQPA");
/* harmony import */ var src_app_services_storage_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! src/app/services/storage.service */ "n90K");
/* harmony import */ var src_app_services_cart_count_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! src/app/services/cart-count.service */ "eeuo");
/* harmony import */ var src_app_services_cms_service__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! src/app/services/cms.service */ "/Ffc");
/* harmony import */ var _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @ng-bootstrap/ng-bootstrap */ "1kSV");
/* harmony import */ var _user_login_user_login_component__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../user-login/user-login.component */ "s7gC");















function HeaderComponent_a_24_Template(rf, ctx) { if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "a", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function HeaderComponent_a_24_Template_a_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r12); const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return ctx_r11.openSignInModal(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 1, "MENU.SIGN_IN"), "");
} }
const _c0 = function () { return ["/ar/user-account"]; };
const _c1 = function () { return ["/user-account"]; };
function HeaderComponent_a_25_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "a", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx_r1.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](2, _c0) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](3, _c1));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", ctx_r1.profile == null ? null : ctx_r1.profile.user_name, "");
} }
function HeaderComponent_li_26_Template(rf, ctx) { if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "li", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "a", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function HeaderComponent_li_26_Template_a_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r14); const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return ctx_r13.changeLang("EN"); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](2, "English");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} }
function HeaderComponent_li_27_Template(rf, ctx) { if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "li", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "a", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function HeaderComponent_li_27_Template_a_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r16); const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return ctx_r15.changeLang("AR"); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](2, "\u0627\u0644\u0639\u0631\u0628\u064A\u0629");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} }
const _c2 = function (a0) { return { "badge_ar": a0 }; };
function HeaderComponent_span_31_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "span", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction1"](2, _c2, ctx_r4.lang === "AR"));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](ctx_r4.cartItemCount);
} }
function HeaderComponent_li_32_Template(rf, ctx) { if (rf & 1) {
    const _r18 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "li", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "a", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function HeaderComponent_li_32_Template_a_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r18); const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return ctx_r17.logout(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r5.lang === "AR" ? "br-1px" : "mr-0");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](3, 2, "MENU.LOGOUT"));
} }
function HeaderComponent_a_107_Template(rf, ctx) { if (rf & 1) {
    const _r20 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "a", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function HeaderComponent_a_107_Template_a_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r20); const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return ctx_r19.openSignInModal(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 1, "MENU.SIGN_IN"), "");
} }
function HeaderComponent_a_108_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "a", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx_r7.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](2, _c0) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](3, _c1));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", ctx_r7.profile == null ? null : ctx_r7.profile.user_name, "");
} }
function HeaderComponent_li_109_Template(rf, ctx) { if (rf & 1) {
    const _r22 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "a", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function HeaderComponent_li_109_Template_a_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r22); const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return ctx_r21.changeLang("EN"); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](2, "English");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} }
function HeaderComponent_li_110_Template(rf, ctx) { if (rf & 1) {
    const _r24 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "a", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function HeaderComponent_li_110_Template_a_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r24); const ctx_r23 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return ctx_r23.changeLang("AR"); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](2, "\u0627\u0644\u0639\u0631\u0628\u064A\u0629");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} }
function HeaderComponent_span_114_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "span", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction1"](2, _c2, ctx_r10.lang === "AR"));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](ctx_r10.cartItemCount);
} }
const _c3 = function () { return ["/ar/home"]; };
const _c4 = function () { return ["/home"]; };
const _c5 = function (a0, a1) { return { "br-1px": a0, "mr-0": a1 }; };
const _c6 = function () { return ["/ar/cart"]; };
const _c7 = function () { return ["/cart"]; };
const _c8 = function () { return ["/ar/about-us"]; };
const _c9 = function () { return ["/about-us"]; };
const _c10 = function () { return ["/ar/when-did-human-know-coffee"]; };
const _c11 = function () { return ["/when-did-human-know-coffee"]; };
const _c12 = function () { return ["/ar/what-are-the-benefits-and-harms"]; };
const _c13 = function () { return ["/what-are-the-benefits-and-harms"]; };
const _c14 = function () { return ["/ar/preparation"]; };
const _c15 = function () { return ["/preparation"]; };
const _c16 = function () { return ["/ar/gallery"]; };
const _c17 = function () { return ["/gallery"]; };
const _c18 = function () { return ["/ar/contact"]; };
const _c19 = function () { return ["/contact"]; };
const _c20 = function () { return ["/ar/product"]; };
const _c21 = function () { return ["/product"]; };
/**
 * HeaderComponent
 */
class HeaderComponent {
    /**
   * Constructor
   */
    constructor(translate, translationService, _document, router, formBuilder, loginModalService, storageService, cartCountService, cmsService) {
        this.translate = translate;
        this.translationService = translationService;
        this._document = _document;
        this.router = router;
        this.formBuilder = formBuilder;
        this.loginModalService = loginModalService;
        this.storageService = storageService;
        this.cartCountService = cartCountService;
        this.cmsService = cmsService;
        this.collapsed = true;
        this.submitted = false;
        this.closeResult = '';
        this.profile = {};
        this.cartItemCount = 0;
        this.content = {};
        translate.addLangs([_constants_common_const__WEBPACK_IMPORTED_MODULE_2__["EN"], _constants_common_const__WEBPACK_IMPORTED_MODULE_2__["AR"]]);
    }
    /**
     * page initialization
     */
    ngOnInit() {
        this.getPageContent();
        this.profile = JSON.parse(this.storageService.getItem('profile'));
        this.cartItemCount = this.storageService.getItem('cart') !== null ? JSON.parse(this.storageService.getItem('cart')).length : 0;
        this.cartCountService.updateCartCount({
            count: this.cartItemCount,
        });
        // Listening to cart count
        this.cartCountService.cartIncrementObserve.subscribe((data) => {
            this.cartItemCount = data.count;
        });
        const url = this.router.routerState.snapshot.url;
        console.log(url.split('/')[1]);
        if (url.split('/')[1] === 'ar') {
            this.changeLang(_constants_common_const__WEBPACK_IMPORTED_MODULE_2__["AR"]);
        }
        else {
            this.changeLang(_constants_common_const__WEBPACK_IMPORTED_MODULE_2__["EN"]);
        }
        this.loginform = this.formBuilder.group({
            phone: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required],
            password: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required],
            device_token: ['sp-eatzilla-web'],
            login_type: ['0'],
            device_type: ['web'],
        });
    }
    get f() {
        return this.loginform.controls;
    }
    /**
     * Add the translation
     * @param {string} lang Used for translation.
     */
    changeLang(lang) {
        this.setUrl(lang);
        sessionStorage.setItem('language', lang);
        this.lang = sessionStorage.getItem('language');
        this.translate.use(lang);
        this.translationService.languageChangeTrigger(true);
        this.changeCssFile(lang);
    }
    /**
     * Change Url based on language
     * @param {string} lang
     */
    setUrl(lang) {
        const url = this.router.routerState.snapshot.url;
        if (lang === 'AR' && url.split('/')[1] !== 'ar') {
            this.router.navigate([`/ar${url}`]);
        }
        if (lang === 'EN' && url.split('/')[1] === 'ar') {
            const newurl = url.split('/')[2] ? this.router.url.replace('ar/', '') : this.router.url.replace('ar', '');
            this.router.navigate([`${newurl}`]);
        }
    }
    /**
   * change the css file for right aligned
   * @param {string} lang Used for translation.
   */
    changeCssFile(lang) {
        this.lang = sessionStorage.getItem('language');
        const headTag = this._document.getElementsByTagName('head')[0];
        const existingLink = this._document.getElementById('langCss');
        const bundleName = lang === _constants_common_const__WEBPACK_IMPORTED_MODULE_2__["AR"] ? 'css-ar.css' : 'css-en.css';
        if (existingLink) {
            existingLink.href = bundleName;
        }
        else {
            const newLink = this._document.createElement('link');
            newLink.rel = 'stylesheet';
            newLink.id = 'langCss';
            newLink.href = bundleName;
            newLink.type = 'text/css';
            newLink.media = 'all';
            headTag.appendChild(newLink);
        }
    }
    /**
     * Open sign in modal
     */
    openSignInModal() {
        this.loginModalService.setLoginModalStatus({
            isLoginModalOpen: true,
        });
    }
    /**
     * Logout
     */
    logout() {
        const url = this.router.routerState.snapshot.url;
        this.storageService.clearItem();
        if (url === '/' || url === '/ar' || url === '/home' || url === '/ar/home') {
            window.location.reload();
        }
        else
            this.lang === 'AR' ? this.router.navigate(['/ar']) : this.router.navigate(['/']);
    }
    /**
     * get page content
     */
    getPageContent() {
        this.cmsService.getPageContent('get_cms_common_content').subscribe((response) => {
            if (response['status']) {
                this.content = response['data'];
            }
        });
    }
}
HeaderComponent.ɵfac = function HeaderComponent_Factory(t) { return new (t || HeaderComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_ngx_translate_core__WEBPACK_IMPORTED_MODULE_4__["TranslateService"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](src_app_services_translation_service__WEBPACK_IMPORTED_MODULE_5__["TranslationService"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_0__["DOCUMENT"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_6__["Router"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormBuilder"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](src_app_services_modal_service__WEBPACK_IMPORTED_MODULE_7__["ModalService"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](src_app_services_storage_service__WEBPACK_IMPORTED_MODULE_8__["StorageService"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](src_app_services_cart_count_service__WEBPACK_IMPORTED_MODULE_9__["CartCountService"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](src_app_services_cms_service__WEBPACK_IMPORTED_MODULE_10__["CmsService"])); };
HeaderComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({ type: HeaderComponent, selectors: [["app-header"]], inputs: { setActive: "setActive" }, decls: 116, vars: 118, consts: [[1, "notificationsBar", "text-center", 3, "ngClass"], [1, "container-fluid"], [1, "text-white"], [1, "container-fluid", "navBar"], [1, "row", "header-row"], [1, "col-md-3", "col-sm-12", "col-xs-12"], [1, "navbar-brand", 3, "routerLink"], [1, "ar_version"], ["src", "assets/images/icons/logo.png", "alt", "logo", 3, "ngClass"], [1, "col-md-9"], [1, "headerWebView"], [1, "socialMediaLinks", 3, "ngClass"], [1, "m-0"], ["target", "_blank", 3, "href"], ["src", "assets/images/icons/fb.png", "alt", "faceBoook"], [3, "ngClass"], ["src", "assets/images/icons/insta.png", "alt", "instaGram"], [1, "br-1px"], [3, "click", 4, "ngIf"], [3, "routerLink", 4, "ngIf"], ["class", "br-1px", 4, "ngIf"], [3, "routerLink"], ["src", "assets/images/icons/cart.png", "alt", "cart"], ["class", "badge", 3, "ngClass", 4, "ngIf"], [3, "ngClass", 4, "ngIf"], [1, "navbar", "navbar-expand-md"], [1, "collapse", "navbar-collapse"], [1, "navbar-nav", 3, "ngClass"], [1, "nav-link", 3, "routerLink"], ["ngbDropdown", "", "display", "dynamic", "placement", "bottom-left", 3, "ngClass"], ["tabindex", "0", "ngbDropdownToggle", "", "id", "navbarDropdown3", "role", "button", 1, "nav-link"], ["ngbDropdownMenu", "", "aria-labelledby", "navbarDropdown3", 1, "dropdown-menu", "submenu", 3, "ngClass"], ["ngbDropdownItem", "", 3, "routerLink"], [1, "headerMobileView", 3, "ngClass"], ["type", "checkbox", "id", "toggle", 2, "display", "none"], ["for", "toggle", 1, "toggle-btn", "toggle-btn__cross", 3, "ngClass"], [1, "bar"], [1, "mobileViewMenu", 3, "ngClass"], [1, "ml-1em"], [1, "fs-1em", 3, "routerLink"], [1, "separator"], [4, "ngIf"], ["src", "assets/images/icons/cart_menu.png "], [3, "click"], [1, "arbicFont", 3, "click"], [1, "badge", 3, "ngClass"]], template: function HeaderComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "header");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](2, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](4, "span", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](6, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](7, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](8, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](9, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](10, "a", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](11, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](12, "img", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](13, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](14, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](15, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](16, "ul", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](17, "li", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](18, "a", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](19, "img", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](20, "li", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](21, "a", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](22, "img", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](23, "li", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](24, HeaderComponent_a_24_Template, 3, 3, "a", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](25, HeaderComponent_a_25_Template, 2, 4, "a", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](26, HeaderComponent_li_26_Template, 3, 0, "li", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](27, HeaderComponent_li_27_Template, 3, 0, "li", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](28, "li", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](29, "a", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](30, "img", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](31, HeaderComponent_span_31_Template, 2, 4, "span", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](32, HeaderComponent_li_32_Template, 4, 4, "li", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](33, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](34, "nav", 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](35, "div", 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](36, "ul", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](37, "li", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](38, "a", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](39);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](40, "li", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](41, "a", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](42);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](43, "li", 29);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](44, "a", 30);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](45);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](46, "div", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](47, "a", 32);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](48);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](49, "a", 32);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](50);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](51, "li", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](52, "a", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](53);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](54, "li", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](55, "a", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](56);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](57, "li", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](58, "a", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](59);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](60, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](61, "li", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](62, "a", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](63);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](64, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](65, "div", 33);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](66, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](67, "header");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](68, "input", 34);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](69, "label", 35);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](70, "div", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](71, "div", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](72, "div", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](73, "nav");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](74, "div", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](75, "ul", 37);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](76, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](77, "a", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](78);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](79, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](80, "a", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](81);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](82, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](83, "a");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](84);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](85, "li", 38);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](86, "a", 39);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](87);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](88, "li", 38);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](89, "a", 39);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](90);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](91, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](92, "a", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](93);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](94, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](95, "a", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](96);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](97, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](98, "a", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](99);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](100, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](101, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](102, "a", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](103);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](104, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](105, "hr", 40);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](106, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](107, HeaderComponent_a_107_Template, 3, 3, "a", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](108, HeaderComponent_a_108_Template, 2, 4, "a", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](109, HeaderComponent_li_109_Template, 3, 0, "li", 41);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](110, HeaderComponent_li_110_Template, 3, 0, "li", 41);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](111, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](112, "a", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](113, "img", 42);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](114, HeaderComponent_span_114_Template, 2, 4, "span", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](115, "app-user-login");
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-RomanB");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](ctx.lang === "AR" ? ctx.content.ar_cms_notification_content : ctx.content.cms_notification_content);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](77, _c3) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](78, _c4));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.lang === "EN" ? "img-fluid" : "img-fluid-ar");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist521BT-Roman");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("href", ctx.content.facebook_link, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵsanitizeUrl"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "m-0" : "br-1px");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("href", ctx.content.instagram_link, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵsanitizeUrl"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", !ctx.profile || !(ctx.profile == null ? null : ctx.profile.authId));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.profile == null ? null : ctx.profile.authId);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.lang === "AR");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.lang === "EN");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction2"](79, _c5, (ctx.profile == null ? null : ctx.profile.authId) || ctx.lang === "AR", ctx.lang !== "AR" && !(ctx.profile == null ? null : ctx.profile.authId)));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](82, _c6) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](83, _c7));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.profile || (ctx.profile == null ? null : ctx.profile.authId));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.profile == null ? null : ctx.profile.authId);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "navBar__ar" : "navBar__en");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.setActive == "home" ? "nav-item active" : "nav-item");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](84, _c3) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](85, _c4));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", ctx.lang === "AR" ? ctx.content.menu1_name_ar : ctx.content.menu1_name, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.setActive == "about" ? "nav-item active" : "nav-item");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](86, _c8) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](87, _c9));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", ctx.lang === "AR" ? ctx.content.menu2_name_ar : ctx.content.menu2_name, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.setActive == "learn" ? "nav-item active" : "nav-item");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", ctx.lang === "AR" ? ctx.content.menu3_name_ar : ctx.content.menu3_name, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "navBar__ar" : "navBar__en");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](88, _c10) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](89, _c11));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" - ", ctx.lang === "AR" ? ctx.content.learn_content_menu1_name_ar : ctx.content.learn_content_menu1_name, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](90, _c12) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](91, _c13));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" - ", ctx.lang === "AR" ? ctx.content.learn_content_menu2_name_ar : ctx.content.learn_content_menu2_name, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.setActive == "preparation" ? "nav-item active" : "nav-item");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](92, _c14) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](93, _c15));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", ctx.lang === "AR" ? ctx.content.menu4_name_ar : ctx.content.menu4_name, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.setActive == "gallery" ? "nav-item active" : "nav-item");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](94, _c16) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](95, _c17));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", ctx.lang === "AR" ? ctx.content.menu5_name_ar : ctx.content.menu5_name, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.setActive == "contact" ? "nav-item active" : "nav-item");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](96, _c18) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](97, _c19));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](60, 69, "MENU.CONTACT"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.setActive == "shop" ? "nav-item active" : "nav-item shop");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](98, _c20) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](99, _c21));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](64, 71, "MENU.SHOP"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.lang === "EN" ? "toggle-btn" : "toggle-btn-ar");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.lang === "EN" ? "toggle-btn" : "toggle-btn-ar");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.lang === "EN" ? "mobileViewMenu" : "mobileViewMenu_ar");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist521BT-Roman");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](100, _c3) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](101, _c4));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](ctx.lang === "AR" ? ctx.content.menu1_name_ar : ctx.content.menu1_name);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](102, _c8) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](103, _c9));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](ctx.lang === "AR" ? ctx.content.menu2_name_ar : ctx.content.menu2_name);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](ctx.lang === "AR" ? ctx.content.menu3_name_ar : ctx.content.menu3_name);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](104, _c10) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](105, _c11));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" - ", ctx.lang === "AR" ? ctx.content.learn_content_menu1_name_ar : ctx.content.learn_content_menu1_name, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](106, _c12) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](107, _c13));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" - ", ctx.lang === "AR" ? ctx.content.learn_content_menu2_name_ar : ctx.content.learn_content_menu2_name, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](108, _c14) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](109, _c15));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](ctx.lang === "AR" ? ctx.content.menu4_name_ar : ctx.content.menu4_name);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](110, _c16) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](111, _c17));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](ctx.lang === "AR" ? ctx.content.menu5_name_ar : ctx.content.menu5_name);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](112, _c18) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](113, _c19));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](100, 73, "MENU.CONTACT"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](114, _c20) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](115, _c21));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](104, 75, "MENU.SHOP"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", !ctx.profile || !(ctx.profile == null ? null : ctx.profile.authId));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.profile == null ? null : ctx.profile.authId);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.lang === "AR");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.lang === "EN");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](116, _c6) : _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](117, _c7));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.profile || (ctx.profile == null ? null : ctx.profile.authId));
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_0__["NgClass"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_11__["NgbNavbar"], _angular_router__WEBPACK_IMPORTED_MODULE_6__["RouterLinkWithHref"], _angular_common__WEBPACK_IMPORTED_MODULE_0__["NgIf"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_11__["NgbDropdown"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_11__["NgbDropdownToggle"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_11__["NgbDropdownMenu"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_11__["NgbDropdownItem"], _user_login_user_login_component__WEBPACK_IMPORTED_MODULE_12__["UserLoginComponent"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_4__["TranslatePipe"]], styles: ["@font-face {\n  font-family: \"HomepageBaukasten-Book\";\n  src: local(\"HomepageBaukasten-Book\"), url('HomepageBaukasten-Book.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist521BT-Roman\";\n  src: local(\"Humanist521BT-Roman\"), url('Humanist521BT-Roman.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanB\";\n  src: local(\"Humanist777BT-RomanB\"), url('Humanist777BT-RomanB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n  src: local(\"Humanist777BT-BoldCondensedB\"), url('Humanist777BT-BoldCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n  src: local(\"Humanist777BT-RomanCondensedB\"), url('Humanist777BT-RomanCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n  src: local(\"Humanist777BT-BlackCondensedB\"), url('Humanist777BT-BlackCondensed.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist777LightBT\";\n  src: local(\"Humanist777LightBT\"), url('Humanist777LightBT.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"HelveticaNeue-Regular\";\n  src: local(\"HelveticaNeue-Regular\"), url('HelveticaNeue-Regular.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Black\";\n  src: local(\"Tajawal-Black\"), url('Tajawal-Black.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Bold\";\n  src: local(\"Tajawal-Bold\"), url('Tajawal-Bold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraBold\";\n  src: local(\"Tajawal-ExtraBold\"), url('Tajawal-ExtraBold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraLight\";\n  src: local(\"Tajawal-ExtraLight\"), url('Tajawal-ExtraLight.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Light\";\n  src: local(\"Tajawal-Light\"), url('Tajawal-Light.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Medium\";\n  src: local(\"Tajawal-Medium\"), url('Tajawal-Medium.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Regular\";\n  src: local(\"Tajawal-Regular\"), url('Tajawal-Regular.ttf') format(\"truetype\");\n}\n.font-HomepageBaukasten-Book[_ngcontent-%COMP%] {\n  font-family: \"HomepageBaukasten-Book\";\n}\n.font-Humanist521BT-Roman[_ngcontent-%COMP%] {\n  font-family: \"Humanist521BT-Roman\";\n}\n.font-Humanist777BT-RomanB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanB\";\n}\n.font-Humanist777BT-BoldCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n}\n.font-Humanist777BT-RomanCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n}\n.font-Humanist777BT-BlackCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n}\n.font-Humanist777LightBT[_ngcontent-%COMP%] {\n  font-family: \"Humanist777LightBT\" !important;\n}\n.font-HelveticaNeue-Regular[_ngcontent-%COMP%] {\n  font-family: \"HelveticaNeue-Regular\";\n}\n.font-Tajawal-Black[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Black\";\n}\n.font-Tajawal-Bold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Bold\";\n}\n.font-Tajawal-ExtraBold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraBold\";\n}\n.font-Tajawal-ExtraLight[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraLight\";\n}\n.font-Tajawal-Light[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Light\";\n}\n.font-Tajawal-Medium[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Medium\";\n}\n.font-Tajawal-Regular[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Regular\";\n}\na[_ngcontent-%COMP%]:hover {\n  color: initial;\n  text-decoration: none;\n}\n.border-color[_ngcontent-%COMP%] {\n  border-color: #dedede !important;\n}\n.container-fluid[_ngcontent-%COMP%] {\n  width: 100%;\n  padding-right: 25px;\n  padding-left: 25px;\n  margin-right: auto;\n  margin-left: auto;\n}\n.full-width[_ngcontent-%COMP%], .aboutUsPage[_ngcontent-%COMP%], .humanKnowCoffee[_ngcontent-%COMP%], .benefitsAndHarms[_ngcontent-%COMP%], .preparationPage[_ngcontent-%COMP%], .galleryPage[_ngcontent-%COMP%], .productPage[_ngcontent-%COMP%] {\n  max-width: 100%;\n  margin: 0 auto;\n}\na[_ngcontent-%COMP%] {\n  color: initial;\n  text-decoration: none;\n  background-color: transparent;\n}\n.br-1px[_ngcontent-%COMP%] {\n  border-right: 1px solid;\n}\n.ngx-gallery-icon[_ngcontent-%COMP%] {\n  color: red;\n  background: blue;\n}\ngallery-item[_ngcontent-%COMP%] {\n  padding: 2em;\n  border: 2px solid #ebc850 !important;\n}\n.ml-1em[_ngcontent-%COMP%] {\n  margin-left: 1em;\n}\n.border[_ngcontent-%COMP%] {\n  border: 1px solid;\n}\n.roundedCorner[_ngcontent-%COMP%] {\n  border-radius: 30px;\n}\n.mt-1em[_ngcontent-%COMP%] {\n  margin-top: 1em;\n}\n.mt-2em[_ngcontent-%COMP%] {\n  margin-top: 2em;\n}\n.pr-0[_ngcontent-%COMP%] {\n  padding-right: 0;\n}\n.pl-0[_ngcontent-%COMP%] {\n  padding-left: 0;\n}\n.section[_ngcontent-%COMP%] {\n  padding: 2em 0;\n}\n.d-flex[_ngcontent-%COMP%] {\n  display: flex;\n}\n.justify-center[_ngcontent-%COMP%] {\n  justify-content: center;\n}\n.align-center[_ngcontent-%COMP%] {\n  align-items: center;\n}\ngallery-thumbs[_ngcontent-%COMP%] {\n  display: none !important;\n}\n.select-gender[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\n.select-gender[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  text-indent: 15px;\n  text-overflow: \"\";\n  width: 90%;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  padding: 2px 2px 2px 2px;\n  border: none;\n  background: transparent url(\"http://cdn1.iconfinder.com/data/icons/cc_mono_icon_set/blacks/16x16/br_down.png\") no-repeat 230px !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%] {\n  display: flex !important;\n  align-items: center !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%]   .modal-dialog[_ngcontent-%COMP%] {\n  flex-grow: 1;\n}\n.our-branch-address[_ngcontent-%COMP%]   .accordion[_ngcontent-%COMP%]    > .card[_ngcontent-%COMP%]    > .card-header[_ngcontent-%COMP%] {\n  padding: 0;\n  background-color: #ebc850 !important;\n}\n.our-branch-address[_ngcontent-%COMP%]   .panelTitle[_ngcontent-%COMP%] {\n  font-size: 1.25rem;\n  line-height: 1.25rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%] {\n  font-weight: 500;\n  color: #1d1d1b;\n  font-size: 1.5rem;\n  line-height: 2.5rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%]:focus {\n  box-shadow: none !important;\n  text-decoration: none;\n}\n.g-btn-close[_ngcontent-%COMP%] {\n  display: none;\n}\npath[_ngcontent-%COMP%] {\n  fill: #bc8033;\n}\n@media (min-width: 767px) {\n  .navbar-expand-md[_ngcontent-%COMP%]   .navbar-nav[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n    padding-right: 0.3rem !important;\n    padding-left: 0.3rem !important;\n    font-size: 16px !important;\n  }\n}\n@media (max-width: 2560px) {\n  .webView[_ngcontent-%COMP%] {\n    background-size: cover !important;\n  }\n}\n.direction_ltr[_ngcontent-%COMP%] {\n  direction: ltr !important;\n}\n.iti[_ngcontent-%COMP%] {\n  width: 100%;\n}\nbutton.close[_ngcontent-%COMP%] {\n  padding: 0.5em !important;\n  border: none !important;\n}\n.btn_primary[_ngcontent-%COMP%] {\n  background: #432919;\n  color: #ebc850;\n}\ninput[_ngcontent-%COMP%]::-webkit-outer-spin-button, input[_ngcontent-%COMP%]::-webkit-inner-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n\ninput[type=number][_ngcontent-%COMP%] {\n  -moz-appearance: textfield;\n}\n.text-primary[_ngcontent-%COMP%] {\n  color: #ebc850 !important;\n}\n.min-height-10[_ngcontent-%COMP%] {\n  min-height: 10em;\n}\n.pac-container[_ngcontent-%COMP%] {\n  background-color: #fff;\n  position: absolute !important;\n  z-index: 9999999999;\n  border-radius: 2px;\n  border-top: 0;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);\n  box-sizing: border-box;\n  overflow: hidden;\n  font-size: 16px;\n  color: #ebc850;\n}\n.pac-logo[_ngcontent-%COMP%]:after {\n  content: \"\";\n  padding: 1px 1px 1px 0;\n  height: 16px;\n  text-align: right;\n  display: block;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3.png);\n  background-position: right;\n  background-repeat: no-repeat;\n  background-size: 120px 14px;\n}\n.hdpi.pac-logo[_ngcontent-%COMP%]:after {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3_hdpi.png);\n}\n.pac-item[_ngcontent-%COMP%] {\n  cursor: default;\n  padding: 4px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n  line-height: 30px;\n  text-align: left;\n  border-top: 0;\n  font-size: 13px;\n  color: #999;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n}\n.pac-item[_ngcontent-%COMP%]:hover {\n  background-color: #fafafa;\n}\n.pac-item-selected[_ngcontent-%COMP%], .pac-item-selected[_ngcontent-%COMP%]:hover {\n  background-color: #ebf2fe;\n}\n.pac-matched[_ngcontent-%COMP%] {\n  font-weight: 700;\n}\n.pac-item-query[_ngcontent-%COMP%] {\n  font-size: 16px;\n  padding-right: 3px;\n  color: #ebc850;\n}\n.pac-icon[_ngcontent-%COMP%] {\n  width: 15px;\n  height: 20px;\n  margin-right: 7px;\n  margin-top: 6px;\n  display: inline-block;\n  vertical-align: top;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons.png);\n  background-size: 34px;\n}\n.hdpi[_ngcontent-%COMP%]   .pac-icon[_ngcontent-%COMP%] {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons_hdpi.png);\n}\n.pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -1px -1px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -18px -1px;\n}\n.pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -1px -161px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -18px -161px;\n}\n.pac-placeholder[_ngcontent-%COMP%] {\n  color: gray;\n}\n.form-control[_ngcontent-%COMP%]:focus {\n  box-shadow: 0 0 0 0.05rem #9f9f9f;\n}\n.page-link[_ngcontent-%COMP%] {\n  border-color: #432919 !important;\n  color: #432919 !important;\n}\n.page-item.active[_ngcontent-%COMP%]   .page-link[_ngcontent-%COMP%] {\n  background-color: #432919 !important;\n  border-color: #432919 !important;\n  color: #ebc850 !important;\n}\n.b-0[_ngcontent-%COMP%] {\n  bottom: 0px;\n}\n.loader_section[_ngcontent-%COMP%] {\n  display: flex;\n  height: 100vh;\n  align-items: center;\n}\n.loader[_ngcontent-%COMP%], .loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  background: #ebc850;\n  -webkit-animation: load1 1s infinite ease-in-out;\n  animation: load1 1s infinite ease-in-out;\n  width: 1em;\n  height: 4em;\n}\n.loader[_ngcontent-%COMP%] {\n  color: #ebc850;\n  text-indent: -9999em;\n  margin: 88px auto;\n  position: relative;\n  font-size: 11px;\n  transform: translateZ(0);\n  -webkit-animation-delay: -0.16s;\n  animation-delay: -0.16s;\n}\n.loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  position: absolute;\n  top: 0;\n  content: \"\";\n}\n.loader[_ngcontent-%COMP%]:before {\n  left: -1.5em;\n  -webkit-animation-delay: -0.32s;\n  animation-delay: -0.32s;\n}\n.loader[_ngcontent-%COMP%]:after {\n  left: 1.5em;\n}\n@-webkit-keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n@keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n.notificationsBar[_ngcontent-%COMP%] {\n  padding: 1.5em;\n  background: #1d1d1b;\n}\n.header[_ngcontent-%COMP%] {\n  height: 200px !important;\n}\n.fs-1em[_ngcontent-%COMP%] {\n  font-size: 17px !important;\n  line-height: 30px !important;\n  font-weight: lighter !important;\n  letter-spacing: 0.7px;\n}\n.headerMobileView[_ngcontent-%COMP%] {\n  display: none;\n}\n.navbar-nav[_ngcontent-%COMP%] {\n  margin-left: auto;\n}\nhr.separator[_ngcontent-%COMP%] {\n  border: 0;\n  width: 70%;\n  margin: 1em 0px 1em 0px;\n  border-top: 1px solid #fff;\n  text-align: left;\n}\n.arbicFont[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Regular\";\n}\n.navbar[_ngcontent-%COMP%] {\n  padding: 0rem;\n}\n.navbar[_ngcontent-%COMP%]   a#navbarDropdown3[_ngcontent-%COMP%]:focus {\n  outline: none;\n}\n.navbar[_ngcontent-%COMP%]   .nav-item[_ngcontent-%COMP%]:hover {\n  background: #ebc850;\n}\n.navbar[_ngcontent-%COMP%]   .nav-item.shop[_ngcontent-%COMP%] {\n  outline: 2px solid #d30404;\n  outline-offset: -8px;\n  padding: 2px 14px;\n  margin-bottom: 10px;\n}\n.dropdown-menu.show[_ngcontent-%COMP%] {\n  background: #ebc850;\n  opacity: 0.8;\n  background: #ebc850;\n  margin-top: 14px;\n  border-radius: 0;\n}\n.dropdown-menu.show[_ngcontent-%COMP%]   a.dropdown-item[_ngcontent-%COMP%]:before {\n  padding-right: 0.625em;\n  width: 20em;\n  width: -webkit-fit-content;\n  width: -moz-fit-content;\n  width: fit-content;\n}\n.dropdown-menu.show[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:first-child {\n  border-bottom: 0.1em solid #ffffff;\n}\n.dropdown-menu.show[_ngcontent-%COMP%]   .dropdown-item[_ngcontent-%COMP%] {\n  display: block;\n  width: -webkit-fit-content;\n  width: -moz-fit-content;\n  width: fit-content;\n  clear: both;\n  font-weight: 200;\n  font-size: medium;\n  color: #212529;\n  text-align: inherit;\n  white-space: nowrap;\n  background-color: transparent;\n  border: 0;\n  padding: 0.3em;\n}\n.mobileViewMenu[_ngcontent-%COMP%] {\n  transform: scaleX(1);\n}\n.mobileViewMenu_ar[_ngcontent-%COMP%] {\n  font-weight: 100;\n  padding-right: 20%;\n  direction: rtl;\n  align-content: flex-end;\n  transform: scaleX(1);\n  text-align: right;\n}\n.navBar[_ngcontent-%COMP%]   .navBar__en[_ngcontent-%COMP%] {\n  font-family: \"HomepageBaukasten-Book\";\n  font-size: 1.375rem;\n  line-height: 1.625rem;\n}\n.navBar[_ngcontent-%COMP%]   .navBar__ar[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Regular\";\n  font-size: 1.3rem;\n  line-height: 2rem;\n}\n.navBar[_ngcontent-%COMP%]   .nav-item.active[_ngcontent-%COMP%] {\n  background: #ebc850;\n}\n.navBar[_ngcontent-%COMP%]   .nav-item[_ngcontent-%COMP%] {\n  margin-right: 0.5em;\n}\n.navBar[_ngcontent-%COMP%]   .nav-item[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #1d1d1b;\n  padding-left: 7px;\n  padding-right: 0px;\n  margin: auto;\n  vertical-align: middle;\n}\n.navBar[_ngcontent-%COMP%]   .navbar-expand-sm[_ngcontent-%COMP%]   .navbar-nav[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n  padding-right: 0.9rem;\n  padding-left: 0.9rem;\n}\nul.socialMediaLinks[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: flex-end;\n  margin-top: 1.5em;\n}\nul.socialMediaLinks[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  list-style-type: none;\n  padding-right: 1em;\n  margin-right: 1em;\n  font-size: 1.25rem;\n  line-height: 1.313rem;\n}\nul.socialMediaLinks[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\nul.socialMediaLinks[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   .badge[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0.7em;\n  right: 9em;\n  background-color: #ebc850 !important;\n  border-radius: 100% !important;\n  padding: 0.2em 0.4em !important;\n  font-size: 65% !important;\n}\nul.socialMediaLinks[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   .badge_ar[_ngcontent-%COMP%] {\n  left: 14em !important;\n  right: unset;\n}\n.headerMobileView[_ngcontent-%COMP%]   header[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%] {\n  background-color: #1d1d1b;\n  position: fixed;\n  z-index: 999;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  opacity: 0;\n  visibility: hidden;\n  transition: all 0.3s ease-in-out;\n}\n.headerMobileView[_ngcontent-%COMP%]   header[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\n  display: inline;\n  list-style-type: none;\n  \n  \n  position: relative;\n  left: 11%;\n  top: 10.625em;\n  transition: all 0.3s ease-in-out;\n  transform: translateX(-50%);\n  \n}\n.headerMobileView[_ngcontent-%COMP%]   header[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  transform: translateY(50px);\n  opacity: 0;\n}\n.headerMobileView[_ngcontent-%COMP%]   header[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.2em;\n  text-decoration: none;\n  line-height: 2em;\n  color: #fff;\n  transition: all 0.2s ease-in-out;\n  text-shadow: 0.063em 0.063em 0.125em rgba(0, 0, 0, 0.5);\n}\n.headerMobileView[_ngcontent-%COMP%]   header[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  color: #ebc850;\n}\n.headerMobileView[_ngcontent-%COMP%]   .toggle-btn[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  z-index: 9999;\n  right: 0.1em;\n  top: -3em;\n  cursor: pointer;\n}\n.headerMobileView[_ngcontent-%COMP%]   .toggle-btn[_ngcontent-%COMP%]   .bar[_ngcontent-%COMP%] {\n  width: 40px;\n  height: 4px;\n  margin: 0 0 4px auto;\n  background: #9f9f9f;\n  transition: all 0.3s ease-in-out;\n  \n}\n.headerMobileView[_ngcontent-%COMP%]   .toggle-btn[_ngcontent-%COMP%]   .bar[_ngcontent-%COMP%]:nth-child(2) {\n  width: 40px;\n}\n.headerMobileView[_ngcontent-%COMP%]   .toggle-btn[_ngcontent-%COMP%]   .bar[_ngcontent-%COMP%]:nth-child(3) {\n  width: 25px;\n}\n.headerMobileView[_ngcontent-%COMP%]   .toggle-btn-ar[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  z-index: 9999;\n  right: 0.1em;\n  top: -3em;\n  cursor: pointer;\n  margin-right: 85%;\n  \n  transform: scaleX(-1);\n}\n.headerMobileView[_ngcontent-%COMP%]   .toggle-btn-ar[_ngcontent-%COMP%]   .bar[_ngcontent-%COMP%] {\n  width: 40px;\n  height: 4px;\n  margin: 0 0 4px auto;\n  background: #9f9f9f;\n  transition: all 0.3s ease-in-out;\n  \n}\n.headerMobileView[_ngcontent-%COMP%]   .toggle-btn-ar[_ngcontent-%COMP%]   .bar[_ngcontent-%COMP%]:nth-child(2) {\n  width: 40px;\n}\n.headerMobileView[_ngcontent-%COMP%]   .toggle-btn-ar[_ngcontent-%COMP%]   .bar[_ngcontent-%COMP%]:nth-child(3) {\n  width: 25px;\n}\n.headerMobileView[_ngcontent-%COMP%]   #toggle[_ngcontent-%COMP%]:checked    ~ nav[_ngcontent-%COMP%] {\n  opacity: 1;\n  visibility: visible;\n}\n.headerMobileView[_ngcontent-%COMP%]   #toggle[_ngcontent-%COMP%]:checked    ~ nav[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\n  top: 1.5em;\n}\n.headerMobileView[_ngcontent-%COMP%]   #toggle[_ngcontent-%COMP%]:checked    ~ nav[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  transform: translateY(0px);\n  opacity: 1;\n}\n.headerMobileView[_ngcontent-%COMP%]   #toggle[_ngcontent-%COMP%]:checked    ~ nav[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:nth-child(1) {\n  transition: all 0.3s cubic-bezier(0.6, 0, 0.8, 1.5) 0.1s;\n}\n.headerMobileView[_ngcontent-%COMP%]   #toggle[_ngcontent-%COMP%]:checked    ~ nav[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:nth-child(2) {\n  transition: all 0.3s cubic-bezier(0.6, 0, 0.8, 1.5) 0.2s;\n}\n.headerMobileView[_ngcontent-%COMP%]   #toggle[_ngcontent-%COMP%]:checked    ~ nav[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:nth-child(3) {\n  transition: all 0.3s cubic-bezier(0.6, 0, 0.8, 1.5) 0.3s;\n}\n.headerMobileView[_ngcontent-%COMP%]   #toggle[_ngcontent-%COMP%]:checked    ~ nav[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:nth-child(4) {\n  transition: all 0.3s cubic-bezier(0.6, 0, 0.8, 1.5) 0.4s;\n}\n.headerMobileView[_ngcontent-%COMP%]   #toggle[_ngcontent-%COMP%]:checked    + label.toggle-btn[_ngcontent-%COMP%]   .bar[_ngcontent-%COMP%] {\n  background-color: #9f9f9f;\n}\n.headerMobileView[_ngcontent-%COMP%]   #toggle[_ngcontent-%COMP%]:checked    + label.toggle-btn[_ngcontent-%COMP%]   .bar[_ngcontent-%COMP%]:nth-child(2) {\n  transform: translateX(50px);\n  opacity: 0;\n}\n.headerMobileView[_ngcontent-%COMP%]   #toggle[_ngcontent-%COMP%]:checked    + label.toggle-btn[_ngcontent-%COMP%]   .bar[_ngcontent-%COMP%]:nth-child(1) {\n  transform: translateY(10px) rotate(45deg);\n}\n.headerMobileView[_ngcontent-%COMP%]   #toggle[_ngcontent-%COMP%]:checked    + label.toggle-btn[_ngcontent-%COMP%]   .bar[_ngcontent-%COMP%]:nth-child(3) {\n  width: 40px;\n  transform: translateY(-6px) rotate(-45deg);\n}\n.headerMobileView[_ngcontent-%COMP%]   .badge[_ngcontent-%COMP%] {\n  position: absolute;\n  background-color: #ebc850 !important;\n  border-radius: 100% !important;\n  padding: 0.2em 0.4em !important;\n  font-size: 65% !important;\n}\n.headerMobileView[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\nlabel.col-form-label[_ngcontent-%COMP%] {\n  font-size: 26px;\n  line-height: 36px;\n  color: #1d1d1b;\n  font-family: Humanist777BT-RomanCondensedB;\n}\na.registeration[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n.navbar-brand[_ngcontent-%COMP%] {\n  width: 100% !important;\n  height: auto;\n}\n\n@media only screen and (max-width: 767px) {\n  .headerMobileView[_ngcontent-%COMP%] {\n    display: block;\n  }\n\n  .headerWebView[_ngcontent-%COMP%] {\n    display: none;\n  }\n\n  .headerMobileView[_ngcontent-%COMP%]   header[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n    font-size: 30px;\n    line-height: 50px;\n    font-weight: 100;\n  }\n\n  .img-fluid[_ngcontent-%COMP%] {\n    width: 100px;\n    height: 65px;\n  }\n\n  .img-fluid-ar[_ngcontent-%COMP%] {\n    width: 100px;\n    height: 65px;\n    float: right;\n  }\n}\n@media only screen and (min-width: 768px) {\n  .navbar-brand[_ngcontent-%COMP%] {\n    padding-bottom: 0 !important;\n  }\n  .navbar-brand[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n    margin-top: 16px;\n  }\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ "3ITz":
/*!*********************************************!*\
  !*** ./src/app/services/contact.service.ts ***!
  \*********************************************/
/*! exports provided: ContactService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ContactService", function() { return ContactService; });
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/environments/environment */ "AytR");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ "tk/3");



/**
 * Contact service
 */
class ContactService {
    /**
     * @constructor
     */
    constructor(http) {
        this.http = http;
        this.BASE_URL = src_environments_environment__WEBPACK_IMPORTED_MODULE_0__["environment"].BASE_URL;
    }
    /**
     * submit contact form
     * @param {object} data
     * @return {object}
     */
    submitContact(data) {
        return this.http.post(`${this.BASE_URL}/contant_us`, data);
    }
    /**
     * get contact
     * @return {object}
     */
    getContact() {
        return this.http.get(`${this.BASE_URL}/get_restaurant_list`);
    }
}
ContactService.ɵfac = function ContactService_Factory(t) { return new (t || ContactService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClient"])); };
ContactService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({ token: ContactService, factory: ContactService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ "8WL1":
/*!***************************************************************!*\
  !*** ./src/app/shared/profile-form/profile-form.component.ts ***!
  \***************************************************************/
/*! exports provided: ProfileFormComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ProfileFormComponent", function() { return ProfileFormComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var src_app_pages_helpers_must_match_validator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/pages/helpers/must-match-validator */ "FgcS");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var ngx_show_hide_password__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ngx-show-hide-password */ "y6WZ");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");
/* eslint-disable no-invalid-this */


// import { ShowHidePasswordModule } from 'ngx-show-hide-password';






function ProfileFormComponent_div_15_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "MY_INFO.VALIDATION.FIRST_NAME"));
} }
function ProfileFormComponent_div_15_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, ProfileFormComponent_div_15_div_1_Template, 3, 3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.f.first_name.errors.required);
} }
function ProfileFormComponent_div_22_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "MY_INFO.VALIDATION.SECOND_NAME"));
} }
function ProfileFormComponent_div_22_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, ProfileFormComponent_div_22_div_1_Template, 3, 3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r1.f.last_name.errors.required);
} }
function ProfileFormComponent_div_38_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "MY_INFO.VALIDATION.GENDER"));
} }
function ProfileFormComponent_div_38_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, ProfileFormComponent_div_38_div_1_Template, 3, 3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r2.f.gender.errors.required);
} }
function ProfileFormComponent_div_40_div_11_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "MY_INFO.VALIDATION.MOBILE_NUMBER"));
} }
function ProfileFormComponent_div_40_div_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, ProfileFormComponent_div_40_div_11_div_1_Template, 3, 3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r12.f.phone.errors.required);
} }
const _c0 = function (a0) { return { "is-invalid": a0 }; };
function ProfileFormComponent_div_40_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "label", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "span", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "img", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](9, "input", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](10, "div", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](11, ProfileFormComponent_div_40_div_11_Template, 2, 1, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](3, 3, "MY_INFO.MOBILE_NUMBER"), ":");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](5, _c0, ctx_r3.submitted && ctx_r3.f.phone.errors));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r3.submitted && ctx_r3.f.phone.errors);
} }
function ProfileFormComponent_div_41_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "label", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](5, "input", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](3, 1, "MY_INFO.MOBILE_NUMBER"), ":");
} }
function ProfileFormComponent_div_48_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "MY_INFO.VALIDATION.EMAIL"));
} }
function ProfileFormComponent_div_48_div_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "MY_INFO.VALIDATION.VALID_EMAIL"));
} }
function ProfileFormComponent_div_48_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, ProfileFormComponent_div_48_div_1_Template, 3, 3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, ProfileFormComponent_div_48_div_2_Template, 3, 3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r5.f.email.errors.required);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r5.f.email.errors.email);
} }
function ProfileFormComponent_div_49_div_8_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "MY_INFO.VALIDATION.PASSWORD"));
} }
function ProfileFormComponent_div_49_div_8_div_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "MY_INFO.VALIDATION.PASSWORD_LENGTH"));
} }
function ProfileFormComponent_div_49_div_8_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, ProfileFormComponent_div_49_div_8_div_1_Template, 3, 3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, ProfileFormComponent_div_49_div_8_div_2_Template, 3, 3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r16.f.password.errors.required);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r16.f.password.errors.minlength);
} }
function ProfileFormComponent_div_49_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "label", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "show-hide-password", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "input", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](8, ProfileFormComponent_div_49_div_8_Template, 3, 2, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](3, 4, "MY_INFO.PASSWORD"), ":");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("btnOutline", false);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](6, _c0, ctx_r6.submitted && ctx_r6.f.password.errors));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r6.submitted && ctx_r6.f.password.errors);
} }
function ProfileFormComponent_div_50_div_8_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "MY_INFO.VALIDATION.PASSWORD"));
} }
function ProfileFormComponent_div_50_div_8_div_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "MY_INFO.VALIDATION.PASSWORD_LENGTH"));
} }
function ProfileFormComponent_div_50_div_8_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, ProfileFormComponent_div_50_div_8_div_1_Template, 3, 3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, ProfileFormComponent_div_50_div_8_div_2_Template, 3, 3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r19.f.password.errors.required);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r19.f.password.errors.minlength);
} }
function ProfileFormComponent_div_50_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "label", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "show-hide-password", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "input", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](8, ProfileFormComponent_div_50_div_8_Template, 3, 2, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](3, 4, "MY_INFO.PASSWORD"), ":");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("btnOutline", false);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](6, _c0, ctx_r7.submitted && ctx_r7.f.password.errors));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r7.submitted && ctx_r7.f.password.errors);
} }
function ProfileFormComponent_div_51_div_8_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "MY_INFO.VALIDATION.CONFIRM_PASSWORD"));
} }
function ProfileFormComponent_div_51_div_8_div_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "MY_INFO.VALIDATION.PASSWORD_MISMATCH"));
} }
function ProfileFormComponent_div_51_div_8_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, ProfileFormComponent_div_51_div_8_div_1_Template, 3, 3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, ProfileFormComponent_div_51_div_8_div_2_Template, 3, 3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r22.f.confirmPassword.errors.required);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r22.f.confirmPassword.errors.mustMatch);
} }
function ProfileFormComponent_div_51_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "label", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "show-hide-password", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "input", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](8, ProfileFormComponent_div_51_div_8_Template, 3, 2, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](3, 4, "MY_INFO.CONFIRM_PASSWORD"), ":");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("btnOutline", false);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](6, _c0, ctx_r8.submitted && ctx_r8.f.confirmPassword.errors));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r8.submitted && ctx_r8.f.confirmPassword.errors);
} }
/**
 * Profile Form component
 */
class ProfileFormComponent {
    /**
       * @constructor
       */
    constructor(formBuilder) {
        this.formBuilder = formBuilder;
        this.submitChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__["EventEmitter"]();
        this.profileDetails = {};
        this.submitted = false;
        this.isUpdate = false;
        this.hide = true;
        this.fieldTextType = false;
        this.repeatFieldTextType = false;
        this.showPassword = false;
    }
    /**
       * on init
       */
    ngOnInit() {
        setInterval(() => {
            this.lang = sessionStorage.getItem('language');
        }, 1000);
        // this.lang = sessionStorage.getItem('language');
        this.profileForm = this.formBuilder.group({
            first_name: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required],
            last_name: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required],
            gender: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required],
            phone: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].maxLength(13)]],
            email: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].email]],
            password: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].minLength(6)]],
            confirmPassword: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required],
            login_type: ['0'],
            device_type: ['web'],
            device_token: ['sp-eatzilla-web'],
        }, {
            validator: Object(src_app_pages_helpers_must_match_validator__WEBPACK_IMPORTED_MODULE_2__["MustMatch"])('password', 'confirmPassword', this.isUpdate),
        });
    }
    /**
       * on changes
       *
       * @param {SimpleChanges} changes
       */
    ngOnChanges(changes) {
        var _a;
        if ((_a = changes.profileDetails) === null || _a === void 0 ? void 0 : _a.currentValue) {
            this.isUpdate = true;
            setTimeout(() => {
                this.profileForm.patchValue(this.profileDetails);
            }, 100);
        }
    }
    /**
       * form registeration
       */
    get f() {
        return this.profileForm.controls;
    }
    /**
       * Submit
       * @param {object} profileForm
       */
    submitForm(profileForm) {
        this.submitted = true;
        if (profileForm.valid) {
            if (!this.isUpdate) {
                const phoneWithCode = `050${profileForm.value.phone}`;
                profileForm.value.phone = phoneWithCode;
            }
            else {
                const confirmPassword = profileForm.value.password;
                profileForm.value.confirmPassword = confirmPassword;
            }
            this.submitChange.emit(profileForm.value);
        }
    }
}
ProfileFormComponent.ɵfac = function ProfileFormComponent_Factory(t) { return new (t || ProfileFormComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormBuilder"])); };
ProfileFormComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: ProfileFormComponent, selectors: [["app-profile-form"]], inputs: { buttonName: "buttonName", profileDetails: "profileDetails" }, outputs: { submitChange: "submitChange" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]], decls: 58, vars: 52, consts: [[1, "row", "profile"], [1, "col-lg-12"], [1, "purchase"], [1, "purchase-head"], [3, "ngClass"], [1, "myinform-head"], [3, "formGroup", "ngClass", "ngSubmit"], [1, "form-group", "row"], ["for", "label", 1, "col-sm-4", "col-md-2", "col-lg-3", "col-lg-3", "col-form-label", "col-5"], [1, "col-sm-8", "col-md-5", "col-7", "pl-0"], ["type", "text", "formControlName", "first_name", 1, "form-control", 3, "ngClass"], ["class", "text-danger", 4, "ngIf"], ["type", "text", "formControlName", "last_name", 1, "form-control", 3, "ngClass"], ["for", "label", 1, "col-sm-4", "col-md-2", "col-lg-3", "col-5", "col-form-label"], [1, "col-sm-7", "col-md-3", "col-7", "pl-0", "select-gender"], ["formControlName", "gender", 1, "form-control", 3, "ngClass"], ["value", ""], ["value", "Male"], ["value", "FeMale"], ["class", "form-group row", 4, "ngIf"], ["type", "email", "formControlName", "email", 1, "form-control", 3, "ngClass"], ["class", "form-group row pb", 4, "ngIf"], [1, "form-group", "row", "register_submit"], [1, "col-sm-8", "col-7", "col-md-5", "mb-3", "pl-0"], ["type", "submit", 1, "btn-continue", 3, "ngClass"], [1, "text-danger"], [4, "ngIf"], [1, "col-sm-6", "col-md-5", "col-5", "pl-0"], [1, "input-group"], ["id", "basic-addon1", 1, "input-group-text"], ["src", "assets/images/icons/uae_flag.png", "alt", "product", 1, "img-fluid"], [1, "mobile"], ["type", "text", "id", "phones", "formControlName", "phone", 1, "form-control", 3, "ngClass"], ["id", "error-msg", 1, "text-danger"], ["type", "text", "id", "phones", "formControlName", "phone", "disabled", "", 1, "form-control"], [1, "form-group", "row", "pb"], [1, "col-sm-7", "col-md-4", "col-7", "pl-0"], [1, "password-field"], ["size", "lg", "btnStyle", "custom", 1, "eye-button", 3, "btnOutline"], ["type", "password", "formControlName", "password", 1, "form-control", 3, "ngClass"], ["type", "password", "formControlName", "confirmPassword", 1, "form-control", 3, "ngClass"]], template: function ProfileFormComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "h3", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](6, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "form", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("ngSubmit", function ProfileFormComponent_Template_form_ngSubmit_8_listener() { return ctx.submitForm(ctx.profileForm); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "label", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](12, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](14, "input", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](15, ProfileFormComponent_div_15_Template, 2, 1, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "label", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](18);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](19, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](20, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](21, "input", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](22, ProfileFormComponent_div_22_Template, 2, 1, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](23, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "label", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](25);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](26, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](27, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](28, "select", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](29, "option", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](30);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](31, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](32, "option", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](33);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](34, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](35, "option", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](36);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](37, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](38, ProfileFormComponent_div_38_Template, 2, 1, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](39, "hr");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](40, ProfileFormComponent_div_40_Template, 12, 7, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](41, ProfileFormComponent_div_41_Template, 6, 3, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](42, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](43, "label", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](44);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](45, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](46, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](47, "input", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](48, ProfileFormComponent_div_48_Template, 3, 2, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](49, ProfileFormComponent_div_49_Template, 9, 8, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](50, ProfileFormComponent_div_50_Template, 9, 8, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](51, ProfileFormComponent_div_51_Template, 9, 8, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](52, "div", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](53, "label", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](54, "div", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](55, "button", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](56);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](57, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanCondensedB");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](6, 26, "ACCOUNT.MY_INFORMATION"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("formGroup", ctx.profileForm)("ngClass", ctx.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanCondensedB");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](12, 28, "MY_INFO.FIRST_NAME"), ":");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](44, _c0, ctx.submitted && ctx.f.first_name.errors));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.submitted && ctx.f.first_name.errors);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](19, 30, "MY_INFO.SECOND_NAME"), ":");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](46, _c0, ctx.submitted && ctx.f.last_name.errors));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.submitted && ctx.f.last_name.errors);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](26, 32, "MY_INFO.GENDER"), ":");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](48, _c0, ctx.submitted && ctx.f.gender.errors));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](31, 34, "COMMON.SELECT"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](34, 36, "MY_INFO.MALE"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](37, 38, "MY_INFO.FEMALE"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.submitted && ctx.f.gender.errors);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx.isUpdate);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.isUpdate);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](45, 40, "MY_INFO.EMAIL"), ":");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](50, _c0, ctx.submitted && ctx.f.email.errors));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.submitted && ctx.f.email.errors);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx.isUpdate);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.isUpdate);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx.isUpdate);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777LightBT");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](57, 42, ctx.buttonName));
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["NgClass"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["ɵangular_packages_forms_forms_y"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroupDirective"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["DefaultValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControlName"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["SelectControlValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["NgSelectOption"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["ɵangular_packages_forms_forms_x"], ngx_show_hide_password__WEBPACK_IMPORTED_MODULE_4__["ShowHidePasswordComponent"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__["TranslatePipe"]], styles: [".fa-eye-slash[_ngcontent-%COMP%]:hover, .fa-eye[_ngcontent-%COMP%]:hover {\n  cursor: pointer;\n}\n\n.select-gender[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\n\n.eye-button[_ngcontent-%COMP%] {\n  background-color: #432919 !important;\n  border-color: #432919 !important;\n}\n\n.select-gender[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]   .english[_ngcontent-%COMP%] {\n  text-indent: 15px;\n  text-overflow: \"\";\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  padding: 2px 2px 2px 2px;\n  border: none;\n  background: transparent url(\"http://cdn1.iconfinder.com/data/icons/cc_mono_icon_set/blacks/16x16/br_down.png\") no-repeat 230px !important;\n}\n\n.select-gender[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]   .arabic[_ngcontent-%COMP%] {\n  text-indent: 15px;\n  text-overflow: \"\";\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  padding: 2px 2px 2px 2px;\n  border: none;\n  background: transparent url(\"http://cdn1.iconfinder.com/data/icons/cc_mono_icon_set/blacks/16x16/br_down.png\") no-repeat 16px !important;\n}\n\n.password-field[_ngcontent-%COMP%] {\n  width: 100%;\n}\n\n.profile[_ngcontent-%COMP%]   .purchase[_ngcontent-%COMP%] {\n  border: 3px solid #9f9f9f;\n  margin-bottom: 30px;\n}\n\n.profile[_ngcontent-%COMP%]   .purchase-head[_ngcontent-%COMP%] {\n  background: #9f9f9f;\n}\n\n.profile[_ngcontent-%COMP%]   .purchase-head[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  margin: 0;\n  padding: 0px 10px;\n  color: #1d1d1b;\n  font-size: 30px;\n  line-height: 36px;\n  text-align: left;\n}\n\n.profile[_ngcontent-%COMP%]   label.col-form-label[_ngcontent-%COMP%] {\n  font-size: 26px;\n  line-height: 36px;\n  color: #1d1d1b;\n}\n\n.profile[_ngcontent-%COMP%]   .myinform-head[_ngcontent-%COMP%] {\n  margin: 20px 35px;\n}\n\n.profile[_ngcontent-%COMP%]   .myinform-head[_ngcontent-%COMP%]   .btn-continue[_ngcontent-%COMP%] {\n  padding: 5px 30px;\n  font-size: 30px;\n  color: #bc8033;\n  border: 1px solid transparent;\n  background: #432919;\n  border-radius: 30px;\n}\n\n.profile[_ngcontent-%COMP%]   .myinform-head[_ngcontent-%COMP%]   .btn-continue[_ngcontent-%COMP%]:hover {\n  color: #bc8033;\n  transition: cubic-bezier(0.175, 0.885, 0.32, 1.275);\n}\n\n.profile[_ngcontent-%COMP%]   .myinform-head[_ngcontent-%COMP%]   .pb[_ngcontent-%COMP%] {\n  padding-bottom: 15px;\n}\n\n.profile[_ngcontent-%COMP%]   .myinform-head[_ngcontent-%COMP%]   .form-control[_ngcontent-%COMP%] {\n  font-size: 20px;\n  border: 1px solid #9f9f9f;\n  border-radius: 0 !important;\n}\n\n.profile[_ngcontent-%COMP%]   .myinform-head[_ngcontent-%COMP%]   .input-group-text[_ngcontent-%COMP%] {\n  justify-content: center;\n  padding: 0px !important;\n  background-color: unset;\n  border: 1px solid #9f9f9f;\n  border-radius: unset;\n}\n\n.profile[_ngcontent-%COMP%]   .myinform-head[_ngcontent-%COMP%]   .input-group-text[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  height: 50%;\n}\n\n@media only screen and (max-width: 767px) {\n  .profile[_ngcontent-%COMP%]   label.col-form-label[_ngcontent-%COMP%] {\n    font-size: 20px;\n    line-height: 36px;\n    color: #1d1d1b;\n  }\n  .profile[_ngcontent-%COMP%]   .myinform-head[_ngcontent-%COMP%] {\n    margin: 20px 15px;\n  }\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ "AytR":
/*!*****************************************!*\
  !*** ./src/environments/environment.ts ***!
  \*****************************************/
/*! exports provided: environment */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "environment", function() { return environment; });
// This file can be replaced during build by using the `fileReplacements` array.
// `ng build --prod` replaces `environment.ts` with `environment.prod.ts`.
// The list of file replacements can be found in `angular.json`.
const environment = {
    production: true,
    BASE_URL: 'http://167.71.188.226/azzam-eatzilla-backend/api',
};
/*
 * For easier debugging in development mode, you can import the following file
 * to ignore zone related error stack frames such as `zone.run`, `zoneDelegate.invokeTask`.
 *
 * This import should be commented out in production mode because it will have a negative impact
 * on performance if an error is thrown.
 */
// import 'zone.js/dist/zone-error';  // Included with Angular CLI.


/***/ }),

/***/ "CVMR":
/*!*********************************************!*\
  !*** ./src/app/services/address.service.ts ***!
  \*********************************************/
/*! exports provided: AddressService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AddressService", function() { return AddressService; });
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/environments/environment */ "AytR");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ "tk/3");



/**
 * Address service
 */
class AddressService {
    /**
     * @constructor
     */
    constructor(http) {
        this.http = http;
        this.BASE_URL = src_environments_environment__WEBPACK_IMPORTED_MODULE_0__["environment"].BASE_URL;
    }
    /**
     * Get Delivery Address
     * @param {string} authId
     * @param {string} authToken
     * @return {object}
     */
    getDefaultAddress(authId, authToken) {
        return this.http.get(`${this.BASE_URL}/get_default_address?device_type=web&authId=${authId}&authToken=${authToken}`);
    }
    /**
     * Add address
     * @param {object} data
     * @return {object}
     */
    addAddress(data) {
        return this.http.post(`${this.BASE_URL}/add_delivery_address`, data);
    }
    /**
     * Edit address
     * @param {object} data
     * @return {object}
     */
    editAddress(data) {
        return this.http.post(`${this.BASE_URL}/edit_delivery_address`, data);
    }
    /**
     * Delete address
     * @param {string} id
     * @return {object}
     */
    deleteAddress(id) {
        return this.http.get(`${this.BASE_URL}/delete_delivery_address/${id}?device_type=web`);
    }
    /**
     * Get delivery address
     * @param {object} data
     * @return {object}
     */
    getDeliveryAddress({ authId, authToken }) {
        return this.http.get(`${this.BASE_URL}/get_delivery_address?device_type=web&authId=${authId}&authToken=${authToken}`);
    }
    /**
     * Set delivery address
     * @param {object} data
     * @return {object}
     */
    setDeliveryAddress(data) {
        return this.http.post(`${this.BASE_URL}/set_delivery_address`, data);
    }
}
AddressService.ɵfac = function AddressService_Factory(t) { return new (t || AddressService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClient"])); };
AddressService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({ token: AddressService, factory: AddressService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ "Ddp4":
/*!*******************************************!*\
  !*** ./src/app/constants/common.const.ts ***!
  \*******************************************/
/*! exports provided: EN, AR */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EN", function() { return EN; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AR", function() { return AR; });
const EN = 'EN';
const AR = 'AR';


/***/ }),

/***/ "EYk7":
/*!****************************************************!*\
  !*** ./src/app/pages/aboutus/aboutus.component.ts ***!
  \****************************************************/
/*! exports provided: AboutusComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AboutusComponent", function() { return AboutusComponent; });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "LvDl");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var src_app_services_cms_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/services/cms.service */ "/Ffc");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _shared_header_header_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../shared/header/header.component */ "320Y");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _shared_footer_footer_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../shared/footer/footer.component */ "jQpT");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");








function AboutusComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "div", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} }
const _c0 = function () { return ["/ar"]; };
const _c1 = function () { return ["/"]; };
function AboutusComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "app-header", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "section");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](5, "img", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](9, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](14, "img", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](15, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "h2");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "div", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](21, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](22, "div", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](23, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](24, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](25, "a", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](27, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](29, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](30, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](31, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](32, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](33, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](34, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](35, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](37, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](38);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](39, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](40, "img", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](41, "div", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](42, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](43);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](44, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](45, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](46);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](47, "div", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](48, "img", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](49, "div", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](50, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](51);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](52, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](53, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](54);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](55, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](56);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](57, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](58);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](59, "app-footer");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("src", ctx_r1.lang === "AR" ? ctx_r1.getImage("title_background_image_ar") : ctx_r1.getImage("title_background_image"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Medium banner-title-ar" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent("title_ar") : ctx_r1.getContent("title"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("src", ctx_r1.lang === "AR" ? ctx_r1.getImage("title_background_image_ar") : ctx_r1.getImage("title_background_image"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Medium banner-title-ar" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent("title_ar") : ctx_r1.getContent("title"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Regular breadcrumbs__ar" : "font-HomepageBaukasten-Book");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", ctx_r1.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](29, _c0) : _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](30, _c1));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](27, 25, "MENU.HOME"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" / ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](29, 27, "MENU.ABOUT"), "");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Regular mission__ar" : "font-Humanist777BT-RomanB mission__en");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent("section1_description_ar") : ctx_r1.getContent("section1_description"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent("section2_description_ar") : ctx_r1.getContent("section2_description"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("src", ctx_r1.lang === "AR" ? ctx_r1.getImage("section3_image_ar") : ctx_r1.getImage("section3_image"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold our-Mission-title-ar" : "font-Humanist777BT-BoldCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent("section3_title_ar") : ctx_r1.getContent("section3_title"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Regular mission__ar" : "font-Humanist777BT-RomanB mission__en");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent("section3_description_ar") : ctx_r1.getContent("section3_description"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("src", ctx_r1.lang === "AR" ? ctx_r1.getImage("section4_image_ar") : ctx_r1.getImage("section4_image"), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Bold our-Mission-title-ar" : "font-Humanist777BT-BoldCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent("section4_title_ar") : ctx_r1.getContent("section4_title"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "font-Tajawal-Regular mission__ar" : "font-Humanist777BT-RomanB mission__en");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent("section4_description_ar") : ctx_r1.getContent("section4_description"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent("section5_description_ar") : ctx_r1.getContent("section5_description"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.lang === "AR" ? ctx_r1.getContent("section6_description_ar") : ctx_r1.getContent("section6_description"));
} }
/**
 * AboutusComponent
 */
class AboutusComponent {
    /**
     * constructor
     */
    constructor(cmsService) {
        this.cmsService = cmsService;
        this.content = [];
        this.imageBaseUrl = '';
        window.scroll(0, 0);
    }
    /**
     * Page Starts
     */
    ngOnInit() {
        setInterval(() => {
            this.lang = sessionStorage.getItem('language');
        }, 1000);
        // this.lang = sessionStorage.getItem('language');
        this.getAboutPageContent();
    }
    /**
     * get about page content
     */
    getAboutPageContent() {
        this.cmsService.getPageContent('get_cms_about_content').subscribe((response) => {
            if (response['status']) {
                this.content = response['data'];
                this.imageBaseUrl = response['base_image_url'];
            }
        });
    }
    /**
     * Get content
     * @param {string} key
     * @return {object}
     */
    getContent(key) {
        var _a;
        const filterData = lodash__WEBPACK_IMPORTED_MODULE_0___default.a.filter(this.content, ['section', key]);
        return (_a = filterData[0]) === null || _a === void 0 ? void 0 : _a.content;
    }
    /**
     * Get content
     * @param {string} key
     * @return {object}
     */
    getImage(key) {
        var _a;
        const filterData = lodash__WEBPACK_IMPORTED_MODULE_0___default.a.filter(this.content, ['section', key]);
        return `${this.imageBaseUrl}${(_a = filterData[0]) === null || _a === void 0 ? void 0 : _a.content}`;
    }
}
AboutusComponent.ɵfac = function AboutusComponent_Factory(t) { return new (t || AboutusComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](src_app_services_cms_service__WEBPACK_IMPORTED_MODULE_2__["CmsService"])); };
AboutusComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: AboutusComponent, selectors: [["app-aboutus"]], decls: 2, vars: 2, consts: [["class", "loader_section", 4, "ngIf"], [4, "ngIf"], [1, "loader_section"], [1, "loader"], ["setActive", "about"], [1, "web-banner"], [1, "img-fluid", 3, "src"], [1, "container-fluid"], [1, "row"], [1, "col-lg-12"], [1, "banner-title", 3, "ngClass"], [1, "banner", "mobileView"], [1, "banner-title", "container-fluid", 3, "ngClass"], [1, "aboutUsPage", "full-width-custom"], [1, "section"], [1, "col-md-12"], [1, "breadcrumbs", 3, "ngClass"], [3, "routerLink"], [1, "text-center", "mission"], [3, "ngClass"], [1, "our-Mission"], ["alt", "ourMissions", 3, "src"], [1, "our-Mission-title", 3, "ngClass"], [1, "our-principle"], ["alt", "corePrinciples", 3, "src"]], template: function AboutusComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, AboutusComponent_div_0_Template, 2, 0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, AboutusComponent_div_1_Template, 60, 31, "div", 1);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.content || ctx.content.length === 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.content.length > 0);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"], _shared_header_header_component__WEBPACK_IMPORTED_MODULE_4__["HeaderComponent"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgClass"], _angular_router__WEBPACK_IMPORTED_MODULE_5__["RouterLinkWithHref"], _shared_footer_footer_component__WEBPACK_IMPORTED_MODULE_6__["FooterComponent"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__["TranslatePipe"]], styles: ["@font-face {\n  font-family: \"HomepageBaukasten-Book\";\n  src: local(\"HomepageBaukasten-Book\"), url('HomepageBaukasten-Book.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist521BT-Roman\";\n  src: local(\"Humanist521BT-Roman\"), url('Humanist521BT-Roman.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanB\";\n  src: local(\"Humanist777BT-RomanB\"), url('Humanist777BT-RomanB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n  src: local(\"Humanist777BT-BoldCondensedB\"), url('Humanist777BT-BoldCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n  src: local(\"Humanist777BT-RomanCondensedB\"), url('Humanist777BT-RomanCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n  src: local(\"Humanist777BT-BlackCondensedB\"), url('Humanist777BT-BlackCondensed.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist777LightBT\";\n  src: local(\"Humanist777LightBT\"), url('Humanist777LightBT.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"HelveticaNeue-Regular\";\n  src: local(\"HelveticaNeue-Regular\"), url('HelveticaNeue-Regular.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Black\";\n  src: local(\"Tajawal-Black\"), url('Tajawal-Black.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Bold\";\n  src: local(\"Tajawal-Bold\"), url('Tajawal-Bold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraBold\";\n  src: local(\"Tajawal-ExtraBold\"), url('Tajawal-ExtraBold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraLight\";\n  src: local(\"Tajawal-ExtraLight\"), url('Tajawal-ExtraLight.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Light\";\n  src: local(\"Tajawal-Light\"), url('Tajawal-Light.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Medium\";\n  src: local(\"Tajawal-Medium\"), url('Tajawal-Medium.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Regular\";\n  src: local(\"Tajawal-Regular\"), url('Tajawal-Regular.ttf') format(\"truetype\");\n}\n.font-HomepageBaukasten-Book[_ngcontent-%COMP%] {\n  font-family: \"HomepageBaukasten-Book\";\n}\n.font-Humanist521BT-Roman[_ngcontent-%COMP%] {\n  font-family: \"Humanist521BT-Roman\";\n}\n.font-Humanist777BT-RomanB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanB\";\n}\n.font-Humanist777BT-BoldCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n}\n.font-Humanist777BT-RomanCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n}\n.font-Humanist777BT-BlackCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n}\n.font-Humanist777LightBT[_ngcontent-%COMP%] {\n  font-family: \"Humanist777LightBT\" !important;\n}\n.font-HelveticaNeue-Regular[_ngcontent-%COMP%] {\n  font-family: \"HelveticaNeue-Regular\";\n}\n.font-Tajawal-Black[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Black\";\n}\n.font-Tajawal-Bold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Bold\";\n}\n.font-Tajawal-ExtraBold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraBold\";\n}\n.font-Tajawal-ExtraLight[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraLight\";\n}\n.font-Tajawal-Light[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Light\";\n}\n.font-Tajawal-Medium[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Medium\";\n}\n.font-Tajawal-Regular[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Regular\";\n}\na[_ngcontent-%COMP%]:hover {\n  color: initial;\n  text-decoration: none;\n}\n.border-color[_ngcontent-%COMP%] {\n  border-color: #dedede !important;\n}\n.container-fluid[_ngcontent-%COMP%] {\n  width: 100%;\n  padding-right: 25px;\n  padding-left: 25px;\n  margin-right: auto;\n  margin-left: auto;\n}\n.full-width[_ngcontent-%COMP%], .aboutUsPage[_ngcontent-%COMP%], .humanKnowCoffee[_ngcontent-%COMP%], .benefitsAndHarms[_ngcontent-%COMP%], .preparationPage[_ngcontent-%COMP%], .galleryPage[_ngcontent-%COMP%], .productPage[_ngcontent-%COMP%] {\n  max-width: 100%;\n  margin: 0 auto;\n}\na[_ngcontent-%COMP%] {\n  color: initial;\n  text-decoration: none;\n  background-color: transparent;\n}\n.br-1px[_ngcontent-%COMP%] {\n  border-right: 1px solid;\n}\n.ngx-gallery-icon[_ngcontent-%COMP%] {\n  color: red;\n  background: blue;\n}\ngallery-item[_ngcontent-%COMP%] {\n  padding: 2em;\n  border: 2px solid #ebc850 !important;\n}\n.ml-1em[_ngcontent-%COMP%] {\n  margin-left: 1em;\n}\n.border[_ngcontent-%COMP%] {\n  border: 1px solid;\n}\n.roundedCorner[_ngcontent-%COMP%] {\n  border-radius: 30px;\n}\n.mt-1em[_ngcontent-%COMP%] {\n  margin-top: 1em;\n}\n.mt-2em[_ngcontent-%COMP%] {\n  margin-top: 2em;\n}\n.pr-0[_ngcontent-%COMP%] {\n  padding-right: 0;\n}\n.pl-0[_ngcontent-%COMP%] {\n  padding-left: 0;\n}\n.section[_ngcontent-%COMP%] {\n  padding: 2em 0;\n}\n.d-flex[_ngcontent-%COMP%] {\n  display: flex;\n}\n.justify-center[_ngcontent-%COMP%] {\n  justify-content: center;\n}\n.align-center[_ngcontent-%COMP%] {\n  align-items: center;\n}\ngallery-thumbs[_ngcontent-%COMP%] {\n  display: none !important;\n}\n.select-gender[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\n.select-gender[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  text-indent: 15px;\n  text-overflow: \"\";\n  width: 90%;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  padding: 2px 2px 2px 2px;\n  border: none;\n  background: transparent url(\"http://cdn1.iconfinder.com/data/icons/cc_mono_icon_set/blacks/16x16/br_down.png\") no-repeat 230px !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%] {\n  display: flex !important;\n  align-items: center !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%]   .modal-dialog[_ngcontent-%COMP%] {\n  flex-grow: 1;\n}\n.our-branch-address[_ngcontent-%COMP%]   .accordion[_ngcontent-%COMP%]    > .card[_ngcontent-%COMP%]    > .card-header[_ngcontent-%COMP%] {\n  padding: 0;\n  background-color: #ebc850 !important;\n}\n.our-branch-address[_ngcontent-%COMP%]   .panelTitle[_ngcontent-%COMP%] {\n  font-size: 1.25rem;\n  line-height: 1.25rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%] {\n  font-weight: 500;\n  color: #1d1d1b;\n  font-size: 1.5rem;\n  line-height: 2.5rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%]:focus {\n  box-shadow: none !important;\n  text-decoration: none;\n}\n.g-btn-close[_ngcontent-%COMP%] {\n  display: none;\n}\npath[_ngcontent-%COMP%] {\n  fill: #bc8033;\n}\n@media (min-width: 767px) {\n  .navbar-expand-md[_ngcontent-%COMP%]   .navbar-nav[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n    padding-right: 0.3rem !important;\n    padding-left: 0.3rem !important;\n    font-size: 16px !important;\n  }\n}\n@media (max-width: 2560px) {\n  .webView[_ngcontent-%COMP%] {\n    background-size: cover !important;\n  }\n}\n.direction_ltr[_ngcontent-%COMP%] {\n  direction: ltr !important;\n}\n.iti[_ngcontent-%COMP%] {\n  width: 100%;\n}\nbutton.close[_ngcontent-%COMP%] {\n  padding: 0.5em !important;\n  border: none !important;\n}\n.btn_primary[_ngcontent-%COMP%] {\n  background: #432919;\n  color: #ebc850;\n}\ninput[_ngcontent-%COMP%]::-webkit-outer-spin-button, input[_ngcontent-%COMP%]::-webkit-inner-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n\ninput[type=number][_ngcontent-%COMP%] {\n  -moz-appearance: textfield;\n}\n.text-primary[_ngcontent-%COMP%] {\n  color: #ebc850 !important;\n}\n.min-height-10[_ngcontent-%COMP%] {\n  min-height: 10em;\n}\n.pac-container[_ngcontent-%COMP%] {\n  background-color: #fff;\n  position: absolute !important;\n  z-index: 9999999999;\n  border-radius: 2px;\n  border-top: 0;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);\n  box-sizing: border-box;\n  overflow: hidden;\n  font-size: 16px;\n  color: #ebc850;\n}\n.pac-logo[_ngcontent-%COMP%]:after {\n  content: \"\";\n  padding: 1px 1px 1px 0;\n  height: 16px;\n  text-align: right;\n  display: block;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3.png);\n  background-position: right;\n  background-repeat: no-repeat;\n  background-size: 120px 14px;\n}\n.hdpi.pac-logo[_ngcontent-%COMP%]:after {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3_hdpi.png);\n}\n.pac-item[_ngcontent-%COMP%] {\n  cursor: default;\n  padding: 4px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n  line-height: 30px;\n  text-align: left;\n  border-top: 0;\n  font-size: 13px;\n  color: #999;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n}\n.pac-item[_ngcontent-%COMP%]:hover {\n  background-color: #fafafa;\n}\n.pac-item-selected[_ngcontent-%COMP%], .pac-item-selected[_ngcontent-%COMP%]:hover {\n  background-color: #ebf2fe;\n}\n.pac-matched[_ngcontent-%COMP%] {\n  font-weight: 700;\n}\n.pac-item-query[_ngcontent-%COMP%] {\n  font-size: 16px;\n  padding-right: 3px;\n  color: #ebc850;\n}\n.pac-icon[_ngcontent-%COMP%] {\n  width: 15px;\n  height: 20px;\n  margin-right: 7px;\n  margin-top: 6px;\n  display: inline-block;\n  vertical-align: top;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons.png);\n  background-size: 34px;\n}\n.hdpi[_ngcontent-%COMP%]   .pac-icon[_ngcontent-%COMP%] {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons_hdpi.png);\n}\n.pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -1px -1px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -18px -1px;\n}\n.pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -1px -161px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -18px -161px;\n}\n.pac-placeholder[_ngcontent-%COMP%] {\n  color: gray;\n}\n.form-control[_ngcontent-%COMP%]:focus {\n  box-shadow: 0 0 0 0.05rem #9f9f9f;\n}\n.page-link[_ngcontent-%COMP%] {\n  border-color: #432919 !important;\n  color: #432919 !important;\n}\n.page-item.active[_ngcontent-%COMP%]   .page-link[_ngcontent-%COMP%] {\n  background-color: #432919 !important;\n  border-color: #432919 !important;\n  color: #ebc850 !important;\n}\n.b-0[_ngcontent-%COMP%] {\n  bottom: 0px;\n}\n.loader_section[_ngcontent-%COMP%] {\n  display: flex;\n  height: 100vh;\n  align-items: center;\n}\n.loader[_ngcontent-%COMP%], .loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  background: #ebc850;\n  -webkit-animation: load1 1s infinite ease-in-out;\n  animation: load1 1s infinite ease-in-out;\n  width: 1em;\n  height: 4em;\n}\n.loader[_ngcontent-%COMP%] {\n  color: #ebc850;\n  text-indent: -9999em;\n  margin: 88px auto;\n  position: relative;\n  font-size: 11px;\n  transform: translateZ(0);\n  -webkit-animation-delay: -0.16s;\n  animation-delay: -0.16s;\n}\n.loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  position: absolute;\n  top: 0;\n  content: \"\";\n}\n.loader[_ngcontent-%COMP%]:before {\n  left: -1.5em;\n  -webkit-animation-delay: -0.32s;\n  animation-delay: -0.32s;\n}\n.loader[_ngcontent-%COMP%]:after {\n  left: 1.5em;\n}\n@-webkit-keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n@keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n.web-banner[_ngcontent-%COMP%] {\n  position: relative;\n}\n.web-banner[_ngcontent-%COMP%]   .banner-title[_ngcontent-%COMP%] {\n  color: #ebc850;\n  font-size: 3.75rem;\n  line-height: 5rem;\n  position: absolute;\n  bottom: 0%;\n  left: 2%;\n  transform: translate(-2%, 0%);\n}\n.our-Mission[_ngcontent-%COMP%]   img[_ngcontent-%COMP%], .our-principle[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  margin-bottom: 20px;\n}\n.our-Mission-title[_ngcontent-%COMP%] {\n  padding: 0px 0px 20px;\n}\n.web-banner[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  background-position: cover;\n}\n.img-fluid[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 20% !important;\n}\n.mobileView[_ngcontent-%COMP%] {\n  display: none;\n}\n.aboutUsPage[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%] {\n  padding: 33px 0 14px 0 !important;\n}\n.aboutUsPage[_ngcontent-%COMP%]   .breadcrumbs[_ngcontent-%COMP%] {\n  color: #9f9f9f;\n  font-size: 1.25rem;\n  line-height: 2.5rem;\n}\n.aboutUsPage[_ngcontent-%COMP%]   .breadcrumbs[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #9f9f9f !important;\n}\n.aboutUsPage[_ngcontent-%COMP%]   .breadcrumbs__ar[_ngcontent-%COMP%] {\n  font-size: 1.25rem !important;\n}\n.aboutUsPage[_ngcontent-%COMP%]   .our-Mission[_ngcontent-%COMP%] {\n  margin: 3em 0;\n}\n.aboutUsPage[_ngcontent-%COMP%]   .mission[_ngcontent-%COMP%] {\n  padding: 0 118px;\n}\n.aboutUsPage[_ngcontent-%COMP%]   .mission[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  color: #1d1d1b;\n  margin-bottom: 55px;\n  line-height: 2.5rem;\n}\n.aboutUsPage[_ngcontent-%COMP%]   .mission[_ngcontent-%COMP%]   .mission__en[_ngcontent-%COMP%] {\n  font-size: 1.75rem !important;\n}\n.aboutUsPage[_ngcontent-%COMP%]   .mission[_ngcontent-%COMP%]   .mission__ar[_ngcontent-%COMP%] {\n  font-size: 1.75rem !important;\n}\n.aboutUsPage[_ngcontent-%COMP%]   .mission[_ngcontent-%COMP%]   .our-Mission-title[_ngcontent-%COMP%] {\n  margin: 0;\n  text-transform: uppercase;\n  color: #1d1d1b;\n  font-weight: bold;\n  font-size: 2rem;\n  line-height: 2.5rem;\n}\n.aboutUsPage[_ngcontent-%COMP%]   .mission[_ngcontent-%COMP%]   .our-Mission-title-ar[_ngcontent-%COMP%] {\n  font-size: 2.5rem !important;\n}\n@media only screen and (max-width: 767px) {\n  .mobileView[_ngcontent-%COMP%] {\n    position: relative;\n    display: block;\n  }\n\n  .banner-title[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n    font-size: 22px;\n    color: #ebc850;\n    top: 3.5em;\n    position: absolute;\n  }\n\n  .web-banner[_ngcontent-%COMP%] {\n    display: none !important;\n  }\n}\n@media only screen and (max-width: 575px) {\n  .aboutUsPage[_ngcontent-%COMP%]   .mission[_ngcontent-%COMP%] {\n    padding: 0px 10px !important;\n  }\n\n  .aboutUsPage[_ngcontent-%COMP%]   .mission[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n    font-size: 20px;\n    line-height: 24px;\n  }\n\n  .banner-title[_ngcontent-%COMP%] {\n    top: 0;\n  }\n\n  .web-banner[_ngcontent-%COMP%]   .banner-title[_ngcontent-%COMP%] {\n    font-size: 16px;\n  }\n}\n@media only screen and (max-width: 1366px) {\n  .web-banner[_ngcontent-%COMP%] {\n    text-align: inherit;\n    min-height: 300px;\n    height: 100%;\n    background-position: center;\n    background-size: 100% 100%;\n    position: relative;\n  }\n}\n@media only screen and (min-width: 1367px) {\n  .webView[_ngcontent-%COMP%] {\n    text-align: inherit;\n    min-height: 300px;\n    height: 100%;\n    background-position: center;\n    background-size: 100% 100%;\n    position: relative;\n  }\n}\n\n.full-width-custom[_ngcontent-%COMP%] {\n  width: 1366px;\n}\n.breadcrumbs__ar[_ngcontent-%COMP%] {\n  text-align: right !important;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ "FgcS":
/*!*******************************************************!*\
  !*** ./src/app/pages/helpers/must-match-validator.ts ***!
  \*******************************************************/
/*! exports provided: MustMatch */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MustMatch", function() { return MustMatch; });
// custom validator to check that two fields match
function MustMatch(controlName, matchingControlName, isUpdate) {
    return (formGroup) => {
        const control = formGroup.controls[controlName];
        const matchingControl = formGroup.controls[matchingControlName];
        if (matchingControl.errors && !matchingControl.errors.mustMatch) {
            // return if another validator has already found an error on the matchingControl
            return;
        }
        // set error on matchingControl if validation fails
        if (control.value !== matchingControl.value && !isUpdate) {
            matchingControl.setErrors({ mustMatch: true });
        }
        else {
            matchingControl.setErrors(null);
        }
    };
}


/***/ }),

/***/ "Gdn9":
/*!*********************************************!*\
  !*** ./src/app/services/product.service.ts ***!
  \*********************************************/
/*! exports provided: ProductService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ProductService", function() { return ProductService; });
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/environments/environment */ "AytR");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ "tk/3");



/**
 * product services
 */
class ProductService {
    /** service constructor
    */
    constructor(http) {
        this.http = http;
        this.BASE_URL = src_environments_environment__WEBPACK_IMPORTED_MODULE_0__["environment"].BASE_URL;
    }
    /**
     * Get product list
     * @return {object}
     * */
    getproduct() {
        return this.http.get(`${this.BASE_URL}/get_food_list`);
    }
    /**
     * Get single product detail
     * @param {string} foodId
     * @return {object}
     */
    getSingleProduct(foodId) {
        return this.http.post(`${this.BASE_URL}/get_food_detail`, { food_id: foodId });
    }
    /**
     * Add review
     * @param {object} data
     * @return {object}
     */
    addReview(data) {
        return this.http.post(`${this.BASE_URL}/submit_product_review`, data);
    }
}
ProductService.ɵfac = function ProductService_Factory(t) { return new (t || ProductService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClient"])); };
ProductService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({ token: ProductService, factory: ProductService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ "HssT":
/*!*****************************************************!*\
  !*** ./src/app/services/galleryservices.service.ts ***!
  \*****************************************************/
/*! exports provided: GalleryservicesService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GalleryservicesService", function() { return GalleryservicesService; });
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/environments/environment */ "AytR");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ "tk/3");



class GalleryservicesService {
    constructor(http) {
        this.http = http;
        this.BASE_URL = src_environments_environment__WEBPACK_IMPORTED_MODULE_0__["environment"].BASE_URL;
    }
    getgallery() {
        return this.http.get(`${this.BASE_URL}/gallery`);
    }
}
GalleryservicesService.ɵfac = function GalleryservicesService_Factory(t) { return new (t || GalleryservicesService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClient"])); };
GalleryservicesService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({ token: GalleryservicesService, factory: GalleryservicesService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ "NShq":
/*!****************************************************!*\
  !*** ./src/app/pages/gallery/gallery.component.ts ***!
  \****************************************************/
/*! exports provided: GalleryComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GalleryComponent", function() { return GalleryComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var src_app_services_galleryservices_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/services/galleryservices.service */ "HssT");
/* harmony import */ var src_app_services_cms_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/services/cms.service */ "/Ffc");
/* harmony import */ var _shared_header_header_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../shared/header/header.component */ "320Y");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var ng_gallery_lightbox__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-gallery/lightbox */ "2MBV");
/* harmony import */ var _shared_footer_footer_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../shared/footer/footer.component */ "jQpT");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");









function GalleryComponent_img_21_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "img", 14);
} if (rf & 2) {
    const img_r1 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate2"]("src", "", ctx_r0.imageBaseUrl, "/", img_r1.image, "", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", img_r1.class);
} }
const _c0 = function () { return ["/ar"]; };
const _c1 = function () { return ["/"]; };
/**
 * GalleyComponent
 */
class GalleryComponent {
    /**
     * constrctor
     */
    constructor(galleryservices, cmsService) {
        this.galleryservices = galleryservices;
        this.cmsService = cmsService;
        this.imageData = [];
        this.isEven = false;
        this.tempImageList = [];
        this.content = [];
        window.scroll(0, 0);
    }
    /**
     * page Starts
     */
    ngOnInit() {
        setInterval(() => {
            this.lang = sessionStorage.getItem('language');
        }, 1000);
        // this.lang = sessionStorage.getItem('language');
        this.getContent();
        this.galleryservices.getgallery().subscribe((response) => {
            this.imageData = response['data'];
            this.imageBaseUrl = response['base_url'];
            this.imageData.forEach((data, index) => {
                this.appendGalleryClass(data, index);
            });
        });
    }
    /**
     * append class for gallery images
     *
     * @param {any} img
     * @param {number} index
     */
    appendGalleryClass(img, index) {
        if (!this.isEven) {
            this.tempImageList.push(img);
            if (this.tempImageList.length === 2) {
                this.isEven = true;
                this.tempImageList = [];
            }
            else
                this.isEven = false;
            this.imageData[index].class = 'col-md-6';
        }
        else {
            this.tempImageList.push(img);
            if (this.tempImageList.length === 3) {
                // eslint-disable-next-line linebreak-style
                this.isEven = false;
                this.tempImageList = [];
            }
            else
                this.isEven = true;
            this.imageData[index].class = 'col-md-4';
        }
    }
    /**
     * get about page content
     */
    getContent() {
        this.cmsService.getPageContent('get_cms_common_content').subscribe((response) => {
            if (response['status']) {
                this.content = response['data'];
            }
        });
    }
}
GalleryComponent.ɵfac = function GalleryComponent_Factory(t) { return new (t || GalleryComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](src_app_services_galleryservices_service__WEBPACK_IMPORTED_MODULE_1__["GalleryservicesService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](src_app_services_cms_service__WEBPACK_IMPORTED_MODULE_2__["CmsService"])); };
GalleryComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: GalleryComponent, selectors: [["app-gallery"]], decls: 23, vars: 11, consts: [["setActive", "gallery"], [1, "container-fluid", "banner"], [1, "row"], [1, "col-lg-12"], [1, ""], [1, "banner-title", 3, "ngClass"], [1, "mb-0"], [1, "container-fluid"], [1, "breadcrumbs", 3, "ngClass"], [3, "routerLink"], [1, "galleryPage", "full-width-custom"], [1, "row", "gallery"], ["gallerize", ""], [3, "src", "ngClass", 4, "ngFor", "ngForOf"], [3, "src", "ngClass"]], template: function GalleryComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "app-header", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "p", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "a", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](14);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](15, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](19, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](20, "div", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](21, GalleryComponent_img_21_Template, 1, 3, "img", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](22, "app-footer");
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanCondensedB");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx.lang === "AR" ? ctx.content.menu5_name_ar : ctx.content.menu5_name);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Regular breadcrumbs__ar" : "font-HomepageBaukasten-Book");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction0"](9, _c0) : _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction0"](10, _c1));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](15, 7, "MENU.HOME"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" / ", ctx.lang === "AR" ? ctx.content.menu5_name_ar : ctx.content.menu5_name, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.imageData);
    } }, directives: [_shared_header_header_component__WEBPACK_IMPORTED_MODULE_3__["HeaderComponent"], _angular_common__WEBPACK_IMPORTED_MODULE_4__["NgClass"], _angular_router__WEBPACK_IMPORTED_MODULE_5__["RouterLinkWithHref"], ng_gallery_lightbox__WEBPACK_IMPORTED_MODULE_6__["GallerizeDirective"], _angular_common__WEBPACK_IMPORTED_MODULE_4__["NgForOf"], _shared_footer_footer_component__WEBPACK_IMPORTED_MODULE_7__["FooterComponent"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__["TranslatePipe"]], styles: ["@font-face {\n  font-family: \"HomepageBaukasten-Book\";\n  src: local(\"HomepageBaukasten-Book\"), url('HomepageBaukasten-Book.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist521BT-Roman\";\n  src: local(\"Humanist521BT-Roman\"), url('Humanist521BT-Roman.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanB\";\n  src: local(\"Humanist777BT-RomanB\"), url('Humanist777BT-RomanB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n  src: local(\"Humanist777BT-BoldCondensedB\"), url('Humanist777BT-BoldCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n  src: local(\"Humanist777BT-RomanCondensedB\"), url('Humanist777BT-RomanCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n  src: local(\"Humanist777BT-BlackCondensedB\"), url('Humanist777BT-BlackCondensed.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist777LightBT\";\n  src: local(\"Humanist777LightBT\"), url('Humanist777LightBT.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"HelveticaNeue-Regular\";\n  src: local(\"HelveticaNeue-Regular\"), url('HelveticaNeue-Regular.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Black\";\n  src: local(\"Tajawal-Black\"), url('Tajawal-Black.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Bold\";\n  src: local(\"Tajawal-Bold\"), url('Tajawal-Bold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraBold\";\n  src: local(\"Tajawal-ExtraBold\"), url('Tajawal-ExtraBold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraLight\";\n  src: local(\"Tajawal-ExtraLight\"), url('Tajawal-ExtraLight.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Light\";\n  src: local(\"Tajawal-Light\"), url('Tajawal-Light.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Medium\";\n  src: local(\"Tajawal-Medium\"), url('Tajawal-Medium.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Regular\";\n  src: local(\"Tajawal-Regular\"), url('Tajawal-Regular.ttf') format(\"truetype\");\n}\n.font-HomepageBaukasten-Book[_ngcontent-%COMP%] {\n  font-family: \"HomepageBaukasten-Book\";\n}\n.font-Humanist521BT-Roman[_ngcontent-%COMP%] {\n  font-family: \"Humanist521BT-Roman\";\n}\n.font-Humanist777BT-RomanB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanB\";\n}\n.font-Humanist777BT-BoldCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n}\n.font-Humanist777BT-RomanCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n}\n.font-Humanist777BT-BlackCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n}\n.font-Humanist777LightBT[_ngcontent-%COMP%] {\n  font-family: \"Humanist777LightBT\" !important;\n}\n.font-HelveticaNeue-Regular[_ngcontent-%COMP%] {\n  font-family: \"HelveticaNeue-Regular\";\n}\n.font-Tajawal-Black[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Black\";\n}\n.font-Tajawal-Bold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Bold\";\n}\n.font-Tajawal-ExtraBold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraBold\";\n}\n.font-Tajawal-ExtraLight[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraLight\";\n}\n.font-Tajawal-Light[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Light\";\n}\n.font-Tajawal-Medium[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Medium\";\n}\n.font-Tajawal-Regular[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Regular\";\n}\na[_ngcontent-%COMP%]:hover {\n  color: initial;\n  text-decoration: none;\n}\n.border-color[_ngcontent-%COMP%] {\n  border-color: #dedede !important;\n}\n.container-fluid[_ngcontent-%COMP%] {\n  width: 100%;\n  padding-right: 25px;\n  padding-left: 25px;\n  margin-right: auto;\n  margin-left: auto;\n}\n.full-width[_ngcontent-%COMP%], .aboutUsPage[_ngcontent-%COMP%], .humanKnowCoffee[_ngcontent-%COMP%], .benefitsAndHarms[_ngcontent-%COMP%], .preparationPage[_ngcontent-%COMP%], .galleryPage[_ngcontent-%COMP%], .productPage[_ngcontent-%COMP%] {\n  max-width: 100%;\n  margin: 0 auto;\n}\na[_ngcontent-%COMP%] {\n  color: initial;\n  text-decoration: none;\n  background-color: transparent;\n}\n.br-1px[_ngcontent-%COMP%] {\n  border-right: 1px solid;\n}\n.ngx-gallery-icon[_ngcontent-%COMP%] {\n  color: red;\n  background: blue;\n}\ngallery-item[_ngcontent-%COMP%] {\n  padding: 2em;\n  border: 2px solid #ebc850 !important;\n}\n.ml-1em[_ngcontent-%COMP%] {\n  margin-left: 1em;\n}\n.border[_ngcontent-%COMP%] {\n  border: 1px solid;\n}\n.roundedCorner[_ngcontent-%COMP%] {\n  border-radius: 30px;\n}\n.mt-1em[_ngcontent-%COMP%] {\n  margin-top: 1em;\n}\n.mt-2em[_ngcontent-%COMP%] {\n  margin-top: 2em;\n}\n.pr-0[_ngcontent-%COMP%] {\n  padding-right: 0;\n}\n.pl-0[_ngcontent-%COMP%] {\n  padding-left: 0;\n}\n.section[_ngcontent-%COMP%] {\n  padding: 2em 0;\n}\n.d-flex[_ngcontent-%COMP%] {\n  display: flex;\n}\n.justify-center[_ngcontent-%COMP%] {\n  justify-content: center;\n}\n.align-center[_ngcontent-%COMP%] {\n  align-items: center;\n}\ngallery-thumbs[_ngcontent-%COMP%] {\n  display: none !important;\n}\n.select-gender[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\n.select-gender[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  text-indent: 15px;\n  text-overflow: \"\";\n  width: 90%;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  padding: 2px 2px 2px 2px;\n  border: none;\n  background: transparent url(\"http://cdn1.iconfinder.com/data/icons/cc_mono_icon_set/blacks/16x16/br_down.png\") no-repeat 230px !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%] {\n  display: flex !important;\n  align-items: center !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%]   .modal-dialog[_ngcontent-%COMP%] {\n  flex-grow: 1;\n}\n.our-branch-address[_ngcontent-%COMP%]   .accordion[_ngcontent-%COMP%]    > .card[_ngcontent-%COMP%]    > .card-header[_ngcontent-%COMP%] {\n  padding: 0;\n  background-color: #ebc850 !important;\n}\n.our-branch-address[_ngcontent-%COMP%]   .panelTitle[_ngcontent-%COMP%] {\n  font-size: 1.25rem;\n  line-height: 1.25rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%] {\n  font-weight: 500;\n  color: #1d1d1b;\n  font-size: 1.5rem;\n  line-height: 2.5rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%]:focus {\n  box-shadow: none !important;\n  text-decoration: none;\n}\n.g-btn-close[_ngcontent-%COMP%] {\n  display: none;\n}\npath[_ngcontent-%COMP%] {\n  fill: #bc8033;\n}\n@media (min-width: 767px) {\n  .navbar-expand-md[_ngcontent-%COMP%]   .navbar-nav[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n    padding-right: 0.3rem !important;\n    padding-left: 0.3rem !important;\n    font-size: 16px !important;\n  }\n}\n@media (max-width: 2560px) {\n  .webView[_ngcontent-%COMP%] {\n    background-size: cover !important;\n  }\n}\n.direction_ltr[_ngcontent-%COMP%] {\n  direction: ltr !important;\n}\n.iti[_ngcontent-%COMP%] {\n  width: 100%;\n}\nbutton.close[_ngcontent-%COMP%] {\n  padding: 0.5em !important;\n  border: none !important;\n}\n.btn_primary[_ngcontent-%COMP%] {\n  background: #432919;\n  color: #ebc850;\n}\ninput[_ngcontent-%COMP%]::-webkit-outer-spin-button, input[_ngcontent-%COMP%]::-webkit-inner-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n\ninput[type=number][_ngcontent-%COMP%] {\n  -moz-appearance: textfield;\n}\n.text-primary[_ngcontent-%COMP%] {\n  color: #ebc850 !important;\n}\n.min-height-10[_ngcontent-%COMP%] {\n  min-height: 10em;\n}\n.pac-container[_ngcontent-%COMP%] {\n  background-color: #fff;\n  position: absolute !important;\n  z-index: 9999999999;\n  border-radius: 2px;\n  border-top: 0;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);\n  box-sizing: border-box;\n  overflow: hidden;\n  font-size: 16px;\n  color: #ebc850;\n}\n.pac-logo[_ngcontent-%COMP%]:after {\n  content: \"\";\n  padding: 1px 1px 1px 0;\n  height: 16px;\n  text-align: right;\n  display: block;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3.png);\n  background-position: right;\n  background-repeat: no-repeat;\n  background-size: 120px 14px;\n}\n.hdpi.pac-logo[_ngcontent-%COMP%]:after {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3_hdpi.png);\n}\n.pac-item[_ngcontent-%COMP%] {\n  cursor: default;\n  padding: 4px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n  line-height: 30px;\n  text-align: left;\n  border-top: 0;\n  font-size: 13px;\n  color: #999;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n}\n.pac-item[_ngcontent-%COMP%]:hover {\n  background-color: #fafafa;\n}\n.pac-item-selected[_ngcontent-%COMP%], .pac-item-selected[_ngcontent-%COMP%]:hover {\n  background-color: #ebf2fe;\n}\n.pac-matched[_ngcontent-%COMP%] {\n  font-weight: 700;\n}\n.pac-item-query[_ngcontent-%COMP%] {\n  font-size: 16px;\n  padding-right: 3px;\n  color: #ebc850;\n}\n.pac-icon[_ngcontent-%COMP%] {\n  width: 15px;\n  height: 20px;\n  margin-right: 7px;\n  margin-top: 6px;\n  display: inline-block;\n  vertical-align: top;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons.png);\n  background-size: 34px;\n}\n.hdpi[_ngcontent-%COMP%]   .pac-icon[_ngcontent-%COMP%] {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons_hdpi.png);\n}\n.pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -1px -1px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -18px -1px;\n}\n.pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -1px -161px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -18px -161px;\n}\n.pac-placeholder[_ngcontent-%COMP%] {\n  color: gray;\n}\n.form-control[_ngcontent-%COMP%]:focus {\n  box-shadow: 0 0 0 0.05rem #9f9f9f;\n}\n.page-link[_ngcontent-%COMP%] {\n  border-color: #432919 !important;\n  color: #432919 !important;\n}\n.page-item.active[_ngcontent-%COMP%]   .page-link[_ngcontent-%COMP%] {\n  background-color: #432919 !important;\n  border-color: #432919 !important;\n  color: #ebc850 !important;\n}\n.b-0[_ngcontent-%COMP%] {\n  bottom: 0px;\n}\n.loader_section[_ngcontent-%COMP%] {\n  display: flex;\n  height: 100vh;\n  align-items: center;\n}\n.loader[_ngcontent-%COMP%], .loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  background: #ebc850;\n  -webkit-animation: load1 1s infinite ease-in-out;\n  animation: load1 1s infinite ease-in-out;\n  width: 1em;\n  height: 4em;\n}\n.loader[_ngcontent-%COMP%] {\n  color: #ebc850;\n  text-indent: -9999em;\n  margin: 88px auto;\n  position: relative;\n  font-size: 11px;\n  transform: translateZ(0);\n  -webkit-animation-delay: -0.16s;\n  animation-delay: -0.16s;\n}\n.loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  position: absolute;\n  top: 0;\n  content: \"\";\n}\n.loader[_ngcontent-%COMP%]:before {\n  left: -1.5em;\n  -webkit-animation-delay: -0.32s;\n  animation-delay: -0.32s;\n}\n.loader[_ngcontent-%COMP%]:after {\n  left: 1.5em;\n}\n@-webkit-keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n@keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n.banner[_ngcontent-%COMP%] {\n  background-image: url('gallery_bg.png');\n}\n.banner[_ngcontent-%COMP%]   .banner-title[_ngcontent-%COMP%] {\n  color: #ebc850;\n  margin-bottom: 15px;\n  font-size: 3.75rem;\n  line-height: 5rem;\n}\n.breadcrumbs[_ngcontent-%COMP%] {\n  margin-top: 33PX;\n  color: #9f9f9f;\n  font-size: 20px;\n  \n}\n.breadcrumbs[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #9f9f9f !important;\n}\n.breadcrumbs__ar[_ngcontent-%COMP%] {\n  font-size: 1.25rem;\n}\n.gallery[_ngcontent-%COMP%] {\n  padding: 0 0em 1em 0px;\n}\n.gallery[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  padding: 0.5em;\n}\n@media (max-width: 575px) {\n  .banner[_ngcontent-%COMP%]   .banner-title[_ngcontent-%COMP%] {\n    padding-top: 0em;\n    padding-bottom: 0em;\n    margin-bottom: 0;\n    font-size: 30px;\n    line-height: 60px;\n  }\n}\n\n.full-width-custom[_ngcontent-%COMP%] {\n  width: 1366px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ "Oj9b":
/*!****************************************************************!*\
  !*** ./src/app/pages/order-history/order-history.component.ts ***!
  \****************************************************************/
/*! exports provided: OrderHistoryComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OrderHistoryComponent", function() { return OrderHistoryComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var src_app_services_order_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/services/order.service */ "kVqo");
/* harmony import */ var src_app_services_storage_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/storage.service */ "n90K");
/* harmony import */ var src_app_services_modal_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/services/modal.service */ "VQPA");
/* harmony import */ var _shared_header_header_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../shared/header/header.component */ "320Y");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ng-bootstrap/ng-bootstrap */ "1kSV");
/* harmony import */ var _shared_order_order_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../shared/order/order.component */ "aUFk");
/* harmony import */ var _shared_footer_footer_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../shared/footer/footer.component */ "jQpT");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");











const _c0 = function (a0) { return { orders: a0 }; };
function OrderHistoryComponent_ng_template_30_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainer"](0, 20);
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](38);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", _r3)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](2, _c0, ctx_r1.upcomingOrders));
} }
function OrderHistoryComponent_ng_template_35_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainer"](0, 20);
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](38);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", _r3)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](2, _c0, ctx_r2.pastOrders));
} }
function OrderHistoryComponent_ng_template_37_div_0_tbody_18_span_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "b");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](3, 1, "ORDER_HISTORY.DELIVERED"));
} }
function OrderHistoryComponent_ng_template_37_div_0_tbody_18_span_8_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "b");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](3, 1, "ORDER_HISTORY.CANCELLED"));
} }
function OrderHistoryComponent_ng_template_37_div_0_tbody_18_span_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "b");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](3, 1, "ORDER_HISTORY.WAITING_TO_ACCEPT"));
} }
function OrderHistoryComponent_ng_template_37_div_0_tbody_18_span_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "b");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](3, 1, "ORDER_HISTORY.PREPARING_FOOD"));
} }
function OrderHistoryComponent_ng_template_37_div_0_tbody_18_span_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "b");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](3, 1, "ORDER_HISTORY.RIDER_ON_THE_WAY"));
} }
function OrderHistoryComponent_ng_template_37_div_0_tbody_18_Template(rf, ctx) { if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tbody", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](7, OrderHistoryComponent_ng_template_37_div_0_tbody_18_span_7_Template, 4, 3, "span", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](8, OrderHistoryComponent_ng_template_37_div_0_tbody_18_span_8_Template, 4, 3, "span", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](9, OrderHistoryComponent_ng_template_37_div_0_tbody_18_span_9_Template, 4, 3, "span", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](10, OrderHistoryComponent_ng_template_37_div_0_tbody_18_span_10_Template, 4, 3, "span", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](11, OrderHistoryComponent_ng_template_37_div_0_tbody_18_span_11_Template, 4, 3, "span", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function OrderHistoryComponent_ng_template_37_div_0_tbody_18_Template_div_click_15_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r16); const order_r9 = ctx.$implicit; const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3); return ctx_r15.viewOrderDetails(order_r9); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](17, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const order_r9 = ctx.$implicit;
    const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx_r8.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", order_r9.order_id, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", order_r9.bill_amount, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", order_r9.status == 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", order_r9.status == 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", order_r9.status == 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", order_r9.status == 1 || order_r9.status == 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", order_r9.status == 3 || order_r9.status == 4 || order_r9.status == 5 || order_r9.status == 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", order_r9.ordered_on, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx_r8.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](17, 11, "ORDER_HISTORY.VIEW"));
} }
function OrderHistoryComponent_ng_template_37_div_0_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "table", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "thead");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](5, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](8, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](11, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](14, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](17, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](18, OrderHistoryComponent_ng_template_37_div_0_tbody_18_Template, 18, 13, "tbody", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const orders_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().orders;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](5, 6, "ORDER_HISTORY.ORDER_ID"));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](8, 8, "ORDER_HISTORY.PRICE"));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](11, 10, "ORDER_HISTORY.STATUS"));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](14, 12, "ORDER_HISTORY.DATE"));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](17, 14, "ORDER_HISTORY.VIEW"));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", orders_r5);
} }
function OrderHistoryComponent_ng_template_37_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "h3", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx_r7.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](3, 2, "ORDER_HISTORY.NO_ORDERS"));
} }
function OrderHistoryComponent_ng_template_37_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, OrderHistoryComponent_ng_template_37_div_0_Template, 19, 16, "div", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, OrderHistoryComponent_ng_template_37_div_1_Template, 4, 4, "div", 22);
} if (rf & 2) {
    const orders_r5 = ctx.orders;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", orders_r5.length > 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", orders_r5.length === 0);
} }
const _c1 = function () { return ["/ar"]; };
const _c2 = function () { return ["/"]; };
const _c3 = function () { return ["/ar/user-account"]; };
const _c4 = function () { return ["/user-account"]; };
/**
 * OrderHistoryComponent
 */
class OrderHistoryComponent {
    /**
     *constructor
     */
    constructor(router, orderService, storageService, setModalService) {
        this.router = router;
        this.orderService = orderService;
        this.storageService = storageService;
        this.setModalService = setModalService;
        this.profile = {};
        this.upcomingOrders = [];
        this.pastOrders = [];
        this.order = {};
        window.scroll(0, 0);
    }
    /**
   * Page starts
   */
    ngOnInit() {
        setInterval(() => {
            this.lang = sessionStorage.getItem('language');
        }, 1000);
        // this.lang = sessionStorage.getItem('language');
        this.profile = JSON.parse(this.storageService.getItem('profile'));
        if (this.profile !== null && Object.keys(this.profile).length > 0) {
            this.getOrderHistory();
        }
        else {
            this.lang === 'AR' ? this.router.navigate(['/ar']) : this.router.navigate(['/']);
        }
    }
    /**
     * Get order history
     */
    getOrderHistory() {
        const data = {
            authId: this.profile.authId,
            authToken: this.profile.authToken,
        };
        this.orderService.orderHistory(data).subscribe((response) => {
            if (response['status'] === true) {
                this.upcomingOrders = response['upcoming_orders'];
                this.pastOrders = response['past_orders'];
            }
        });
    }
    /**
     * View order details
     * @param {object} order
     */
    viewOrderDetails(order) {
        this.order = order;
        this.setModalService.setOrderModalStatus({
            isOrderModalOpen: true,
        });
    }
}
OrderHistoryComponent.ɵfac = function OrderHistoryComponent_Factory(t) { return new (t || OrderHistoryComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_1__["Router"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](src_app_services_order_service__WEBPACK_IMPORTED_MODULE_2__["OrderService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](src_app_services_storage_service__WEBPACK_IMPORTED_MODULE_3__["StorageService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](src_app_services_modal_service__WEBPACK_IMPORTED_MODULE_4__["ModalService"])); };
OrderHistoryComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: OrderHistoryComponent, selectors: [["app-order-history"]], decls: 41, vars: 32, consts: [["setActive", "cart"], [1, "cartpageheader"], [1, "container-fluid"], [1, "row"], [1, "col-lg-12"], [1, "banner"], [1, "banner-head"], [3, "ngClass"], [1, "breadcumbs"], [3, "routerLink"], [1, "orderhistory", "row"], [1, "purchase"], ["ngbNav", "", 1, "nav-tabs", "d-flex", "justify-content-around", "p-0"], ["nav", "ngbNav"], [1, "w-50", 3, "ngbNavItem"], ["ngbNavLink", "", 1, "text-center", 3, "ngClass"], ["ngbNavContent", ""], [3, "ngbNavOutlet"], ["orderTable", ""], [3, "order"], [3, "ngTemplateOutlet", "ngTemplateOutletContext"], ["class", "table-responsive min-height-10", 4, "ngIf"], ["class", "min-height-10 d-flex justify-content-center align-center", 4, "ngIf"], [1, "table-responsive", "min-height-10"], [1, "table"], [3, "ngClass", 4, "ngFor", "ngForOf"], [1, "cart-det"], ["class", "text-success", 4, "ngIf"], ["class", "text-danger", 4, "ngIf"], ["class", "text-primary", 4, "ngIf"], [1, "cursor_pointer", 3, "ngClass", "click"], [1, "text-success"], [1, "text-danger"], [1, "text-primary"], [1, "min-height-10", "d-flex", "justify-content-center", "align-center"]], template: function OrderHistoryComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "app-header", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "h3", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "span", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "a", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](15, " / ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "a", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](17);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](18, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](19);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](20, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](21, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](23, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "ul", 12, 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](26, "li", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](27, "a", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](28);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](29, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](30, OrderHistoryComponent_ng_template_30_Template, 1, 4, "ng-template", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](31, "li", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](32, "a", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](33);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](34, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](35, OrderHistoryComponent_ng_template_35_Template, 1, 4, "ng-template", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](36, "div", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](37, OrderHistoryComponent_ng_template_37_Template, 2, 2, "ng-template", 16, 18, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](39, "app-order", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](40, "app-footer");
    } if (rf & 2) {
        const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](25);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanCondensedB");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](9, 16, "ACCOUNT.ORDER_HISTORY"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Regular" : "font-HomepageBaukasten-Book");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction0"](28, _c1) : _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction0"](29, _c2));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](14, 18, "MENU.HOME"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("routerLink", ctx.lang === "AR" ? _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction0"](30, _c3) : _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction0"](31, _c4));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](18, 20, "ACCOUNT.USER_ACCOUNT"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" / ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](20, 22, "ACCOUNT.ORDER_HISTORY"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngbNavItem", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanCondensedB");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](29, 24, "ORDER_HISTORY.UPCOMING_ORDERS"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngbNavItem", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanCondensedB");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](34, 26, "ORDER_HISTORY.PAST_ORDERS"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngbNavOutlet", _r0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("order", ctx.order);
    } }, directives: [_shared_header_header_component__WEBPACK_IMPORTED_MODULE_5__["HeaderComponent"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgClass"], _angular_router__WEBPACK_IMPORTED_MODULE_1__["RouterLinkWithHref"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_7__["NgbNav"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_7__["NgbNavItem"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_7__["NgbNavLink"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_7__["NgbNavContent"], _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_7__["NgbNavOutlet"], _shared_order_order_component__WEBPACK_IMPORTED_MODULE_8__["OrderComponent"], _shared_footer_footer_component__WEBPACK_IMPORTED_MODULE_9__["FooterComponent"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgTemplateOutlet"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgIf"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgForOf"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__["TranslatePipe"]], styles: ["@font-face {\n  font-family: \"HomepageBaukasten-Book\";\n  src: local(\"HomepageBaukasten-Book\"), url('HomepageBaukasten-Book.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist521BT-Roman\";\n  src: local(\"Humanist521BT-Roman\"), url('Humanist521BT-Roman.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanB\";\n  src: local(\"Humanist777BT-RomanB\"), url('Humanist777BT-RomanB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n  src: local(\"Humanist777BT-BoldCondensedB\"), url('Humanist777BT-BoldCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n  src: local(\"Humanist777BT-RomanCondensedB\"), url('Humanist777BT-RomanCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n  src: local(\"Humanist777BT-BlackCondensedB\"), url('Humanist777BT-BlackCondensed.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist777LightBT\";\n  src: local(\"Humanist777LightBT\"), url('Humanist777LightBT.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"HelveticaNeue-Regular\";\n  src: local(\"HelveticaNeue-Regular\"), url('HelveticaNeue-Regular.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Black\";\n  src: local(\"Tajawal-Black\"), url('Tajawal-Black.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Bold\";\n  src: local(\"Tajawal-Bold\"), url('Tajawal-Bold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraBold\";\n  src: local(\"Tajawal-ExtraBold\"), url('Tajawal-ExtraBold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraLight\";\n  src: local(\"Tajawal-ExtraLight\"), url('Tajawal-ExtraLight.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Light\";\n  src: local(\"Tajawal-Light\"), url('Tajawal-Light.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Medium\";\n  src: local(\"Tajawal-Medium\"), url('Tajawal-Medium.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Regular\";\n  src: local(\"Tajawal-Regular\"), url('Tajawal-Regular.ttf') format(\"truetype\");\n}\n.font-HomepageBaukasten-Book[_ngcontent-%COMP%] {\n  font-family: \"HomepageBaukasten-Book\";\n}\n.font-Humanist521BT-Roman[_ngcontent-%COMP%] {\n  font-family: \"Humanist521BT-Roman\";\n}\n.font-Humanist777BT-RomanB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanB\";\n}\n.font-Humanist777BT-BoldCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n}\n.font-Humanist777BT-RomanCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n}\n.font-Humanist777BT-BlackCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n}\n.font-Humanist777LightBT[_ngcontent-%COMP%] {\n  font-family: \"Humanist777LightBT\" !important;\n}\n.font-HelveticaNeue-Regular[_ngcontent-%COMP%] {\n  font-family: \"HelveticaNeue-Regular\";\n}\n.font-Tajawal-Black[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Black\";\n}\n.font-Tajawal-Bold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Bold\";\n}\n.font-Tajawal-ExtraBold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraBold\";\n}\n.font-Tajawal-ExtraLight[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraLight\";\n}\n.font-Tajawal-Light[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Light\";\n}\n.font-Tajawal-Medium[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Medium\";\n}\n.font-Tajawal-Regular[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Regular\";\n}\na[_ngcontent-%COMP%]:hover {\n  color: initial;\n  text-decoration: none;\n}\n.border-color[_ngcontent-%COMP%] {\n  border-color: #dedede !important;\n}\n.container-fluid[_ngcontent-%COMP%] {\n  width: 100%;\n  padding-right: 25px;\n  padding-left: 25px;\n  margin-right: auto;\n  margin-left: auto;\n}\n.full-width[_ngcontent-%COMP%], .aboutUsPage[_ngcontent-%COMP%], .humanKnowCoffee[_ngcontent-%COMP%], .benefitsAndHarms[_ngcontent-%COMP%], .preparationPage[_ngcontent-%COMP%], .galleryPage[_ngcontent-%COMP%], .productPage[_ngcontent-%COMP%] {\n  max-width: 100%;\n  margin: 0 auto;\n}\na[_ngcontent-%COMP%] {\n  color: initial;\n  text-decoration: none;\n  background-color: transparent;\n}\n.br-1px[_ngcontent-%COMP%] {\n  border-right: 1px solid;\n}\n.ngx-gallery-icon[_ngcontent-%COMP%] {\n  color: red;\n  background: blue;\n}\ngallery-item[_ngcontent-%COMP%] {\n  padding: 2em;\n  border: 2px solid #ebc850 !important;\n}\n.ml-1em[_ngcontent-%COMP%] {\n  margin-left: 1em;\n}\n.border[_ngcontent-%COMP%] {\n  border: 1px solid;\n}\n.roundedCorner[_ngcontent-%COMP%] {\n  border-radius: 30px;\n}\n.mt-1em[_ngcontent-%COMP%] {\n  margin-top: 1em;\n}\n.mt-2em[_ngcontent-%COMP%] {\n  margin-top: 2em;\n}\n.pr-0[_ngcontent-%COMP%] {\n  padding-right: 0;\n}\n.pl-0[_ngcontent-%COMP%] {\n  padding-left: 0;\n}\n.section[_ngcontent-%COMP%] {\n  padding: 2em 0;\n}\n.d-flex[_ngcontent-%COMP%] {\n  display: flex;\n}\n.justify-center[_ngcontent-%COMP%] {\n  justify-content: center;\n}\n.align-center[_ngcontent-%COMP%] {\n  align-items: center;\n}\ngallery-thumbs[_ngcontent-%COMP%] {\n  display: none !important;\n}\n.select-gender[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\n.select-gender[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  text-indent: 15px;\n  text-overflow: \"\";\n  width: 90%;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  padding: 2px 2px 2px 2px;\n  border: none;\n  background: transparent url(\"http://cdn1.iconfinder.com/data/icons/cc_mono_icon_set/blacks/16x16/br_down.png\") no-repeat 230px !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%] {\n  display: flex !important;\n  align-items: center !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%]   .modal-dialog[_ngcontent-%COMP%] {\n  flex-grow: 1;\n}\n.our-branch-address[_ngcontent-%COMP%]   .accordion[_ngcontent-%COMP%]    > .card[_ngcontent-%COMP%]    > .card-header[_ngcontent-%COMP%] {\n  padding: 0;\n  background-color: #ebc850 !important;\n}\n.our-branch-address[_ngcontent-%COMP%]   .panelTitle[_ngcontent-%COMP%] {\n  font-size: 1.25rem;\n  line-height: 1.25rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%] {\n  font-weight: 500;\n  color: #1d1d1b;\n  font-size: 1.5rem;\n  line-height: 2.5rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%]:focus {\n  box-shadow: none !important;\n  text-decoration: none;\n}\n.g-btn-close[_ngcontent-%COMP%] {\n  display: none;\n}\npath[_ngcontent-%COMP%] {\n  fill: #bc8033;\n}\n@media (min-width: 767px) {\n  .navbar-expand-md[_ngcontent-%COMP%]   .navbar-nav[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n    padding-right: 0.3rem !important;\n    padding-left: 0.3rem !important;\n    font-size: 16px !important;\n  }\n}\n@media (max-width: 2560px) {\n  .webView[_ngcontent-%COMP%] {\n    background-size: cover !important;\n  }\n}\n.direction_ltr[_ngcontent-%COMP%] {\n  direction: ltr !important;\n}\n.iti[_ngcontent-%COMP%] {\n  width: 100%;\n}\nbutton.close[_ngcontent-%COMP%] {\n  padding: 0.5em !important;\n  border: none !important;\n}\n.btn_primary[_ngcontent-%COMP%] {\n  background: #432919;\n  color: #ebc850;\n}\ninput[_ngcontent-%COMP%]::-webkit-outer-spin-button, input[_ngcontent-%COMP%]::-webkit-inner-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n\ninput[type=number][_ngcontent-%COMP%] {\n  -moz-appearance: textfield;\n}\n.text-primary[_ngcontent-%COMP%] {\n  color: #ebc850 !important;\n}\n.min-height-10[_ngcontent-%COMP%] {\n  min-height: 10em;\n}\n.pac-container[_ngcontent-%COMP%] {\n  background-color: #fff;\n  position: absolute !important;\n  z-index: 9999999999;\n  border-radius: 2px;\n  border-top: 0;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);\n  box-sizing: border-box;\n  overflow: hidden;\n  font-size: 16px;\n  color: #ebc850;\n}\n.pac-logo[_ngcontent-%COMP%]:after {\n  content: \"\";\n  padding: 1px 1px 1px 0;\n  height: 16px;\n  text-align: right;\n  display: block;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3.png);\n  background-position: right;\n  background-repeat: no-repeat;\n  background-size: 120px 14px;\n}\n.hdpi.pac-logo[_ngcontent-%COMP%]:after {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3_hdpi.png);\n}\n.pac-item[_ngcontent-%COMP%] {\n  cursor: default;\n  padding: 4px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n  line-height: 30px;\n  text-align: left;\n  border-top: 0;\n  font-size: 13px;\n  color: #999;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n}\n.pac-item[_ngcontent-%COMP%]:hover {\n  background-color: #fafafa;\n}\n.pac-item-selected[_ngcontent-%COMP%], .pac-item-selected[_ngcontent-%COMP%]:hover {\n  background-color: #ebf2fe;\n}\n.pac-matched[_ngcontent-%COMP%] {\n  font-weight: 700;\n}\n.pac-item-query[_ngcontent-%COMP%] {\n  font-size: 16px;\n  padding-right: 3px;\n  color: #ebc850;\n}\n.pac-icon[_ngcontent-%COMP%] {\n  width: 15px;\n  height: 20px;\n  margin-right: 7px;\n  margin-top: 6px;\n  display: inline-block;\n  vertical-align: top;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons.png);\n  background-size: 34px;\n}\n.hdpi[_ngcontent-%COMP%]   .pac-icon[_ngcontent-%COMP%] {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons_hdpi.png);\n}\n.pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -1px -1px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -18px -1px;\n}\n.pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -1px -161px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -18px -161px;\n}\n.pac-placeholder[_ngcontent-%COMP%] {\n  color: gray;\n}\n.form-control[_ngcontent-%COMP%]:focus {\n  box-shadow: 0 0 0 0.05rem #9f9f9f;\n}\n.page-link[_ngcontent-%COMP%] {\n  border-color: #432919 !important;\n  color: #432919 !important;\n}\n.page-item.active[_ngcontent-%COMP%]   .page-link[_ngcontent-%COMP%] {\n  background-color: #432919 !important;\n  border-color: #432919 !important;\n  color: #ebc850 !important;\n}\n.b-0[_ngcontent-%COMP%] {\n  bottom: 0px;\n}\n.loader_section[_ngcontent-%COMP%] {\n  display: flex;\n  height: 100vh;\n  align-items: center;\n}\n.loader[_ngcontent-%COMP%], .loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  background: #ebc850;\n  -webkit-animation: load1 1s infinite ease-in-out;\n  animation: load1 1s infinite ease-in-out;\n  width: 1em;\n  height: 4em;\n}\n.loader[_ngcontent-%COMP%] {\n  color: #ebc850;\n  text-indent: -9999em;\n  margin: 88px auto;\n  position: relative;\n  font-size: 11px;\n  transform: translateZ(0);\n  -webkit-animation-delay: -0.16s;\n  animation-delay: -0.16s;\n}\n.loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  position: absolute;\n  top: 0;\n  content: \"\";\n}\n.loader[_ngcontent-%COMP%]:before {\n  left: -1.5em;\n  -webkit-animation-delay: -0.32s;\n  animation-delay: -0.32s;\n}\n.loader[_ngcontent-%COMP%]:after {\n  left: 1.5em;\n}\n@-webkit-keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n@keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n.orderhistory[_ngcontent-%COMP%]   .nav-tabs[_ngcontent-%COMP%] {\n  border-bottom: 3px solid #dee2e6;\n}\n.orderhistory[_ngcontent-%COMP%]   .nav-tabs[_ngcontent-%COMP%]   .nav-link.active[_ngcontent-%COMP%], .orderhistory[_ngcontent-%COMP%]   .nav-tabs[_ngcontent-%COMP%]   .nav-item.show[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n  background-color: #ebc850;\n}\n.cartpageheader[_ngcontent-%COMP%] {\n  border-top: 1px solid #1d1d1b;\n}\n.banner-head[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 50px;\n  line-height: 80px;\n  color: #1d1d1b;\n  text-transform: capitalize;\n  margin: 0;\n}\n.breadcumbs[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  font-size: 20px;\n  line-height: 40px;\n  text-align: right;\n  color: #9f9f9f;\n}\n.breadcumbs[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #9f9f9f !important;\n}\n.banner[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  flex-direction: row;\n  flex-wrap: wrap;\n}\n.purchase[_ngcontent-%COMP%] {\n  border: 3px solid #9f9f9f;\n  margin-bottom: 30px;\n}\n.purchase-head[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  margin: 0;\n  padding: 0;\n  color: #432919;\n  font-size: 30px;\n  line-height: 36px;\n  text-align: left;\n}\n.purchase[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%] {\n  background: #dedede;\n  color: #1d1d1b;\n  font-size: 24px;\n  line-height: 36px;\n  padding: 0;\n  margin: 0;\n}\n.purchase[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   th[_ngcontent-%COMP%] {\n  padding: 0rem 0.5rem;\n}\n.purchase[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   td[_ngcontent-%COMP%] {\n  padding: 1rem 0.5rem;\n  vertical-align: middle;\n}\n.cart-product-img[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 60px;\n  height: 90px;\n  -o-object-fit: contain;\n     object-fit: contain;\n}\n.cart-header-det[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 26px;\n  line-height: 36px;\n  color: #1d1d1b;\n  margin: 0;\n  padding: 0;\n}\n.cart-header-det[_ngcontent-%COMP%]   p[_ngcontent-%COMP%], .cart-det[_ngcontent-%COMP%] {\n  font-size: 22px;\n  line-height: 26px;\n  color: #bc8033;\n  margin-bottom: 0;\n}\n.cart-det[_ngcontent-%COMP%] {\n  color: #1d1d1b;\n  padding: 0px;\n}\n.cart-product-img[_ngcontent-%COMP%] {\n  margin-right: 20px;\n}\ntd[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n@media (max-width: 767px) {\n  .purchase[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%] {\n    font-size: 16px;\n    line-height: 26px;\n  }\n\n  .cart-header-det[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n    font-size: 16px;\n    line-height: 26px;\n  }\n\n  .cart-header-det[_ngcontent-%COMP%]   p[_ngcontent-%COMP%], .cart-det[_ngcontent-%COMP%] {\n    font-size: 14px;\n    line-height: 14px;\n    margin-bottom: 5px;\n  }\n\n  .cart-det[_ngcontent-%COMP%] {\n    padding: 0px 10px;\n  }\n\n  .cart-product-img[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n    width: 30px;\n    height: 56px;\n    -o-object-fit: contain;\n       object-fit: contain;\n  }\n\n  .container-fluid[_ngcontent-%COMP%] {\n    width: 100%;\n    padding-right: 10px;\n    padding-left: 10px;\n    margin: 0 auto;\n  }\n\n  .cart-product-img[_ngcontent-%COMP%] {\n    margin-right: 0px;\n  }\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ "PGnz":
/*!*******************************************************************!*\
  !*** ./src/app/shared/forgotpassword/forgotpassword.component.ts ***!
  \*******************************************************************/
/*! exports provided: ForgotpasswordComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ForgotpasswordComponent", function() { return ForgotpasswordComponent; });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "ofXK");




function ForgotpasswordComponent_ng_template_0_div_21_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1, "Mobile number is required");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} }
function ForgotpasswordComponent_ng_template_0_div_21_div_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1, "Mobile number must be at least 10 numbers");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} }
function ForgotpasswordComponent_ng_template_0_div_21_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, ForgotpasswordComponent_ng_template_0_div_21_div_1_Template, 2, 0, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, ForgotpasswordComponent_ng_template_0_div_21_div_2_Template, 2, 0, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r3.f.phone.errors.required);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r3.f.phone.errors.minlength);
} }
const _c0 = function (a0) { return { "is-invalid": a0 }; };
function ForgotpasswordComponent_ng_template_0_Template(rf, ctx) { if (rf & 1) {
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "span", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3, "\u00D7");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "h4");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](8, "Forgot password ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](9, "form", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngSubmit", function ForgotpasswordComponent_ng_template_0_Template_form_ngSubmit_9_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r6.forgotpassword(ctx_r6.forgotpass.value); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](14, "Mobile Number");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](15, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "div", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "span", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](18, "img", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](19, "input", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](20, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](21, ForgotpasswordComponent_ng_template_0_div_21_Template, 3, 2, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](22, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](23, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](24, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](25, "Password");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](26, "input", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](27, "div", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](28, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](29, " Update Password");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("formGroup", ctx_r1.forgotpass);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](4, _c0, ctx_r1.submitted && ctx_r1.f.phone.errors));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r1.submitted && ctx_r1.f.phone.errors);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](6, _c0, ctx_r1.submitted && ctx_r1.f.password.errors));
} }
class ForgotpasswordComponent {
    constructor(formBuilder) {
        this.formBuilder = formBuilder;
        this.submitted = false;
    }
    /**
* login controls
*/
    get f() {
        return this.forgotpass.controls;
    }
    ngOnInit() {
        this.forgotpass = this.formBuilder.group({
            phone: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_0__["Validators"].required],
            passwords: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_0__["Validators"].required],
            device_token: ['sp-eatzilla-web'],
            login_type: ['0'],
            device_type: ['web'],
        });
    }
    forgotpassword(forgotpass) {
        this.submitted = true;
        const phoneWithCode = `971${forgotpass.phone}`;
        forgotpass.phone = phoneWithCode;
        if (this.forgotpass.invalid) {
            return;
        }
    }
}
ForgotpasswordComponent.ɵfac = function ForgotpasswordComponent_Factory(t) { return new (t || ForgotpasswordComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_0__["FormBuilder"])); };
ForgotpasswordComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: ForgotpasswordComponent, selectors: [["app-forgotpassword"]], decls: 2, vars: 0, consts: [["class", "modal-dialog-centered"], ["login", ""], [1, "modal-body"], ["type", "button", "aria-label", "Close", 1, "close"], ["aria-hidden", "true"], [1, "container", "userlogin"], [1, "row", "mb-4"], [1, "col-lg-12", "text-center"], [3, "formGroup", "ngSubmit"], [1, "row"], [1, "col-lg-12"], [1, "form-group"], [1, "w-100"], [1, "input-group"], ["id", "basic-addon1", 1, "input-group-text"], ["src", "assets/images/icons/uae_flag.png", "alt", "product", 1, "img-fluid"], ["type", "text", "id", "phone", "formControlName", "phone", 1, "form-control", 3, "ngClass"], ["id", "error-msg", 1, "text-danger"], ["class", "text-danger", 4, "ngIf"], [1, "col-lg-12", "mb-3"], ["type", "password", "formControlName", "password", 1, "form-control", 3, "ngClass"], [1, "col-lg-12", "d-flex", "align-items-center", "justify-content-around"], ["type", "submit", 1, "btn", "btn-continue"], [1, "text-danger"], [4, "ngIf"]], template: function ForgotpasswordComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, ForgotpasswordComponent_ng_template_0_Template, 30, 8, "ng-template", 0, 1, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
    } }, directives: [_angular_forms__WEBPACK_IMPORTED_MODULE_0__["ɵangular_packages_forms_forms_y"], _angular_forms__WEBPACK_IMPORTED_MODULE_0__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_0__["FormGroupDirective"], _angular_forms__WEBPACK_IMPORTED_MODULE_0__["DefaultValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_0__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_0__["FormControlName"], _angular_common__WEBPACK_IMPORTED_MODULE_2__["NgClass"], _angular_common__WEBPACK_IMPORTED_MODULE_2__["NgIf"]], styles: ["@font-face {\n  font-family: \"HomepageBaukasten-Book\";\n  src: local(\"HomepageBaukasten-Book\"), url('HomepageBaukasten-Book.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist521BT-Roman\";\n  src: local(\"Humanist521BT-Roman\"), url('Humanist521BT-Roman.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanB\";\n  src: local(\"Humanist777BT-RomanB\"), url('Humanist777BT-RomanB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n  src: local(\"Humanist777BT-BoldCondensedB\"), url('Humanist777BT-BoldCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n  src: local(\"Humanist777BT-RomanCondensedB\"), url('Humanist777BT-RomanCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n  src: local(\"Humanist777BT-BlackCondensedB\"), url('Humanist777BT-BlackCondensed.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist777LightBT\";\n  src: local(\"Humanist777LightBT\"), url('Humanist777LightBT.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"HelveticaNeue-Regular\";\n  src: local(\"HelveticaNeue-Regular\"), url('HelveticaNeue-Regular.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Black\";\n  src: local(\"Tajawal-Black\"), url('Tajawal-Black.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Bold\";\n  src: local(\"Tajawal-Bold\"), url('Tajawal-Bold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraBold\";\n  src: local(\"Tajawal-ExtraBold\"), url('Tajawal-ExtraBold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraLight\";\n  src: local(\"Tajawal-ExtraLight\"), url('Tajawal-ExtraLight.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Light\";\n  src: local(\"Tajawal-Light\"), url('Tajawal-Light.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Medium\";\n  src: local(\"Tajawal-Medium\"), url('Tajawal-Medium.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Regular\";\n  src: local(\"Tajawal-Regular\"), url('Tajawal-Regular.ttf') format(\"truetype\");\n}\n.font-HomepageBaukasten-Book[_ngcontent-%COMP%] {\n  font-family: \"HomepageBaukasten-Book\";\n}\n.font-Humanist521BT-Roman[_ngcontent-%COMP%] {\n  font-family: \"Humanist521BT-Roman\";\n}\n.font-Humanist777BT-RomanB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanB\";\n}\n.font-Humanist777BT-BoldCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n}\n.font-Humanist777BT-RomanCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n}\n.font-Humanist777BT-BlackCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n}\n.font-Humanist777LightBT[_ngcontent-%COMP%] {\n  font-family: \"Humanist777LightBT\" !important;\n}\n.font-HelveticaNeue-Regular[_ngcontent-%COMP%] {\n  font-family: \"HelveticaNeue-Regular\";\n}\n.font-Tajawal-Black[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Black\";\n}\n.font-Tajawal-Bold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Bold\";\n}\n.font-Tajawal-ExtraBold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraBold\";\n}\n.font-Tajawal-ExtraLight[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraLight\";\n}\n.font-Tajawal-Light[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Light\";\n}\n.font-Tajawal-Medium[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Medium\";\n}\n.font-Tajawal-Regular[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Regular\";\n}\na[_ngcontent-%COMP%]:hover {\n  color: initial;\n  text-decoration: none;\n}\n.border-color[_ngcontent-%COMP%] {\n  border-color: #dedede !important;\n}\n.container-fluid[_ngcontent-%COMP%] {\n  width: 100%;\n  padding-right: 25px;\n  padding-left: 25px;\n  margin-right: auto;\n  margin-left: auto;\n}\n.full-width[_ngcontent-%COMP%], .aboutUsPage[_ngcontent-%COMP%], .humanKnowCoffee[_ngcontent-%COMP%], .benefitsAndHarms[_ngcontent-%COMP%], .preparationPage[_ngcontent-%COMP%], .galleryPage[_ngcontent-%COMP%], .productPage[_ngcontent-%COMP%] {\n  max-width: 100%;\n  margin: 0 auto;\n}\na[_ngcontent-%COMP%] {\n  color: initial;\n  text-decoration: none;\n  background-color: transparent;\n}\n.br-1px[_ngcontent-%COMP%] {\n  border-right: 1px solid;\n}\n.ngx-gallery-icon[_ngcontent-%COMP%] {\n  color: red;\n  background: blue;\n}\ngallery-item[_ngcontent-%COMP%] {\n  padding: 2em;\n  border: 2px solid #ebc850 !important;\n}\n.ml-1em[_ngcontent-%COMP%] {\n  margin-left: 1em;\n}\n.border[_ngcontent-%COMP%] {\n  border: 1px solid;\n}\n.roundedCorner[_ngcontent-%COMP%] {\n  border-radius: 30px;\n}\n.mt-1em[_ngcontent-%COMP%] {\n  margin-top: 1em;\n}\n.mt-2em[_ngcontent-%COMP%] {\n  margin-top: 2em;\n}\n.pr-0[_ngcontent-%COMP%] {\n  padding-right: 0;\n}\n.pl-0[_ngcontent-%COMP%] {\n  padding-left: 0;\n}\n.section[_ngcontent-%COMP%] {\n  padding: 2em 0;\n}\n.d-flex[_ngcontent-%COMP%] {\n  display: flex;\n}\n.justify-center[_ngcontent-%COMP%] {\n  justify-content: center;\n}\n.align-center[_ngcontent-%COMP%] {\n  align-items: center;\n}\ngallery-thumbs[_ngcontent-%COMP%] {\n  display: none !important;\n}\n.select-gender[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\n.select-gender[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  text-indent: 15px;\n  text-overflow: \"\";\n  width: 90%;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  padding: 2px 2px 2px 2px;\n  border: none;\n  background: transparent url(\"http://cdn1.iconfinder.com/data/icons/cc_mono_icon_set/blacks/16x16/br_down.png\") no-repeat 230px !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%] {\n  display: flex !important;\n  align-items: center !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%]   .modal-dialog[_ngcontent-%COMP%] {\n  flex-grow: 1;\n}\n.our-branch-address[_ngcontent-%COMP%]   .accordion[_ngcontent-%COMP%]    > .card[_ngcontent-%COMP%]    > .card-header[_ngcontent-%COMP%] {\n  padding: 0;\n  background-color: #ebc850 !important;\n}\n.our-branch-address[_ngcontent-%COMP%]   .panelTitle[_ngcontent-%COMP%] {\n  font-size: 1.25rem;\n  line-height: 1.25rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%] {\n  font-weight: 500;\n  color: #1d1d1b;\n  font-size: 1.5rem;\n  line-height: 2.5rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%]:focus {\n  box-shadow: none !important;\n  text-decoration: none;\n}\n.g-btn-close[_ngcontent-%COMP%] {\n  display: none;\n}\npath[_ngcontent-%COMP%] {\n  fill: #bc8033;\n}\n@media (min-width: 767px) {\n  .navbar-expand-md[_ngcontent-%COMP%]   .navbar-nav[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n    padding-right: 0.3rem !important;\n    padding-left: 0.3rem !important;\n    font-size: 16px !important;\n  }\n}\n@media (max-width: 2560px) {\n  .webView[_ngcontent-%COMP%] {\n    background-size: cover !important;\n  }\n}\n.direction_ltr[_ngcontent-%COMP%] {\n  direction: ltr !important;\n}\n.iti[_ngcontent-%COMP%] {\n  width: 100%;\n}\nbutton.close[_ngcontent-%COMP%] {\n  padding: 0.5em !important;\n  border: none !important;\n}\n.btn_primary[_ngcontent-%COMP%] {\n  background: #432919;\n  color: #ebc850;\n}\ninput[_ngcontent-%COMP%]::-webkit-outer-spin-button, input[_ngcontent-%COMP%]::-webkit-inner-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n\ninput[type=number][_ngcontent-%COMP%] {\n  -moz-appearance: textfield;\n}\n.text-primary[_ngcontent-%COMP%] {\n  color: #ebc850 !important;\n}\n.min-height-10[_ngcontent-%COMP%] {\n  min-height: 10em;\n}\n.pac-container[_ngcontent-%COMP%] {\n  background-color: #fff;\n  position: absolute !important;\n  z-index: 9999999999;\n  border-radius: 2px;\n  border-top: 0;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);\n  box-sizing: border-box;\n  overflow: hidden;\n  font-size: 16px;\n  color: #ebc850;\n}\n.pac-logo[_ngcontent-%COMP%]:after {\n  content: \"\";\n  padding: 1px 1px 1px 0;\n  height: 16px;\n  text-align: right;\n  display: block;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3.png);\n  background-position: right;\n  background-repeat: no-repeat;\n  background-size: 120px 14px;\n}\n.hdpi.pac-logo[_ngcontent-%COMP%]:after {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3_hdpi.png);\n}\n.pac-item[_ngcontent-%COMP%] {\n  cursor: default;\n  padding: 4px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n  line-height: 30px;\n  text-align: left;\n  border-top: 0;\n  font-size: 13px;\n  color: #999;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n}\n.pac-item[_ngcontent-%COMP%]:hover {\n  background-color: #fafafa;\n}\n.pac-item-selected[_ngcontent-%COMP%], .pac-item-selected[_ngcontent-%COMP%]:hover {\n  background-color: #ebf2fe;\n}\n.pac-matched[_ngcontent-%COMP%] {\n  font-weight: 700;\n}\n.pac-item-query[_ngcontent-%COMP%] {\n  font-size: 16px;\n  padding-right: 3px;\n  color: #ebc850;\n}\n.pac-icon[_ngcontent-%COMP%] {\n  width: 15px;\n  height: 20px;\n  margin-right: 7px;\n  margin-top: 6px;\n  display: inline-block;\n  vertical-align: top;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons.png);\n  background-size: 34px;\n}\n.hdpi[_ngcontent-%COMP%]   .pac-icon[_ngcontent-%COMP%] {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons_hdpi.png);\n}\n.pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -1px -1px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -18px -1px;\n}\n.pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -1px -161px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -18px -161px;\n}\n.pac-placeholder[_ngcontent-%COMP%] {\n  color: gray;\n}\n.form-control[_ngcontent-%COMP%]:focus {\n  box-shadow: 0 0 0 0.05rem #9f9f9f;\n}\n.page-link[_ngcontent-%COMP%] {\n  border-color: #432919 !important;\n  color: #432919 !important;\n}\n.page-item.active[_ngcontent-%COMP%]   .page-link[_ngcontent-%COMP%] {\n  background-color: #432919 !important;\n  border-color: #432919 !important;\n  color: #ebc850 !important;\n}\n.b-0[_ngcontent-%COMP%] {\n  bottom: 0px;\n}\n.loader_section[_ngcontent-%COMP%] {\n  display: flex;\n  height: 100vh;\n  align-items: center;\n}\n.loader[_ngcontent-%COMP%], .loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  background: #ebc850;\n  -webkit-animation: load1 1s infinite ease-in-out;\n  animation: load1 1s infinite ease-in-out;\n  width: 1em;\n  height: 4em;\n}\n.loader[_ngcontent-%COMP%] {\n  color: #ebc850;\n  text-indent: -9999em;\n  margin: 88px auto;\n  position: relative;\n  font-size: 11px;\n  transform: translateZ(0);\n  -webkit-animation-delay: -0.16s;\n  animation-delay: -0.16s;\n}\n.loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  position: absolute;\n  top: 0;\n  content: \"\";\n}\n.loader[_ngcontent-%COMP%]:before {\n  left: -1.5em;\n  -webkit-animation-delay: -0.32s;\n  animation-delay: -0.32s;\n}\n.loader[_ngcontent-%COMP%]:after {\n  left: 1.5em;\n}\n@-webkit-keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n@keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n.my-info[_ngcontent-%COMP%] {\n  background: rgba(29, 29, 27, 0.8);\n  width: 100%;\n  height: 100vh;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  align-self: flex-start;\n}\n.userlogin[_ngcontent-%COMP%] {\n  padding: 3em;\n  border: 1px solid #dedede;\n  background: #ffffff;\n  border-radius: 10px;\n}\n.userlogin[_ngcontent-%COMP%]   .btn-continue[_ngcontent-%COMP%] {\n  padding: 5px 30px;\n  font-size: 20px;\n  line-height: 30px;\n  color: #bc8033;\n  border: 1px solid transparent;\n  background: #432919;\n  border-radius: 30px;\n}\n.userlogin[_ngcontent-%COMP%]   .btn-continue[_ngcontent-%COMP%]:hover {\n  color: #bc8033;\n  transition: cubic-bezier(0.175, 0.885, 0.32, 1.275);\n}\n.userlogin[_ngcontent-%COMP%]   .pb[_ngcontent-%COMP%] {\n  padding-bottom: 15px;\n}\n.userlogin[_ngcontent-%COMP%]   .form-control[_ngcontent-%COMP%] {\n  border: 1px solid #9f9f9f;\n  border-radius: 0 !important;\n}\n.userlogin[_ngcontent-%COMP%]   .input-group-text[_ngcontent-%COMP%] {\n  justify-content: center;\n  padding: 0px !important;\n  background-color: unset;\n  border: 1px solid #9f9f9f;\n  border-radius: unset;\n}\n.userlogin[_ngcontent-%COMP%]   .input-group-text[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  height: 50%;\n}\n.userlogin[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 20px;\n  line-height: 36px;\n  color: #1d1d1b;\n}\n@media only screen and (max-width: 767px) {\n  .container-fluid[_ngcontent-%COMP%] {\n    padding-right: 15px;\n    padding-left: 15px;\n    margin: 0 auto;\n  }\n\n  .myinform-head[_ngcontent-%COMP%] {\n    margin: 20px 15px;\n  }\n\n  .banner-head[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n    font-size: 40px;\n  }\n\n  .breadcumbs[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n    font-size: 14px;\n  }\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ "Pfx7":
/*!****************************************************!*\
  !*** ./src/app/pages/sigunup/sigunup.component.ts ***!
  \****************************************************/
/*! exports provided: SigunupComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SigunupComponent", function() { return SigunupComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! sweetalert2/dist/sweetalert2.js */ "PdH4");
/* harmony import */ var sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var src_app_services_user_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/user.service */ "qfBg");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var src_app_services_storage_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/services/storage.service */ "n90K");
/* harmony import */ var src_app_services_translation_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! src/app/services/translation.service */ "ty2H");
/* harmony import */ var _shared_header_header_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../shared/header/header.component */ "320Y");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _shared_profile_form_profile_form_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../shared/profile-form/profile-form.component */ "8WL1");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");











/**
 * Signup Pages
 */
class SigunupComponent {
    /**
     * @constructor
     */
    constructor(userService, router, storageService, translationService) {
        this.userService = userService;
        this.router = router;
        this.storageService = storageService;
        this.translationService = translationService;
        window.scroll(0, 0);
    }
    /**
     * page initialization
     */
    ngOnInit() {
        setInterval(() => {
            this.lang = sessionStorage.getItem('language');
        }, 1000);
        // this.lang = sessionStorage.getItem('language');
    }
    /**
     * register
     * @param {object} registerForm
     */
    register(registerForm) {
        this.userService.register(registerForm).subscribe((response) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            if (response.status === true) {
                sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_1___default.a.fire({
                    icon: 'success',
                    title: yield this.translationService.translateText('TOAST.REGISTER_SUCCESS'),
                    confirmButtonColor: '#432919',
                    confirmButtonText: yield this.translationService.translateText('TOAST.OK'),
                    customClass: {
                        container: this.lang === 'AR' ? 'font-Tajawal-Light' : 'font-Humanist777LightBT',
                    },
                }).then((result) => {
                    this.storageService.setItem('profile', JSON.stringify(response));
                    this.lang === 'AR' ? this.router.navigate(['/ar']) : this.router.navigate(['/']);
                });
            }
            else {
                sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_1___default.a.fire({
                    icon: 'error',
                    title: yield this.translationService.translateText('TOAST.REGISTER_FAILED'),
                    text: this.lang === 'AR' ? response['message_ar'] : response['message'],
                    confirmButtonColor: '#432919',
                    confirmButtonText: yield this.translationService.translateText('TOAST.OK'),
                    customClass: {
                        container: this.lang === 'AR' ? 'font-Tajawal-Light' : 'font-Humanist777LightBT',
                    },
                });
            }
        }));
    }
}
SigunupComponent.ɵfac = function SigunupComponent_Factory(t) { return new (t || SigunupComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](src_app_services_user_service__WEBPACK_IMPORTED_MODULE_3__["UserService"]), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"]), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](src_app_services_storage_service__WEBPACK_IMPORTED_MODULE_5__["StorageService"]), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](src_app_services_translation_service__WEBPACK_IMPORTED_MODULE_6__["TranslationService"])); };
SigunupComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: SigunupComponent, selectors: [["app-sigunup"]], decls: 18, vars: 15, consts: [["setActive", "cart"], [1, "my-info"], [1, "container-fluid"], [1, "row"], [1, "col-lg-12"], [1, "banner"], [1, "banner-head", 3, "ngClass"], [1, "breadcumbs", 3, "ngClass"], [3, "buttonName", "submitChange"]], template: function SigunupComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "app-header", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](4, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](5, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](6, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](7, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](10, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](11, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](15, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](16, "app-profile-form", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("submitChange", function SigunupComponent_Template_app_profile_form_submitChange_16_listener($event) { return ctx.register($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](17, "~");
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanCondensedB");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](9, 7, "ACCOUNT.USER_ACCOUNT"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngClass", ctx.lang === "AR" ? "font-Tajawal-Regular" : "font-HomepageBaukasten-Book");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate3"]("", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](13, 9, "MENU.HOME"), " / ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](14, 11, "ACCOUNT.USER_ACCOUNT"), " / ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](15, 13, "ACCOUNT.REGISTER"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("buttonName", "ACCOUNT.REGISTER");
    } }, directives: [_shared_header_header_component__WEBPACK_IMPORTED_MODULE_7__["HeaderComponent"], _angular_common__WEBPACK_IMPORTED_MODULE_8__["NgClass"], _shared_profile_form_profile_form_component__WEBPACK_IMPORTED_MODULE_9__["ProfileFormComponent"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__["TranslatePipe"]], styles: ["@font-face {\n  font-family: \"HomepageBaukasten-Book\";\n  src: local(\"HomepageBaukasten-Book\"), url('HomepageBaukasten-Book.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist521BT-Roman\";\n  src: local(\"Humanist521BT-Roman\"), url('Humanist521BT-Roman.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanB\";\n  src: local(\"Humanist777BT-RomanB\"), url('Humanist777BT-RomanB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n  src: local(\"Humanist777BT-BoldCondensedB\"), url('Humanist777BT-BoldCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n  src: local(\"Humanist777BT-RomanCondensedB\"), url('Humanist777BT-RomanCondensedB.otf') format(\"opentype\");\n}\n@font-face {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n  src: local(\"Humanist777BT-BlackCondensedB\"), url('Humanist777BT-BlackCondensed.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Humanist777LightBT\";\n  src: local(\"Humanist777LightBT\"), url('Humanist777LightBT.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"HelveticaNeue-Regular\";\n  src: local(\"HelveticaNeue-Regular\"), url('HelveticaNeue-Regular.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Black\";\n  src: local(\"Tajawal-Black\"), url('Tajawal-Black.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Bold\";\n  src: local(\"Tajawal-Bold\"), url('Tajawal-Bold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraBold\";\n  src: local(\"Tajawal-ExtraBold\"), url('Tajawal-ExtraBold.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-ExtraLight\";\n  src: local(\"Tajawal-ExtraLight\"), url('Tajawal-ExtraLight.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Light\";\n  src: local(\"Tajawal-Light\"), url('Tajawal-Light.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Medium\";\n  src: local(\"Tajawal-Medium\"), url('Tajawal-Medium.ttf') format(\"truetype\");\n}\n@font-face {\n  font-family: \"Tajawal-Regular\";\n  src: local(\"Tajawal-Regular\"), url('Tajawal-Regular.ttf') format(\"truetype\");\n}\n.font-HomepageBaukasten-Book[_ngcontent-%COMP%] {\n  font-family: \"HomepageBaukasten-Book\";\n}\n.font-Humanist521BT-Roman[_ngcontent-%COMP%] {\n  font-family: \"Humanist521BT-Roman\";\n}\n.font-Humanist777BT-RomanB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanB\";\n}\n.font-Humanist777BT-BoldCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BoldCondensedB\";\n}\n.font-Humanist777BT-RomanCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-RomanCondensedB\";\n}\n.font-Humanist777BT-BlackCondensedB[_ngcontent-%COMP%] {\n  font-family: \"Humanist777BT-BlackCondensedB\";\n}\n.font-Humanist777LightBT[_ngcontent-%COMP%] {\n  font-family: \"Humanist777LightBT\" !important;\n}\n.font-HelveticaNeue-Regular[_ngcontent-%COMP%] {\n  font-family: \"HelveticaNeue-Regular\";\n}\n.font-Tajawal-Black[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Black\";\n}\n.font-Tajawal-Bold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Bold\";\n}\n.font-Tajawal-ExtraBold[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraBold\";\n}\n.font-Tajawal-ExtraLight[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-ExtraLight\";\n}\n.font-Tajawal-Light[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Light\";\n}\n.font-Tajawal-Medium[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Medium\";\n}\n.font-Tajawal-Regular[_ngcontent-%COMP%] {\n  font-family: \"Tajawal-Regular\";\n}\na[_ngcontent-%COMP%]:hover {\n  color: initial;\n  text-decoration: none;\n}\n.border-color[_ngcontent-%COMP%] {\n  border-color: #dedede !important;\n}\n.container-fluid[_ngcontent-%COMP%] {\n  width: 100%;\n  padding-right: 25px;\n  padding-left: 25px;\n  margin-right: auto;\n  margin-left: auto;\n}\n.full-width[_ngcontent-%COMP%], .aboutUsPage[_ngcontent-%COMP%], .humanKnowCoffee[_ngcontent-%COMP%], .benefitsAndHarms[_ngcontent-%COMP%], .preparationPage[_ngcontent-%COMP%], .galleryPage[_ngcontent-%COMP%], .productPage[_ngcontent-%COMP%] {\n  max-width: 100%;\n  margin: 0 auto;\n}\na[_ngcontent-%COMP%] {\n  color: initial;\n  text-decoration: none;\n  background-color: transparent;\n}\n.br-1px[_ngcontent-%COMP%] {\n  border-right: 1px solid;\n}\n.ngx-gallery-icon[_ngcontent-%COMP%] {\n  color: red;\n  background: blue;\n}\ngallery-item[_ngcontent-%COMP%] {\n  padding: 2em;\n  border: 2px solid #ebc850 !important;\n}\n.ml-1em[_ngcontent-%COMP%] {\n  margin-left: 1em;\n}\n.border[_ngcontent-%COMP%] {\n  border: 1px solid;\n}\n.roundedCorner[_ngcontent-%COMP%] {\n  border-radius: 30px;\n}\n.mt-1em[_ngcontent-%COMP%] {\n  margin-top: 1em;\n}\n.mt-2em[_ngcontent-%COMP%] {\n  margin-top: 2em;\n}\n.pr-0[_ngcontent-%COMP%] {\n  padding-right: 0;\n}\n.pl-0[_ngcontent-%COMP%] {\n  padding-left: 0;\n}\n.section[_ngcontent-%COMP%] {\n  padding: 2em 0;\n}\n.d-flex[_ngcontent-%COMP%] {\n  display: flex;\n}\n.justify-center[_ngcontent-%COMP%] {\n  justify-content: center;\n}\n.align-center[_ngcontent-%COMP%] {\n  align-items: center;\n}\ngallery-thumbs[_ngcontent-%COMP%] {\n  display: none !important;\n}\n.select-gender[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\n.select-gender[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  text-indent: 15px;\n  text-overflow: \"\";\n  width: 90%;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  padding: 2px 2px 2px 2px;\n  border: none;\n  background: transparent url(\"http://cdn1.iconfinder.com/data/icons/cc_mono_icon_set/blacks/16x16/br_down.png\") no-repeat 230px !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%] {\n  display: flex !important;\n  align-items: center !important;\n}\n.modal-open[_ngcontent-%COMP%]   .modal[_ngcontent-%COMP%]   .modal-dialog[_ngcontent-%COMP%] {\n  flex-grow: 1;\n}\n.our-branch-address[_ngcontent-%COMP%]   .accordion[_ngcontent-%COMP%]    > .card[_ngcontent-%COMP%]    > .card-header[_ngcontent-%COMP%] {\n  padding: 0;\n  background-color: #ebc850 !important;\n}\n.our-branch-address[_ngcontent-%COMP%]   .panelTitle[_ngcontent-%COMP%] {\n  font-size: 1.25rem;\n  line-height: 1.25rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%] {\n  font-weight: 500;\n  color: #1d1d1b;\n  font-size: 1.5rem;\n  line-height: 2.5rem;\n}\n.our-branch-address[_ngcontent-%COMP%]   .btn.btn-link[_ngcontent-%COMP%]:focus {\n  box-shadow: none !important;\n  text-decoration: none;\n}\n.g-btn-close[_ngcontent-%COMP%] {\n  display: none;\n}\npath[_ngcontent-%COMP%] {\n  fill: #bc8033;\n}\n@media (min-width: 767px) {\n  .navbar-expand-md[_ngcontent-%COMP%]   .navbar-nav[_ngcontent-%COMP%]   .nav-link[_ngcontent-%COMP%] {\n    padding-right: 0.3rem !important;\n    padding-left: 0.3rem !important;\n    font-size: 16px !important;\n  }\n}\n@media (max-width: 2560px) {\n  .webView[_ngcontent-%COMP%] {\n    background-size: cover !important;\n  }\n}\n.direction_ltr[_ngcontent-%COMP%] {\n  direction: ltr !important;\n}\n.iti[_ngcontent-%COMP%] {\n  width: 100%;\n}\nbutton.close[_ngcontent-%COMP%] {\n  padding: 0.5em !important;\n  border: none !important;\n}\n.btn_primary[_ngcontent-%COMP%] {\n  background: #432919;\n  color: #ebc850;\n}\ninput[_ngcontent-%COMP%]::-webkit-outer-spin-button, input[_ngcontent-%COMP%]::-webkit-inner-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n\ninput[type=number][_ngcontent-%COMP%] {\n  -moz-appearance: textfield;\n}\n.text-primary[_ngcontent-%COMP%] {\n  color: #ebc850 !important;\n}\n.min-height-10[_ngcontent-%COMP%] {\n  min-height: 10em;\n}\n.pac-container[_ngcontent-%COMP%] {\n  background-color: #fff;\n  position: absolute !important;\n  z-index: 9999999999;\n  border-radius: 2px;\n  border-top: 0;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);\n  box-sizing: border-box;\n  overflow: hidden;\n  font-size: 16px;\n  color: #ebc850;\n}\n.pac-logo[_ngcontent-%COMP%]:after {\n  content: \"\";\n  padding: 1px 1px 1px 0;\n  height: 16px;\n  text-align: right;\n  display: block;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3.png);\n  background-position: right;\n  background-repeat: no-repeat;\n  background-size: 120px 14px;\n}\n.hdpi.pac-logo[_ngcontent-%COMP%]:after {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/powered-by-google-on-white3_hdpi.png);\n}\n.pac-item[_ngcontent-%COMP%] {\n  cursor: default;\n  padding: 4px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n  line-height: 30px;\n  text-align: left;\n  border-top: 0;\n  font-size: 13px;\n  color: #999;\n  font-family: Roboto, \"Helvetica Neue\", sans-serif;\n}\n.pac-item[_ngcontent-%COMP%]:hover {\n  background-color: #fafafa;\n}\n.pac-item-selected[_ngcontent-%COMP%], .pac-item-selected[_ngcontent-%COMP%]:hover {\n  background-color: #ebf2fe;\n}\n.pac-matched[_ngcontent-%COMP%] {\n  font-weight: 700;\n}\n.pac-item-query[_ngcontent-%COMP%] {\n  font-size: 16px;\n  padding-right: 3px;\n  color: #ebc850;\n}\n.pac-icon[_ngcontent-%COMP%] {\n  width: 15px;\n  height: 20px;\n  margin-right: 7px;\n  margin-top: 6px;\n  display: inline-block;\n  vertical-align: top;\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons.png);\n  background-size: 34px;\n}\n.hdpi[_ngcontent-%COMP%]   .pac-icon[_ngcontent-%COMP%] {\n  background-image: url(https://maps.gstatic.com/mapfiles/api-3/images/autocomplete-icons_hdpi.png);\n}\n.pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -1px -1px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-search[_ngcontent-%COMP%] {\n  background-position: -18px -1px;\n}\n.pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -1px -161px;\n}\n.pac-item-selected[_ngcontent-%COMP%]   .pac-icon-marker[_ngcontent-%COMP%] {\n  background-position: -18px -161px;\n}\n.pac-placeholder[_ngcontent-%COMP%] {\n  color: gray;\n}\n.form-control[_ngcontent-%COMP%]:focus {\n  box-shadow: 0 0 0 0.05rem #9f9f9f;\n}\n.page-link[_ngcontent-%COMP%] {\n  border-color: #432919 !important;\n  color: #432919 !important;\n}\n.page-item.active[_ngcontent-%COMP%]   .page-link[_ngcontent-%COMP%] {\n  background-color: #432919 !important;\n  border-color: #432919 !important;\n  color: #ebc850 !important;\n}\n.b-0[_ngcontent-%COMP%] {\n  bottom: 0px;\n}\n.loader_section[_ngcontent-%COMP%] {\n  display: flex;\n  height: 100vh;\n  align-items: center;\n}\n.loader[_ngcontent-%COMP%], .loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  background: #ebc850;\n  -webkit-animation: load1 1s infinite ease-in-out;\n  animation: load1 1s infinite ease-in-out;\n  width: 1em;\n  height: 4em;\n}\n.loader[_ngcontent-%COMP%] {\n  color: #ebc850;\n  text-indent: -9999em;\n  margin: 88px auto;\n  position: relative;\n  font-size: 11px;\n  transform: translateZ(0);\n  -webkit-animation-delay: -0.16s;\n  animation-delay: -0.16s;\n}\n.loader[_ngcontent-%COMP%]:before, .loader[_ngcontent-%COMP%]:after {\n  position: absolute;\n  top: 0;\n  content: \"\";\n}\n.loader[_ngcontent-%COMP%]:before {\n  left: -1.5em;\n  -webkit-animation-delay: -0.32s;\n  animation-delay: -0.32s;\n}\n.loader[_ngcontent-%COMP%]:after {\n  left: 1.5em;\n}\n@-webkit-keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n@keyframes load1 {\n  0%, 80%, 100% {\n    box-shadow: 0 0;\n    height: 4em;\n  }\n  40% {\n    box-shadow: 0 -2em;\n    height: 5em;\n  }\n}\n.my-info[_ngcontent-%COMP%] {\n  border-top: 1px solid #1d1d1b;\n}\n.banner-head[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 50px;\n  line-height: 80px;\n  color: #1d1d1b;\n  text-transform: capitalize;\n  margin: 0;\n}\n.breadcumbs[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  font-size: 20px;\n  line-height: 40px;\n  text-align: right;\n  color: #9f9f9f;\n}\n.banner[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  flex-direction: row;\n  flex-wrap: wrap;\n}\nlabel.col-form-label[_ngcontent-%COMP%] {\n  font-size: 26px;\n  line-height: 36px;\n  color: #1d1d1b;\n  font-family: Humanist777BT-RomanCondensedB;\n}\n@media only screen and (max-width: 767px) {\n  .container-fluid[_ngcontent-%COMP%] {\n    padding-right: 15px;\n    padding-left: 15px;\n    margin: 0 auto;\n  }\n\n  .myinform-head[_ngcontent-%COMP%] {\n    margin: 20px 15px;\n  }\n\n  label.col-form-label[_ngcontent-%COMP%] {\n    font-size: 20px;\n    line-height: 36px;\n    color: #1d1d1b;\n    font-family: Humanist777BT-RomanCondensedB;\n  }\n\n  .banner-head[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n    font-size: 40px;\n  }\n\n  .breadcumbs[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n    font-size: 14px;\n  }\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ "SLVn":
/*!******************************************************************!*\
  !*** ./src/app/pages/single-product/single-product.component.ts ***!
  \******************************************************************/
/*! exports provided: SingleProductComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SingleProductComponent", function() { return SingleProductComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "LvDl");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! sweetalert2/dist/sweetalert2.js */ "PdH4");
/* harmony import */ var sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var src_app_services_product_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/services/product.service */ "Gdn9");
/* harmony import */ var _ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ng-bootstrap/ng-bootstrap */ "1kSV");
/* harmony import */ var src_app_services_modal_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! src/app/services/modal.service */ "VQPA");
/* harmony import */ var src_app_services_storage_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! src/app/services/storage.service */ "n90K");
/* harmony import */ var src_app_services_address_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! src/app/services/address.service */ "CVMR");
/* harmony import */ var src_app_services_translation_service__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! src/app/services/translation.service */ "ty2H");
/* harmony import */ var _shared_header_header_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../shared/header/header.component */ "320Y");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _shared_address_address_component__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../shared/address/address.component */ "YBnm");
/* harmony import */ var _shared_review_review_component__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../shared/review/review.component */ "+z6I");
/* harmony import */ var _shared_footer_footer_component__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../shared/footer/footer.component */ "jQpT");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");


















function SingleProductComponent_p_50_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "span", 80);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](5, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate2"]("", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 4, "HOME.AED"), " ", ctx_r0.food.price, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r0.lang === "AR" ? "small-font-ar" : "small-font");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](5, 6, "HOME.VAT_INC"), " ");
} }
function SingleProductComponent_p_51_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "span", 80);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](5, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate2"](" ", ctx_r1.food.price, " ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 4, "HOME.AED"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r1.lang === "AR" ? "small-font-ar" : "small-font");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](5, 6, "HOME.VAT_INC"), " ");
} }
function SingleProductComponent_div_72_span_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](1, "img", 86);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} }
function SingleProductComponent_div_72_span_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](1, "img", 87);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} }
function SingleProductComponent_div_72_span_8_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"]("(", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 1, "SINGLE_PRODUCT.MIN_MAX"), " 1)");
} }
function SingleProductComponent_div_72_span_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const category_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate2"]("(", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 2, "SINGLE_PRODUCT.MIN_MAX"), " ", category_r12.min, ")");
} }
function SingleProductComponent_div_72_div_11_input_2_Template(rf, ctx) { if (rf & 1) {
    const _r25 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "input", 94);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function SingleProductComponent_div_72_div_11_input_2_Template_input_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r25); const choice_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().$implicit; const categoryIndex_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().index; const ctx_r23 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return ctx_r23.setChoice(choice_r20, categoryIndex_r13); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const choice_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().$implicit;
    const category_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().$implicit;
    const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("value", choice_r20.price);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate2"]("name", "", category_r12.name, "", choice_r20.id, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate2"]("id", "", category_r12.name, "", choice_r20.id, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("checked", ctx_r21.checkChoiceSelected(choice_r20));
} }
function SingleProductComponent_div_72_div_11_input_3_Template(rf, ctx) { if (rf & 1) {
    const _r31 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "input", 95);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function SingleProductComponent_div_72_div_11_input_3_Template_input_click_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r31); const choice_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().$implicit; const categoryIndex_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().index; const ctx_r29 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return ctx_r29.setChoices($event, choice_r20, categoryIndex_r13); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const choice_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().$implicit;
    const category_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().$implicit;
    const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("value", choice_r20.price);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate2"]("name", "", category_r12.name, "", choice_r20.id, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate2"]("id", "", category_r12.name, "", choice_r20.id, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("checked", ctx_r22.checkChoiceSelected(choice_r20));
} }
function SingleProductComponent_div_72_div_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 88);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "div", 89);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](2, SingleProductComponent_div_72_div_11_input_2_Template, 1, 6, "input", 90);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](3, SingleProductComponent_div_72_div_11_input_3_Template, 1, 6, "input", 91);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](4, "label", 92);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](6, "span", 93);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const choice_r20 = ctx.$implicit;
    const category_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().$implicit;
    const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", category_r12.max == 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", category_r12.max > 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r18.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-RomanB");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", ctx_r18.lang === "AR" ? choice_r20.ar_name : choice_r20.name, " ");
} }
function SingleProductComponent_div_72_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 81);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "div", 82);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](2, "div", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "div", 83);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](4, SingleProductComponent_div_72_span_4_Template, 2, 0, "span", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](5, SingleProductComponent_div_72_span_5_Template, 2, 0, "span", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](7, "span", 84);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](8, SingleProductComponent_div_72_span_8_Template, 3, 3, "span", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](9, SingleProductComponent_div_72_span_9_Template, 3, 4, "span", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](10, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](11, SingleProductComponent_div_72_div_11_Template, 7, 4, "div", 85);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const category_r12 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r2.lang === "AR" ? "font-Tajawal-Black" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", category_r12.canProceed === false);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", category_r12.canProceed === true);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", ctx_r2.lang === "AR" ? category_r12.ar_name : category_r12.name, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r2.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", category_r12.min == 1 && category_r12.max == 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", category_r12.max > 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", category_r12.choice);
} }
function SingleProductComponent_span_77_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "span", 96);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r3.lang === "AR" ? "font-Tajawal-Black price-title-ar" : "font-Humanist777BT-BlackCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 2, "SINGLE_PRODUCT.PRICE"), ":");
} }
function SingleProductComponent_span_78_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "span", 97);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "span", 98);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](5, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate2"]("", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 4, "HOME.AED"), " ", ctx_r4.food.itemTotal, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r4.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777BT-LightB");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](5, 6, "HOME.VAT_INC"));
} }
function SingleProductComponent_span_79_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "span", 99);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "span", 98);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](5, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate2"](" ", ctx_r5.food.itemTotal, " ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 4, "HOME.AED"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r5.lang === "AR" ? "font-Tajawal-Bold" : "font-Humanist777BT-LightB");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](5, 6, "HOME.VAT_INC"));
} }
function SingleProductComponent_div_185_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 100);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "div", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](2, "div", 101);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "h3");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](5, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r6.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](5, 2, "REVIEW.NO_REVIEWS"));
} }
function SingleProductComponent_div_186_tr_16_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](2, "div", 107);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](4, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](6, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](7, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](8, "ngb-rating", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("rateChange", function SingleProductComponent_div_186_tr_16_Template_ngb_rating_rateChange_8_listener($event) { const item_r37 = ctx.$implicit; return item_r37.rating = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](9, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](10, "div", 108);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](11, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](12);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const item_r37 = ctx.$implicit;
    const ctx_r36 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2);
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](192);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", item_r37.name, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](item_r37.updated_at);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("rate", item_r37.rating)("starTemplate", _r10)("readonly", true)("max", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r36.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](item_r37.comment);
} }
function SingleProductComponent_div_186_Template(rf, ctx) { if (rf & 1) {
    const _r40 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 102);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "table", 103);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](2, "thead");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](5, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](6, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](8, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](9, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](11, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](12, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](14, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](15, "tbody");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](16, SingleProductComponent_div_186_tr_16_Template, 13, 8, "tr", 104);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](17, "slice");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](18, "div", 105);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](19, "ngb-pagination", 106);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("pageChange", function SingleProductComponent_div_186_Template_ngb_pagination_pageChange_19_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r40); const ctx_r39 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return ctx_r39.page = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r7.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](5, 9, "REVIEW.NAME"));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](8, 11, "REVIEW.DATE"));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](11, 13, "REVIEW.RATE"));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](14, 15, "REVIEW.COMMENTS"));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind3"](17, 17, ctx_r7.review, (ctx_r7.page - 1) * ctx_r7.pageSize, (ctx_r7.page - 1) * ctx_r7.pageSize + ctx_r7.pageSize));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("collectionSize", ctx_r7.review == null ? null : ctx_r7.review.length)("pageSize", ctx_r7.pageSize)("page", ctx_r7.page);
} }
function SingleProductComponent_ng_template_187_Template(rf, ctx) { if (rf & 1) {
    const _r43 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 109);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "div", 110);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](2, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "div", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](4, "h4", 80);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](6, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](7, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](8, "div", 111);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](9, "div", 112);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](10, "a", 113);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function SingleProductComponent_ng_template_187_Template_a_click_10_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r43); const ctx_r42 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return ctx_r42.login(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](12, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](13, "div", 111);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](14, "div", 112);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](15, "a", 113);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function SingleProductComponent_ng_template_187_Template_a_click_15_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r43); const ctx_r44 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return ctx_r44.signup(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](16);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](17, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r9.lang === "AR" ? "font-Tajawal-Medium" : "font-Humanist777BT-RomanCondensedB");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](6, 6, "SINGLE_PRODUCT.YOU_SHOULD_LOGIN_TO_YOUR_ACCOUNT_BEFORE_YOU_CONTINUE."));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r9.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777LightBT");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](12, 8, "MENU.LOGIN"));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngClass", ctx_r9.lang === "AR" ? "font-Tajawal-Regular" : "font-Humanist777LightBT");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](17, 10, "MENU.SIGN_IN"));
} }
function SingleProductComponent_ng_template_191_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "span", 114);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "span", 115);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](2, "\u2605");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](3, "\u2605 ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const fill_r45 = ctx.fill;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵclassProp"]("full", fill_r45 === 100);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵstyleProp"]("width", fill_r45, "%");
} }
const _c0 = function () { return ["/ar"]; };
const _c1 = function () { return ["/"]; };
const _c2 = function () { return ["/ar/product"]; };
const _c3 = function () { return ["/product"]; };
/** *
 * SingleProductComponent
 */
class SingleProductComponent {
    /**
     * constructor
     */
    constructor(route, router, productService, modalService, setModalService, storageService, addressService, translationService) {
        this.route = route;
        this.router = router;
        this.productService = productService;
        this.modalService = modalService;
        this.setModalService = setModalService;
        this.storageService = storageService;
        this.addressService = addressService;
        this.translationService = translationService;
        this.closeResult = '';
        this.page = 1;
        this.pageSize = 5;
        this.food = {};
        this.submitted = false;
        this.profile = {};
        this.defaultAddress = {};
        this.cartItem = [];
        this.quantity = 1;
        this.gramQuantity = 0;
        window.scroll(0, 0);
    }
    /**
     * open modal
     * @param {string} content
     */
    open(content) {
        this.closemodal = this.modalService.open(content, { ariaLabelledBy: 'modal-basic-title' });
    }
    /**
     * open login modal
     */
    login() {
        this.closemodal.close();
        this.setModalService.setLoginModalStatus({
            isLoginModalOpen: true,
        });
    }
    /**
     * Navigate to register
     */
    signup() {
        this.closemodal.close();
        this.setModalService.setLoginModalStatus({
            isLoginModalOpen: false,
        });
        this.router.navigate(['/register']);
    }
    /**
     * scroll down
     */
    goToBottom() {
        window.scrollTo(0, 650);
    }
    /**
     * page starts
     */
    ngOnInit() {
        setInterval(() => {
            this.currentLang = this.translationService.getCurrentLang();
        }, 1000);
        setInterval(() => {
            this.lang = sessionStorage.getItem('language');
        }, 1000);
        this.profile = JSON.parse(this.storageService.getItem('profile'));
        this.cartItem = this.storageService.getItem('cart') !== null ? JSON.parse(this.storageService.getItem('cart')) : [];
        this.getFood();
        if (this.profile !== null)
            this.getDefaultAddress();
    }
    /**
     * Get Food
     */
    getFood() {
        this.route.params.subscribe((params) => {
            this.foodId = params.id;
            this.productService.getSingleProduct(this.foodId).subscribe((response) => {
                if (response['status'] === true) {
                    this.food = response['$food_detail_data'][0];
                    this.food.selectedChoiceRadio = [];
                    this.food.selectedChoice = [];
                    this.selectedFoodPrice = response['$food_detail_data'][0].price;
                    this.food.itemTotal = response['$food_detail_data'][0].price;
                    this.review = response['reviews'];
                    console.log(response);
                }
            });
        });
    }
    /**
     * On quantity change
     * @param {object} event
     */
    onQuantityChange(event) {
        if (event !== null) {
            // this.quantity = event.target.value;
            this.quantity = event;
            this.updatePrice();
            this.updatedPrice();
        }
    }
    /**
     * Add to cart
     * @param {string} content
     */
    addToCart(content) {
        if (this.profile && this.profile.authId) {
            if (this.defaultAddress['status'] === false) {
                this.setModalService.setAddressModalStatus({
                    isAddressModalOpen: true,
                });
            }
            else {
                this.addItemToLocalCart();
            }
        }
        else {
            this.open(content);
        }
    }
    /**
     * addItemToLocalCart
     */
    addItemToLocalCart() {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            lodash__WEBPACK_IMPORTED_MODULE_1___default.a.map(this.food.choice_category, (item, index) => {
                let filteredChoice = [];
                if (item.min == 1 && item.max == 1) {
                    filteredChoice = lodash__WEBPACK_IMPORTED_MODULE_1___default.a.filter(this.food.selectedChoiceRadio, ['choice_category_id', item.id]);
                }
                else {
                    filteredChoice = lodash__WEBPACK_IMPORTED_MODULE_1___default.a.filter(this.food.selectedChoice, ['choice_category_id', item.id]);
                }
                this.setChoiceValidation(filteredChoice, item, index);
            });
            const canAddItem = lodash__WEBPACK_IMPORTED_MODULE_1___default.a.some(this.food.choice_category, ['canProceed', false]);
            console.log(this.quantity);
            if (canAddItem === false && this.quantity > 0) {
                const { itemExists, itemUniqueId } = yield this.checkCartItem();
                if (!itemExists) {
                    const json = {
                        id: this.food.food_id,
                        name: this.food.name,
                        ar_name: this.food.ar_name,
                        description: this.food.description,
                        ar_description: this.food.ar_description,
                        image: this.food.image,
                        price: this.food.price,
                        itemTotal: this.food.itemTotal,
                        priceTotal: this.food.priceTotal,
                        quantity: this.quantity,
                        discount_type: this.food.discount_type,
                        offer_amount: this.food.offer_amount,
                        itemUniqueId: Math.floor(Math.random() * 99980),
                        selectedChoiceRadio: this.food.selectedChoiceRadio,
                        selectedChoice: this.food.selectedChoice,
                        food_percentage_offer: this.food.food_percentage_offer,
                    };
                    this.cartItem.push(json);
                }
                else {
                    const index = lodash__WEBPACK_IMPORTED_MODULE_1___default.a.findIndex(this.cartItem, ['itemUniqueId', itemUniqueId]);
                    this.cartItem[index].quantity += this.quantity;
                    this.cartItem[index].itemTotal += this.food.itemTotal;
                }
                this.storageService.setItem('cart', JSON.stringify(this.cartItem));
                this.lang === 'AR' ? this.router.navigate(['/ar/cart']) : this.router.navigate(['/cart']);
            }
            else {
                if (this.quantity < 1) {
                    sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_2___default.a.fire({
                        icon: 'error',
                        title: yield this.translationService.translateText('TOAST.QUANTITY_VALIDATION'),
                        confirmButtonColor: '#432919',
                        confirmButtonText: yield this.translationService.translateText('TOAST.OK'),
                        customClass: {
                            container: this.lang === 'AR' ? 'font-Tajawal-Light' : 'font-Humanist777LightBT',
                        },
                    });
                }
            }
        });
    }
    /**
     * Check if food is present in cart already
     * @return {boolean}
     */
    checkCartItem() {
        let itemExists = false;
        let itemUniqueId;
        const itemInCart = lodash__WEBPACK_IMPORTED_MODULE_1___default.a.filter(this.cartItem, ['id', this.food.food_id]);
        if (itemInCart.length > 0) {
            lodash__WEBPACK_IMPORTED_MODULE_1___default.a.map(itemInCart, (item) => {
                itemUniqueId = item.itemUniqueId;
                if (this.food.selectedChoiceRadio.length === item.selectedChoiceRadio.length && this.food.selectedChoice.length === item.selectedChoice.length) {
                    const selectedChoiceRadio = lodash__WEBPACK_IMPORTED_MODULE_1___default.a.isEqual(this.food.selectedChoiceRadio, item.selectedChoiceRadio);
                    const selectedChoice = lodash__WEBPACK_IMPORTED_MODULE_1___default.a.isEqual(this.food.selectedChoice, item.selectedChoice);
                    (selectedChoiceRadio && selectedChoice) ? itemExists = true : itemExists = false;
                }
                else {
                    itemExists = false;
                }
            });
        }
        else {
            itemExists = false;
        }
        return ({ itemExists, itemUniqueId });
    }
    /**
     * Get default address
     */
    getDefaultAddress() {
        this.addressService.getDefaultAddress(this.profile.authId, this.profile.authToken).subscribe((response) => {
            this.defaultAddress = response;
        });
    }
    /**
     * Set choice radio
     * @param {object} choice
     * @param {boolean} categoryIndex
     */
    setChoice(choice, categoryIndex) {
        const category = this.food.choice_category[categoryIndex];
        const filteredChoice = lodash__WEBPACK_IMPORTED_MODULE_1___default.a.filter(this.food.selectedChoiceRadio, ['choice_category_id', choice.choice_category_id]);
        if (filteredChoice.length > 0)
            lodash__WEBPACK_IMPORTED_MODULE_1___default.a.remove(this.food.selectedChoiceRadio, ['choice_category_id', choice.choice_category_id]);
        this.food.selectedChoiceRadio.push({ id: choice.id, name: choice.name, ar_name: choice.ar_name, choice_category_id: choice.choice_category_id, price: choice.price });
        this.updatePrice();
        const filteredArray = lodash__WEBPACK_IMPORTED_MODULE_1___default.a.filter(this.food.selectedChoiceRadio, ['choice_category_id', choice.choice_category_id || category.id]);
        this.setChoiceValidation(filteredArray, category, categoryIndex);
    }
    /**
     * Set choice checkbox
     * @param {object} event
     * @param {object} choice
     * @param {boolean} categoryIndex
     */
    setChoices(event, choice, categoryIndex) {
        const category = this.food.choice_category[categoryIndex];
        if (event.target.checked) {
            this.food.selectedChoice.push({ id: choice.id, name: choice.name, ar_name: choice.ar_name, choice_category_id: choice.choice_category_id, price: choice.price });
        }
        else {
            lodash__WEBPACK_IMPORTED_MODULE_1___default.a.remove(this.food.selectedChoice, ['id', choice.id]);
        }
        this.updatePrice();
        this.updatedPrice();
        const filteredChoice = lodash__WEBPACK_IMPORTED_MODULE_1___default.a.filter(this.food.selectedChoice, ['choice_category_id', choice.choice_category_id || category.id]);
        this.setChoiceValidation(filteredChoice, category, categoryIndex);
    }
    /**
     * setRadioChoiceValidation
     * @param {object} filteredChoice
     * @param {boolean} category
     * @param {number} categoryIndex
     */
    setChoiceValidation(filteredChoice, category, categoryIndex) {
        if (filteredChoice.length >= category.min && filteredChoice.length <= category.max) {
            this.food.choice_category[categoryIndex].canProceed = true;
        }
        else {
            this.food.choice_category[categoryIndex].canProceed = false;
        }
    }
    /**
     * Update price
     */
    updatePrice() {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            let choiceValue = 0;
            yield lodash__WEBPACK_IMPORTED_MODULE_1___default.a.map(this.food.selectedChoiceRadio, (item) => choiceValue += item.price);
            yield lodash__WEBPACK_IMPORTED_MODULE_1___default.a.map(this.food.selectedChoice, (item) => choiceValue += item.price);
            this.food.priceTotal = choiceValue;
            this.food.itemTotal = (this.selectedFoodPrice * this.quantity) + ((choiceValue) * this.quantity);
        });
    }
    /**
     *
     * @param {object} event
     */
    gramQuantityChange(event) {
        if (event) {
            this.gramQuantity = event;
            this.updatedPrice();
        }
    }
    /**
     * price calculation
     */
    updatedPrice() {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            let choiceValue = 0;
            yield lodash__WEBPACK_IMPORTED_MODULE_1___default.a.map(this.food.selectedChoiceRadio, (item) => choiceValue += item.price);
            yield lodash__WEBPACK_IMPORTED_MODULE_1___default.a.map(this.food.selectedChoice, (item) => choiceValue += item.price);
            this.food.priceTotal = choiceValue;
            const kgToGram = this.quantity * 1000;
            const totalGrams = kgToGram + this.gramQuantity;
            const selectedQuantity = totalGrams / 1000;
            this.food.itemTotal = (this.selectedFoodPrice * selectedQuantity) + ((choiceValue) * selectedQuantity);
            console.log(this.quantity, this.gramQuantity, kgToGram, totalGrams, selectedQuantity, this.food.itemTotal);
        });
    }
    /**
     * check if choice is selected
     * @param {object} choice
     * @return {boolean}
     */
    checkChoiceSelected(choice) {
        return lodash__WEBPACK_IMPORTED_MODULE_1___default.a.some(this.food.selectedChoiceRadio, { id: choice.id, choice_category_id: choice.choice_category_id }) || lodash__WEBPACK_IMPORTED_MODULE_1___default.a.some(this.food.selectedChoice, { id: choice.id, choice_category_id: choice.choice_category_id });
    }
    /**
     * Open review modal
     */
    openReviewModal() {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            if (this.profile && this.profile.authId) {
                this.setModalService.setReviewModalStatus({
                    isReviewModalOpen: true,
                });
            }
            else {
                sweetalert2_dist_sweetalert2_js__WEBPACK_IMPORTED_MODULE_2___default.a.fire({
                    icon: 'info',
                    title: yield this.translationService.translateText('TOAST.PLEASE_LOGIN_TO_THE_ACCOUNT_TO_BE_ABLE_TO_EVALUATE'),
                    confirmButtonColor: '#432919',
                    confirmButtonText: yield this.translationService.translateText('TOAST.CLOSE'),
                    customClass: {
                        container: this.lang === 'AR' ? 'font-Tajawal-Light' : 'font-Humanist777LightBT',
                    },
                });
            }
        });
    }
}
SingleProductComponent.ɵfac = function SingleProductComponent_Factory(t) { return new (t || SingleProductComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](src_app_services_product_service__WEBPACK_IMPORTED_MODULE_5__["ProductService"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_ng_bootstrap_ng_bootstrap__WEBPACK_IMPORTED_MODULE_6__["NgbModal"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](src_app_services_modal_service__WEBPACK_IMPORTED_MODULE_7__["ModalService"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](src_app_services_storage_service__WEBPACK_IMPORTED_MODULE_8__["StorageService"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](src_app_services_address_service__WEBPACK_IMPORTED_MODULE_9__["AddressService"]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](src_app_services_translation_service__WEBPACK_IMPORTED_MODULE_10__["TranslationService"])); };
SingleProductComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({ type: SingleProductComponent, selectors: [["app-single-product"]], decls: 194, vars: 89, consts: [["setActive", "shop"], [1, "container-fluid"], [1, "row"], [1, "col-lg-12"], [1, "header-border", "singleProductPage", "full-width-custom"], [1, "banner", "banners", "direction-custom"], [1, "banner-title", 3, "ngClass"], [1, "breadcrumbs", 3, "ngClass"], [3, "routerLink"], [1, ""], [1, "product"], [1, "row", "prof-bottom"], [1, "col-md-6", "col-4", "pad-lr", "pr-0"], [1, "product-image", "text-right"], ["alt", "product", 1, "img-fluid", 3, "src"], [1, "col-md-6", "col-8"], [1, "product-tilte", 3, "ngClass"], [1, "product-review", "product-detail", 3, "ngClass"], [1, "rating"], [3, "rate", "starTemplate", "readonly", "max", "rateChange"], [1, "sin-web-view"], [1, "sin_mob_view"], [1, "sin_cust"], [1, "sin_rev"], [1, "product-rating", 3, "ngClass"], [1, "mb-3"], [1, "product-tax", 3, "ngClass"], [4, "ngIf"], [1, "product-add", "mb-3", 3, "ngClass"], ["type", "number", 1, "form-control", "ml-3", "direction-custom", 3, "ngModel", "ngModelChange"], [1, "product-add", 3, "ngClass"], [1, "btn", "roundedCorner", 3, "click"], [1, "col-lg-12", "product-addons"], [1, "titles", "addon-vertical-middle-align", 3, "ngClass"], [1, "product-addons-section"], ["class", "addons container-fluid", 4, "ngFor", "ngForOf"], [1, "col-lg-12", "product-price"], [1, "whole-area"], [1, "price"], ["class", "price-title", 3, "ngClass", 4, "ngIf"], ["class", "price-tax font-Humanist777BT-BlackCondensedB", 4, "ngIf"], ["class", "price-tax font-Tajawal-Light", 4, "ngIf"], [1, "product-add", "carts", 3, "ngClass"], [1, "btn", "roundedCorner", "text-uppercase", 3, "click"], [1, "col-lg-12", "info", "p-0"], [1, "info-additionalInfo"], [1, "titles", "info-vertical-middle-align", 3, "ngClass"], [1, "info-para-align", 3, "ngClass"], [1, "reviews", "comment-web-view"], [1, "review-title-section"], [1, "titles", "review-vertical-middle-align", 3, "ngClass"], [1, "webspace-view"], [1, "review-add", "reviews-vertical-middle-align", 3, "ngClass", "click"], [1, "font-size-custom"], ["aria-hidden", "true", 1, "fa", "fa-plus"], [1, "mobile-view"], [1, "review-detailed"], [1, "row", "m-0"], [1, "col-lg-3", "col-md-4", "col-sm-3", "pr-0"], [1, "review-detail", 3, "ngClass"], [1, "fa", "fa-star"], [1, "col-lg-12", "review-deatil-review"], [1, "col-lg-3", "col-md-3", "col-sm-3", "col-2"], [1, "review-star-detail"], ["src", "assets/images/shop/star.svg"], [1, "col-lg-7", "col-md-7", "col-sm-7", "col-7"], ["type", "warning", 3, "value"], [1, "col-lg-2", "col-md-2", "col-sm-2", "col-3", "pl-0"], [1, "col-lg-3", "col-md-3", "col-2"], [1, "col-lg-7", "col-md-7", "col-7"], [1, "col-lg-2", "col-md-2", "pl-0", "col-3"], [1, "col-lg-2", "col-md-2", "col-3", "pl-0"], [1, "col-lg-9", "col-md-8", "col-sm-9", "p-l-0", "pl-0", "review-border"], ["class", "row my-4", 4, "ngIf"], ["class", "review-rating-comment table-responsive", 3, "ngClass", 4, "ngIf"], ["class", "modal-dialog-centered"], ["content", ""], [3, "lang", "getAddress"], [3, "foodId", "updateReview"], ["rate", ""], [3, "ngClass"], [1, "addons", "container-fluid"], [1, "row", "mb-3"], [1, "product-addons-title", 3, "ngClass"], [1, "product-addons-desc", 3, "ngClass"], ["class", "col-md-4  col-12", 4, "ngFor", "ngForOf"], ["src", "assets/images/icons/alert.png", "width", "15", 1, "mr-2"], ["src", "assets/images/icons/success.png", "width", "15", 1, "mr-2"], [1, "col-md-4", "col-12"], [1, "form-check", "mb-3"], ["class", "form-check-input", "type", "radio", 3, "value", "name", "id", "checked", "click", 4, "ngIf"], ["class", "form-check-input", "type", "checkbox", 3, "value", "name", "id", "checked", "click", 4, "ngIf"], ["for", "flexRadioDefault1", 1, "form-check-label", 3, "ngClass"], [1, "choice-price"], ["type", "radio", 1, "form-check-input", 3, "value", "name", "id", "checked", "click"], ["type", "checkbox", 1, "form-check-input", 3, "value", "name", "id", "checked", "click"], [1, "price-title", 3, "ngClass"], [1, "price-tax", "font-Humanist777BT-BlackCondensedB"], [1, "small-font", 3, "ngClass"], [1, "price-tax", "font-Tajawal-Light"], [1, "row", "my-4"], [1, "text-center", 3, "ngClass"], [1, "review-rating-comment", "table-responsive", 3, "ngClass"], [1, "table"], [4, "ngFor", "ngForOf"], [1, "position-absolute", "w-100", "b-0", "pagination", "d-flex", "justify-content-center", "direction"], ["aria-label", "Default pagination", 3, "collectionSize", "pageSize", "page", "pageChange"], [1, "rating-head"], [1, "review-desc", 3, "ngClass"], [1, "modal-body"], [1, "container", "popup-login-design"], [1, "col-lg-6", "col-sm-12"], [1, "text-center"], [1, "btn-sign", "cursor_pointer", 3, "ngClass", "click"], [1, "star"], [1, "half"]], template: function SingleProductComponent_Template(rf, ctx) { if (rf & 1) {
        const _r46 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "app-header", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](4, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](5, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](6, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](7, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](10, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](11, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](12, "a", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](15, " / ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](16, "a", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](17);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](18, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](19);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](20, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](21, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](22, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](23, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](24, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](25, "div", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](26, "div", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](27, "img", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](28, "div", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](29, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](30, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](31, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](32);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](33, "div", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](34, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](35, "ngb-rating", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("rateChange", function SingleProductComponent_Template_ngb_rating_rateChange_35_listener($event) { return ctx.food.rating = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](36, "span", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](37, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](38, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](39, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](40, "3");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](41, "span", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](42, "Customer");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](43, "span", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](44, "Review");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](45, "div", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](46, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](47);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](48, "div", 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](49, "div", 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](50, SingleProductComponent_p_50_Template, 6, 8, "p", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](51, SingleProductComponent_p_51_Template, 6, 8, "p", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](52, "div", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](53, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](54);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](55, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](56, "input", 29);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("ngModelChange", function SingleProductComponent_Template_input_ngModelChange_56_listener($event) { return ctx.onQuantityChange($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](57, "div", 30);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](58, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](59, "button", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function SingleProductComponent_Template_button_click_59_listener() { return ctx.goToBottom(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](60);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](61, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](62, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](63, "div", 32);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](64, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](65, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](66, "div", 33);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](67);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](68, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](69, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](70, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](71, "div", 34);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](72, SingleProductComponent_div_72_Template, 12, 8, "div", 35);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](73, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](74, "div", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](75, "div", 37);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](76, "div", 38);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](77, SingleProductComponent_span_77_Template, 3, 4, "span", 39);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](78, SingleProductComponent_span_78_Template, 6, 8, "span", 40);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](79, SingleProductComponent_span_79_Template, 6, 8, "span", 41);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](80, "div", 42);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](81, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](82, "button", 43);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function SingleProductComponent_Template_button_click_82_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r46); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](188); return ctx.addToCart(_r8); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](83);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](84, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](85, "div", 9);
        _angular_core